/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.capabilities;

import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.capabilities.RemoteDriverCapabilities;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.remote.DesiredCapabilities;

public class BrowserStackRemoteDriverCapabilities
implements RemoteDriverCapabilities {
    private final EnvironmentVariables environmentVariables;

    public BrowserStackRemoteDriverCapabilities(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    @Override
    public String getUrl() {
        return ThucydidesSystemProperty.BROWSERSTACK_URL.from(this.environmentVariables);
    }

    @Override
    public DesiredCapabilities getCapabilities(DesiredCapabilities capabilities) {
        this.configureBrowserStackOs(capabilities);
        this.configureBrowserStackOsVersion(capabilities);
        this.configureBrowserStackBrowser(capabilities);
        this.configureBrowserStackBrowserVersion(capabilities);
        this.configureBrowserStackDevice(capabilities);
        this.configureBrowserStackDeviceOrientation(capabilities);
        this.configureBrowserStackProject(capabilities);
        this.configureBrowserStackBuild(capabilities);
        this.configureBrowserStackName(capabilities);
        this.configureBrowserStackLocal(capabilities);
        this.configureBrowserStackDebug(capabilities);
        this.configureBrowserStackResolution(capabilities);
        this.configureBrowserStackSeleniumVersion(capabilities);
        this.configureBrowserStackIeNoFlash(capabilities);
        this.configureBrowserStackIeDriver(capabilities);
        this.configureBrowserStackIeEnablePopups(capabilities);
        return capabilities;
    }

    private void configureBrowserStackOs(DesiredCapabilities capabilities) {
        String os = ThucydidesSystemProperty.BROWSERSTACK_OS.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)os)) {
            capabilities.setCapability("os", os);
        }
    }

    private void configureBrowserStackOsVersion(DesiredCapabilities capabilities) {
        String os_version = ThucydidesSystemProperty.BROWSERSTACK_OS_VERSION.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)os_version)) {
            capabilities.setCapability("os_version", os_version);
        }
    }

    private void configureBrowserStackBrowser(DesiredCapabilities capabilities) {
        String browser = ThucydidesSystemProperty.BROWSERSTACK_BROWSER.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)browser)) {
            capabilities.setCapability("browser", browser);
        }
    }

    private void configureBrowserStackBrowserVersion(DesiredCapabilities capabilities) {
        String browserVersion = ThucydidesSystemProperty.BROWSERSTACK_BROWSER_VERSION.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)browserVersion)) {
            capabilities.setCapability("browser_version", browserVersion);
        }
    }

    private void configureBrowserStackDevice(DesiredCapabilities capabilities) {
        String device = ThucydidesSystemProperty.BROWSERSTACK_DEVICE.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)device)) {
            capabilities.setCapability("device", device);
        }
    }

    private void configureBrowserStackDeviceOrientation(DesiredCapabilities capabilities) {
        String deviceOrientation = ThucydidesSystemProperty.BROWSERSTACK_DEVICE_ORIENTATION.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)deviceOrientation)) {
            capabilities.setCapability("deviceOrientation", deviceOrientation);
        }
    }

    private void configureBrowserStackProject(DesiredCapabilities capabilities) {
        String project = ThucydidesSystemProperty.BROWSERSTACK_PROJECT.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)project)) {
            capabilities.setCapability("project", project);
        }
    }

    private void configureBrowserStackBuild(DesiredCapabilities capabilities) {
        String build = ThucydidesSystemProperty.BROWSERSTACK_BUILD.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)build)) {
            capabilities.setCapability("build", build);
        }
    }

    private void configureBrowserStackName(DesiredCapabilities capabilities) {
        String name = ThucydidesSystemProperty.BROWSERSTACK_SESSION_NAME.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            capabilities.setCapability("name", name);
        }
    }

    private void configureBrowserStackLocal(DesiredCapabilities capabilities) {
        String local = ThucydidesSystemProperty.BROWSERSTACK_LOCAL.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)local)) {
            capabilities.setCapability("browserstack.local", local);
        }
    }

    private void configureBrowserStackDebug(DesiredCapabilities capabilities) {
        String debug = ThucydidesSystemProperty.BROWSERSTACK_DEBUG.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)debug)) {
            capabilities.setCapability("browserstack.debug", debug);
        }
    }

    private void configureBrowserStackResolution(DesiredCapabilities capabilities) {
        String resolution = ThucydidesSystemProperty.BROWSERSTACK_RESOLUTION.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)resolution)) {
            capabilities.setCapability("browserstack.resolution", resolution);
        }
    }

    private void configureBrowserStackSeleniumVersion(DesiredCapabilities capabilities) {
        String seleniumVersion = ThucydidesSystemProperty.BROWSERSTACK_SELENIUM_VERSION.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)seleniumVersion)) {
            capabilities.setCapability("browserstack.selenium_version", seleniumVersion);
        }
    }

    private void configureBrowserStackIeNoFlash(DesiredCapabilities capabilities) {
        String ieNoFlash = ThucydidesSystemProperty.BROWSERSTACK_IE_NO_FLASH.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)ieNoFlash)) {
            capabilities.setCapability("browserstack.ie.noFlash", ieNoFlash);
        }
    }

    private void configureBrowserStackIeDriver(DesiredCapabilities capabilities) {
        String ieDriver = ThucydidesSystemProperty.BROWSERSTACK_IE_DRIVER.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)ieDriver)) {
            capabilities.setCapability("browserstack.ie.driver", ieDriver);
        }
    }

    private void configureBrowserStackIeEnablePopups(DesiredCapabilities capabilities) {
        String ieEnablePopups = ThucydidesSystemProperty.BROWSERSTACK_IE_ENABLE_POPUPS.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)ieEnablePopups)) {
            capabilities.setCapability("browserstack.ie.enablePopups", ieEnablePopups);
        }
    }
}

