/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model.stacktrace;

import net.serenitybdd.core.exceptions.SerenityWebDriverException;
import net.thucydides.core.model.stacktrace.FailureCause;
import net.thucydides.core.model.stacktrace.StackTraceSanitizer;

public class RootCauseAnalyzer {
    private final Throwable thrownException;

    public RootCauseAnalyzer(Throwable thrownException) {
        this.thrownException = thrownException;
    }

    public FailureCause getRootCause() {
        Throwable originalException = this.originalExceptionFrom(this.thrownException);
        StackTraceSanitizer stackTraceSanitizer = StackTraceSanitizer.forStackTrace(originalException.getStackTrace());
        return new FailureCause(originalException, stackTraceSanitizer.getSanitizedStackTrace());
    }

    private Throwable originalExceptionFrom(Throwable thrownException) {
        if (thrownException instanceof SerenityWebDriverException) {
            return thrownException;
        }
        return thrownException.getCause() != null ? thrownException.getCause() : thrownException;
    }

    public String getClassname() {
        return this.getRootCause().getErrorType();
    }

    public String getMessage() {
        return this.getRootCause().getMessage();
    }
}

