/*
 * Decompiled with CFR 0.152.
 */
package net.scarlettsystems.android.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.PorterDuff;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import java.util.ArrayList;
import net.scarlettsystems.android.widget.Helpers;
import net.scarlettsystems.android.widget.R;

class ScarlettRecyclerAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private boolean mAnimationEnabled = true;
    private ArrayList<Object> mDataset = new ArrayList();
    private ArrayList<Integer> mTypeset = new ArrayList();
    private OnItemClickListener mItemClickListener = null;
    private OnItemLongClickListener mItemLongClickListener = null;
    private SparseArray<ItemViewListener> mItemViewListeners = new SparseArray();
    private ItemViewListener mErrorListener;
    private RecyclerView mRecyclerView;
    private LoaderHolder mLoaderHolder;
    private EmptyPromptHolder mEmptyPromptHolder;
    private View mEmptyPromptView;
    private View mDummyView;
    private Interpolator mLoaderShowInterpolator = new LinearInterpolator();
    private Interpolator mLoaderHideInterpolator = new LinearInterpolator();
    private int mDuration;
    private int mLoaderHeight = 100;
    private int[] mLoaderPadding = new int[]{0, 0, 0, 0};
    private static final int TYPE_LOADER = -1;
    private static final int TYPE_EMPTY_PROMPT = -2;

    ScarlettRecyclerAdapter() {
        this.setHasStableIds(true);
        this.mDataset.add(new LoaderObject());
        this.mDataset.add(new EmptyPromptObject());
        this.mErrorListener = new ItemViewListener(){

            @Override
            public View OnCreateItemView(ViewGroup parent) {
                Log.e((String)"EasyRecyclerView", (String)"View request for unrecognised item. Set OnCreateItemView or layout resource for this item type.");
                return new View(parent.getContext());
            }

            @Override
            public void OnBindItemView(View v, SparseArray<View> cache, Object item) {
                Log.e((String)"EasyRecyclerView", (String)"Bind request for unrecognised item. Set OnBindItemView for this item type.");
            }
        };
    }

    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.mRecyclerView = recyclerView;
        this.mDummyView = new View(recyclerView.getContext());
        if (this.mEmptyPromptView == null) {
            this.mEmptyPromptView = this.mDummyView;
        }
        this.mEmptyPromptHolder = new EmptyPromptHolder(this.mEmptyPromptView);
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == -1) {
            View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.net_scarlettsystems_android_widget_cardloader, parent, false);
            this.mLoaderHolder = new LoaderHolder(view);
            return this.mLoaderHolder;
        }
        if (viewType == -2) {
            return this.mEmptyPromptHolder;
        }
        if (viewType >= 0) {
            View view = ((ItemViewListener)this.mItemViewListeners.get(viewType, (Object)this.mErrorListener)).OnCreateItemView(parent);
            if (view == null) {
                throw new IllegalArgumentException("OnCreateItemView must return a view.");
            }
            return new ItemHolder(view);
        }
        throw new IllegalArgumentException();
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder vh, int position) {
        if (vh instanceof ItemHolder) {
            ItemHolder h = (ItemHolder)vh;
            h.setItem(this.mDataset.get(position));
            ((ItemViewListener)this.mItemViewListeners.get(this.mTypeset.get(position).intValue(), (Object)this.mErrorListener)).OnBindItemView(h.getView(), h.getViewCache(), h.getItem());
        }
    }

    void setEmptyPromptView(View v) {
        this.mEmptyPromptHolder = v == null ? new EmptyPromptHolder(this.mDummyView) : new EmptyPromptHolder(v);
    }

    void setOnItemClickListener(OnItemClickListener l) {
        this.mItemClickListener = l;
    }

    void setOnItemLongClickListener(OnItemLongClickListener l) {
        this.mItemLongClickListener = l;
    }

    void addOnItemViewListener(ItemViewListener l, int typeCode) {
        this.mItemViewListeners.append(typeCode, (Object)l);
    }

    void removeOnItemViewListener(int typeCode) {
        this.mItemViewListeners.remove(typeCode);
    }

    void clearOnItemViewListeners() {
        this.mItemViewListeners.clear();
    }

    void setAnimationDuration(int value) {
        this.mDuration = value;
    }

    void setLoaderHeight(int value) {
        this.mLoaderHeight = value;
    }

    Object getItem(int index) {
        if (index >= this.getItemCountProtected()) {
            throw new IndexOutOfBoundsException();
        }
        return this.mDataset.get(index);
    }

    ArrayList<Object> getItems(int startIndex, int count) {
        return new ArrayList<Object>(this.mDataset.subList(startIndex, startIndex + count));
    }

    ArrayList<Object> getItems() {
        return new ArrayList<Object>(this.mDataset.subList(0, this.getItemCountProtected()));
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemCount() {
        return this.mDataset.size();
    }

    public int getItemCountProtected() {
        return this.mDataset.size() - 2;
    }

    public int getItemViewType(int position) {
        if (this.mDataset.get(position) instanceof LoaderObject) {
            return -1;
        }
        if (this.mDataset.get(position) instanceof EmptyPromptObject) {
            return -2;
        }
        int index = this.mTypeset.get(position);
        if (index == -1) {
            throw new IllegalStateException();
        }
        return index;
    }

    void addItem(Object item, int typeCode) {
        this.mDataset.add(this.getItemCountProtected(), item);
        this.mTypeset.add(typeCode);
        this.notifyInternal();
        this.notifyItemInserted(this.getItemCountProtected());
    }

    void addItems(ArrayList<?> items, int typeCode) {
        this.mDataset.addAll(this.getItemCountProtected(), items);
        for (int c = 0; c < items.size(); ++c) {
            this.mTypeset.add(typeCode);
        }
        this.notifyInternal();
        this.notifyItemRangeInserted(this.getItemCountProtected(), items.size());
    }

    void addItemAt(Object item, int index, int typeCode) {
        this.mDataset.add(index, item);
        this.mTypeset.add(index, typeCode);
        this.notifyInternal();
        this.notifyItemInserted(index);
    }

    void removeItem(int index) {
        if (index >= this.getItemCountProtected()) {
            Log.e((String)"SRA", (String)"nope");
        }
        this.mDataset.remove(index);
        this.mTypeset.remove(index);
        this.notifyInternal();
        this.notifyItemRemoved(index);
    }

    void replaceItem(Object item, int index, int typeCode) {
        this.mDataset.set(index, item);
        this.mTypeset.set(index, typeCode);
        this.notifyInternal();
        this.notifyItemChanged(index);
    }

    void removeAll() {
        int originalItemCount = this.getItemCountProtected();
        Object loader = this.mDataset.get(originalItemCount);
        Object emptyPrompt = this.mDataset.get(originalItemCount + 1);
        this.mDataset.clear();
        this.mTypeset.clear();
        this.mDataset.add(loader);
        this.mDataset.add(emptyPrompt);
        this.notifyItemRangeRemoved(0, originalItemCount);
    }

    int indexOf(Object item) {
        return this.mDataset.indexOf(item);
    }

    void showLoader() {
        if (this.mLoaderHolder == null) {
            return;
        }
        this.mLoaderHolder.showLoader();
    }

    void hideLoader() {
        if (this.mLoaderHolder == null) {
            return;
        }
        this.mLoaderHolder.hideLoader();
    }

    boolean isLoaderShown() {
        return this.mLoaderHolder != null && this.mLoaderHolder.isShown();
    }

    void showEmptyPrompt() {
        if (this.mEmptyPromptHolder == null) {
            return;
        }
        this.mEmptyPromptHolder.showEmptyPrompt();
    }

    void hideEmptyPrompt() {
        if (this.mEmptyPromptHolder == null) {
            return;
        }
        this.mEmptyPromptHolder.hideEmptyPrompt();
    }

    void notifyInternal() {
        if (this.getItemCountProtected() == 0) {
            this.showEmptyPrompt();
        } else {
            this.hideEmptyPrompt();
        }
    }

    void setAnimationEnabled(boolean enabled) {
        this.mAnimationEnabled = enabled;
    }

    void setLoaderPadding(int padding) {
        for (int c = 0; c < this.mLoaderPadding.length; ++c) {
            this.mLoaderPadding[c] = padding;
        }
    }

    void setLoaderPaddingTop(int padding) {
        this.mLoaderPadding[1] = padding;
    }

    void setLoaderPaddingBottom(int padding) {
        this.mLoaderPadding[3] = padding;
    }

    void setLoaderColour(int colour) {
        this.mLoaderHolder.setLoaderColour(colour);
    }

    void setLoaderShowInterpolator(Interpolator interpolator) {
        this.mLoaderShowInterpolator = interpolator;
    }

    void setLoaderHideInterpolator(Interpolator interpolator) {
        this.mLoaderHideInterpolator = interpolator;
    }

    void setBottomPadding(int padding) {
        this.mLoaderHolder.setBottomPadding(padding);
    }

    public static interface ItemViewListener {
        public View OnCreateItemView(ViewGroup var1);

        public void OnBindItemView(View var1, SparseArray<View> var2, Object var3);
    }

    public static interface OnItemLongClickListener {
        public void OnItemLongClick(View var1, Object var2);
    }

    public static interface OnItemClickListener {
        public void OnItemClick(View var1, Object var2);
    }

    private class EmptyPromptObject {
        private EmptyPromptObject() {
        }
    }

    private class LoaderObject {
        private LoaderObject() {
        }
    }

    private class LoaderHolder
    extends ViewHolder {
        private RelativeLayout loaderContainer;
        private RelativeLayout paddingView;
        private ProgressBar loader;
        private boolean isShown;

        LoaderHolder(View itemView) {
            super(itemView);
            this.isShown = false;
            this.paddingView = (RelativeLayout)itemView.findViewById(R.id.net_scarlettsystems_android_widget_cardloader_padding);
            this.loaderContainer = (RelativeLayout)itemView.findViewById(R.id.net_scarlettsystems_android_widget_cardloader_loader_container);
            this.loader = (ProgressBar)itemView.findViewById(R.id.net_scarlettsystems_android_widget_cardloader_loader);
            Helpers.setViewHeight((View)this.loader, 0);
            if (itemView.getLayoutParams() instanceof StaggeredGridLayoutManager.LayoutParams) {
                StaggeredGridLayoutManager.LayoutParams layoutParams = new StaggeredGridLayoutManager.LayoutParams(-1, -2);
                layoutParams.setFullSpan(true);
                itemView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        }

        void showLoader() {
            this.loaderContainer.setVisibility(0);
            if (ScarlettRecyclerAdapter.this.mAnimationEnabled) {
                ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{0, ScarlettRecyclerAdapter.this.mLoaderHeight});
                animator.setDuration((long)ScarlettRecyclerAdapter.this.mDuration);
                animator.setInterpolator((TimeInterpolator)ScarlettRecyclerAdapter.this.mLoaderShowInterpolator);
                animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animator) {
                        int[] pad = new int[]{0, 0, 0, 0};
                        for (int c = 0; c < ScarlettRecyclerAdapter.this.mLoaderPadding.length; ++c) {
                            pad[c] = Math.round((float)ScarlettRecyclerAdapter.this.mLoaderPadding[c] * animator.getAnimatedFraction());
                        }
                        Helpers.setViewHeight((View)LoaderHolder.this.loader, (Integer)animator.getAnimatedValue());
                        LoaderHolder.this.loaderContainer.setPadding(pad[0], pad[1], pad[2], pad[3]);
                        ScarlettRecyclerAdapter.this.mRecyclerView.scrollToPosition(ScarlettRecyclerAdapter.this.mRecyclerView.getLayoutManager().getItemCount() - 1);
                    }
                });
                animator.start();
            } else {
                this.loaderContainer.setPadding(ScarlettRecyclerAdapter.this.mLoaderPadding[0], ScarlettRecyclerAdapter.this.mLoaderPadding[1], ScarlettRecyclerAdapter.this.mLoaderPadding[2], ScarlettRecyclerAdapter.this.mLoaderPadding[3]);
                Helpers.setViewHeight((View)this.loader, ScarlettRecyclerAdapter.this.mLoaderHeight);
            }
            this.isShown = true;
        }

        void hideLoader() {
            if (ScarlettRecyclerAdapter.this.mAnimationEnabled) {
                final int[] initPad = new int[]{this.loaderContainer.getPaddingLeft(), this.loaderContainer.getPaddingTop(), this.loaderContainer.getPaddingRight(), this.loaderContainer.getPaddingBottom()};
                ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{this.loader.getHeight(), 0});
                animator.setDuration((long)ScarlettRecyclerAdapter.this.mDuration);
                animator.setInterpolator((TimeInterpolator)ScarlettRecyclerAdapter.this.mLoaderHideInterpolator);
                animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animator) {
                        int[] pad = new int[]{0, 0, 0, 0};
                        for (int c = 0; c < ScarlettRecyclerAdapter.this.mLoaderPadding.length; ++c) {
                            pad[c] = Math.round((float)initPad[c] * (1.0f - animator.getAnimatedFraction()));
                        }
                        LoaderHolder.this.loaderContainer.setPadding(pad[0], pad[1], pad[2], pad[3]);
                        Helpers.setViewHeight((View)LoaderHolder.this.loader, (Integer)animator.getAnimatedValue());
                    }
                });
                animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        LoaderHolder.this.loaderContainer.setVisibility(8);
                    }
                });
                animator.start();
            } else {
                this.loaderContainer.setPadding(0, 0, 0, 0);
                Helpers.setViewHeight((View)this.loader, 0);
                this.loaderContainer.setVisibility(8);
            }
            this.isShown = false;
        }

        boolean isShown() {
            return this.isShown;
        }

        void setBottomPadding(int padding) {
            Helpers.setViewHeight((View)this.paddingView, padding);
        }

        void setLoaderColour(int colour) {
            this.loader.getIndeterminateDrawable().setColorFilter(colour, PorterDuff.Mode.SRC_IN);
        }

        public void onClick(View view) {
        }

        public boolean onLongClick(View view) {
            return false;
        }
    }

    private class EmptyPromptHolder
    extends ViewHolder {
        private View mView;
        private boolean isShown;

        EmptyPromptHolder(View itemView) {
            super(itemView);
            this.mView = itemView;
        }

        public void onClick(View view) {
        }

        public boolean onLongClick(View view) {
            return false;
        }

        void showEmptyPrompt() {
            this.mView.setVisibility(0);
            if (ScarlettRecyclerAdapter.this.mAnimationEnabled) {
                ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
                animator.setDuration((long)ScarlettRecyclerAdapter.this.mDuration);
                animator.setInterpolator((TimeInterpolator)ScarlettRecyclerAdapter.this.mLoaderShowInterpolator);
                animator.setStartDelay((long)ScarlettRecyclerAdapter.this.mDuration);
                animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animator) {
                        EmptyPromptHolder.this.mView.setAlpha(animator.getAnimatedFraction());
                    }
                });
                animator.start();
            } else {
                this.mView.setAlpha(1.0f);
            }
            this.isShown = true;
        }

        void hideEmptyPrompt() {
            if (ScarlettRecyclerAdapter.this.mAnimationEnabled) {
                ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
                animator.setDuration((long)ScarlettRecyclerAdapter.this.mDuration);
                animator.setInterpolator((TimeInterpolator)ScarlettRecyclerAdapter.this.mLoaderShowInterpolator);
                animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animator) {
                        EmptyPromptHolder.this.mView.setAlpha(1.0f - animator.getAnimatedFraction());
                        if (animator.getAnimatedFraction() == 1.0f) {
                            // empty if block
                        }
                    }
                });
                animator.start();
            }
            this.isShown = false;
        }
    }

    private class ItemHolder
    extends ViewHolder {
        private View mView;
        private Object mItem;
        private SparseArray<View> mChildViewCache;

        ItemHolder(View view) {
            super(view);
            this.mChildViewCache = new SparseArray();
            this.mView = view;
            view.setOnClickListener((View.OnClickListener)this);
            view.setOnLongClickListener((View.OnLongClickListener)this);
            this.cacheChildren(this.mView);
        }

        public void onClick(View v) {
            if (ScarlettRecyclerAdapter.this.mItemClickListener == null) {
                return;
            }
            ScarlettRecyclerAdapter.this.mItemClickListener.OnItemClick(v, this.mItem);
        }

        public boolean onLongClick(View v) {
            if (ScarlettRecyclerAdapter.this.mItemLongClickListener == null) {
                return false;
            }
            ScarlettRecyclerAdapter.this.mItemLongClickListener.OnItemLongClick(v, this.mItem);
            return true;
        }

        void cacheChildren(View view) {
            this.mChildViewCache.append(view.getId(), (Object)view);
            if (view instanceof ViewGroup) {
                for (int c = 0; c < ((ViewGroup)view).getChildCount(); ++c) {
                    this.cacheChildren(((ViewGroup)view).getChildAt(c));
                }
            }
        }

        void setItem(Object item) {
            this.mItem = item;
        }

        Object getItem() {
            return this.mItem;
        }

        public View getView() {
            return this.mView;
        }

        SparseArray<View> getViewCache() {
            return this.mChildViewCache;
        }
    }

    private abstract class ViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener,
    View.OnLongClickListener {
        ViewHolder(View itemView) {
            super(itemView);
        }
    }
}

