/*
 * Decompiled with CFR 0.152.
 */
package net.scarlettsystems.android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.app.Fragment;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.app.AppCompatActivity;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import net.scarlettsystems.android.widget.R;
import net.scarlettsystems.android.widget.ScarlettPagerAdapter;
import net.scarlettsystems.android.widget.ViewWrapperFragment;

public class EasyViewPager
extends ViewPager {
    private ScarlettPagerAdapter mAdapter;
    private boolean mSwipeable = true;

    public EasyViewPager(Context context) {
        super(context);
        this.initialise();
    }

    public EasyViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.applyAttributes(context, attrs);
        this.initialise();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyAttributes(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.EasyViewPager, 0, 0);
        try {
            this.mSwipeable = ta.getBoolean(R.styleable.EasyViewPager_swipeable, true);
        }
        finally {
            ta.recycle();
        }
    }

    private void initialise() {
        this.mAdapter = new ScarlettPagerAdapter(((AppCompatActivity)this.getContext()).getSupportFragmentManager());
        this.setAdapter((PagerAdapter)this.mAdapter);
    }

    public void addPage(View view) {
        ViewWrapperFragment fragment = new ViewWrapperFragment();
        fragment.setView(view);
        this.mAdapter.addFragment(fragment);
    }

    public void addPage(View view, int index) {
        ViewWrapperFragment fragment = new ViewWrapperFragment();
        fragment.setView(view);
        this.mAdapter.addFragment(fragment, index);
    }

    public void addPage(Fragment fragment) {
        this.mAdapter.addFragment(fragment);
    }

    public void addPage(Fragment fragment, int index) {
        this.mAdapter.addFragment(fragment, index);
    }

    public Object getPage(int index) {
        return this.mAdapter.getFragment(index);
    }

    public void removePage(int index) {
        this.mAdapter.removeFragment(index);
    }

    public void enableSwipe() {
        this.mSwipeable = true;
    }

    public void disableSwipe() {
        this.mSwipeable = false;
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        return this.mSwipeable && super.onInterceptTouchEvent(event);
    }

    public boolean onTouchEvent(MotionEvent event) {
        return this.mSwipeable && super.onTouchEvent(event);
    }
}

