/*
 * Decompiled with CFR 0.152.
 */
package net.redhogs.cronparser.builder;

import java.text.MessageFormat;
import net.redhogs.cronparser.I18nMessages;
import net.redhogs.cronparser.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public abstract class AbstractDescriptionBuilder {
    protected final char[] SpecialCharsMinusStar = new char[]{'/', '-', ','};

    public String getSegmentDescription(String expression, String allDescription) {
        String description = "";
        if (StringUtils.isEmpty((CharSequence)expression)) {
            description = "";
        } else if ("*".equals(expression)) {
            description = allDescription;
        } else if (!StringUtils.containsAny((CharSequence)expression, (char[])this.SpecialCharsMinusStar)) {
            description = MessageFormat.format(this.getDescriptionFormat(expression), this.getSingleItemDescription(expression));
        } else if (expression.contains("/")) {
            String[] segments = expression.split("/");
            description = MessageFormat.format(this.getIntervalDescriptionFormat(segments[1]), this.getSingleItemDescription(segments[1]));
            if (segments[0].contains("-")) {
                String betweenSegmentOfInterval = segments[0];
                String[] betweenSegments = betweenSegmentOfInterval.split("-");
                description = description + ", " + MessageFormat.format(this.getBetweenDescriptionFormat(betweenSegmentOfInterval, false), this.getSingleItemDescription(betweenSegments[0]), this.getSingleItemDescription(betweenSegments[1]));
            }
        } else if (expression.contains(",")) {
            String[] segments = expression.split(",");
            StringBuilder descriptionContent = new StringBuilder();
            for (int i = 0; i < segments.length; ++i) {
                if (i > 0 && segments.length > 2 && i < segments.length - 1) {
                    descriptionContent.append(", ");
                }
                if (i > 0 && segments.length > 1 && (i == segments.length - 1 || segments.length == 2)) {
                    if (this.needSpaceBetweenWords().booleanValue()) {
                        descriptionContent.append(" ");
                    }
                    descriptionContent.append(I18nMessages.get("and"));
                    if (this.needSpaceBetweenWords().booleanValue()) {
                        descriptionContent.append(" ");
                    }
                }
                if (segments[i].contains("-")) {
                    String[] betweenSegments = segments[i].split("-");
                    descriptionContent.append(MessageFormat.format(this.getBetweenDescriptionFormat(expression, true), this.getSingleItemDescription(betweenSegments[0]), this.getSingleItemDescription(betweenSegments[1])));
                    continue;
                }
                descriptionContent.append(this.getSingleItemDescription(segments[i]));
            }
            description = MessageFormat.format(this.getDescriptionFormat(expression), descriptionContent.toString());
        } else if (expression.contains("-")) {
            String[] segments = expression.split("-");
            description = MessageFormat.format(this.getBetweenDescriptionFormat(expression, false), this.getSingleItemDescription(segments[0]), this.getSingleItemDescription(segments[1]));
        }
        return description;
    }

    protected abstract String getBetweenDescriptionFormat(String var1, boolean var2);

    protected abstract String getIntervalDescriptionFormat(String var1);

    protected abstract String getSingleItemDescription(String var1);

    protected abstract String getDescriptionFormat(String var1);

    protected abstract Boolean needSpaceBetweenWords();

    @Deprecated
    protected String plural(int num, String singular, String plural) {
        return this.plural(String.valueOf(num), singular, plural);
    }

    protected String plural(String expression, String singular, String plural) {
        if (NumberUtils.isNumber((String)expression) && Integer.parseInt(expression) > 1) {
            return plural;
        }
        if (StringUtils.contains((CharSequence)expression, (CharSequence)",")) {
            return plural;
        }
        return singular;
    }

    protected String getSpace(Options options) {
        return options.isNeedSpaceBetweenWords() ? " " : "";
    }
}

