/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.pyro.serializer;

import java.io.IOException;
import java.util.Map;
import java.util.Scanner;
import net.razorvine.pyro.PyroException;
import net.razorvine.pyro.serializer.SerpentSerializer;

public abstract class PyroSerializer {
    protected static SerpentSerializer serpentSerializer;

    public abstract byte getSerializerId();

    public abstract byte[] serializeCall(String var1, String var2, Object[] var3, Map<String, Object> var4) throws IOException;

    public abstract byte[] serializeData(Object var1) throws IOException;

    public abstract Object deserializeData(byte[] var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PyroSerializer getSerpentSerializer() {
        Class<PyroSerializer> clazz = PyroSerializer.class;
        synchronized (PyroSerializer.class) {
            if (serpentSerializer == null) {
                try {
                    serpentSerializer = new SerpentSerializer();
                    String requiredSerpentVersion = "1.23";
                    if (PyroSerializer.compareLibraryVersions("1.40", "1.23") < 0) {
                        throw new RuntimeException("serpent version 1.23 (or newer) is required");
                    }
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return serpentSerializer;
                }
                catch (LinkageError x) {
                    throw new PyroException("serpent serializer unavailable", x);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return serpentSerializer;
        }
    }

    public static PyroSerializer getFor(int serializer_id) {
        if (serpentSerializer != null && serializer_id == serpentSerializer.getSerializerId()) {
            return serpentSerializer;
        }
        throw new IllegalArgumentException("unsupported serializer id: " + serializer_id);
    }

    public static int compareLibraryVersions(String actual, String other) {
        Scanner s1 = new Scanner(actual);
        Scanner s2 = new Scanner(other);
        s1.useDelimiter("\\.");
        s2.useDelimiter("\\.");
        while (s1.hasNextInt() && s2.hasNextInt()) {
            int v2;
            int v1 = s1.nextInt();
            if (v1 < (v2 = s2.nextInt())) {
                s1.close();
                s2.close();
                return -1;
            }
            if (v1 <= v2) continue;
            s1.close();
            s2.close();
            return 1;
        }
        int result = 0;
        if (s1.hasNextInt()) {
            result = 1;
        }
        s1.close();
        s2.close();
        return result;
    }
}

