/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.pyro.serializer;

import java.io.IOException;
import java.util.Map;
import net.razorvine.pyro.Config;
import net.razorvine.pyro.PyroException;
import net.razorvine.pyro.PyroProxy;
import net.razorvine.pyro.PyroURI;
import net.razorvine.pyro.serializer.PyroExceptionSerpent;
import net.razorvine.pyro.serializer.PyroProxySerpent;
import net.razorvine.pyro.serializer.PyroSerializer;
import net.razorvine.pyro.serializer.PyroUriSerpent;
import net.razorvine.serpent.IClassSerializer;
import net.razorvine.serpent.IDictToInstance;
import net.razorvine.serpent.Parser;
import net.razorvine.serpent.Serializer;
import net.razorvine.serpent.ast.Ast;

public class SerpentSerializer
extends PyroSerializer {
    @Override
    public byte getSerializerId() {
        return 1;
    }

    @Override
    public byte[] serializeCall(String objectId, String method, Object[] vargs, Map<String, Object> kwargs) throws IOException {
        Serializer s = new Serializer(Config.SERPENT_INDENT, true);
        Object[] invokeparams = new Object[]{objectId, method, vargs, kwargs};
        return s.serialize((Object)invokeparams);
    }

    @Override
    public byte[] serializeData(Object obj) throws IOException {
        Serializer s = new Serializer(Config.SERPENT_INDENT, true);
        return s.serialize(obj);
    }

    @Override
    public Object deserializeData(byte[] data) throws IOException {
        Parser p = new Parser();
        Ast ast = p.parse(data);
        DictConverter dictConverter = new DictConverter();
        return ast.getData((IDictToInstance)dictConverter);
    }

    public static byte[] toBytes(Object obj) {
        return Parser.toBytes((Object)obj);
    }

    static {
        Serializer.registerClass(PyroURI.class, (IClassSerializer)new PyroUriSerpent());
        Serializer.registerClass(PyroException.class, (IClassSerializer)new PyroExceptionSerpent());
        Serializer.registerClass(PyroProxy.class, (IClassSerializer)new PyroProxySerpent());
    }

    class DictConverter
    implements IDictToInstance {
        DictConverter() {
        }

        public Object convert(Map<Object, Object> dict) throws IOException {
            boolean isException;
            String classname = (String)dict.get("__class__");
            boolean bl = isException = dict.containsKey("__exception__") && (Boolean)dict.get("__exception__") != false;
            if (isException) {
                return PyroExceptionSerpent.FromSerpentDict(dict);
            }
            if ("Pyro5.core.URI".equals(classname)) {
                return PyroUriSerpent.FromSerpentDict(dict);
            }
            if ("Pyro5.client.Proxy".equals(classname)) {
                return PyroProxySerpent.FromSerpentDict(dict);
            }
            return null;
        }
    }
}

