/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json.schema.validation;

import io.kjson.JSONArray;
import io.kjson.JSONValue;
import io.kjson.pointer.IndexOpKt;
import io.kjson.pointer.JSONPointer;
import java.net.URI;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.pwall.json.schema.JSONSchema;
import net.pwall.json.schema.output.BasicErrorEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0016J\u001a\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J$\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0013\u0010\u0012\u001a\u00020\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002\u00a8\u0006\u0016"}, d2={"Lnet/pwall/json/schema/validation/UniqueItemsValidator;", "Lnet/pwall/json/schema/JSONSchema$Validator;", "uri", "Ljava/net/URI;", "location", "Lio/kjson/pointer/JSONPointer;", "<init>", "(Ljava/net/URI;Lio/kjson/pointer/JSONPointer;)V", "childLocation", "pointer", "validate", "", "json", "Lio/kjson/JSONValue;", "instanceLocation", "getErrorEntry", "Lnet/pwall/json/schema/output/BasicErrorEntry;", "relativeLocation", "equals", "other", "", "Companion", "json-kotlin-schema"})
public final class UniqueItemsValidator
extends JSONSchema.Validator {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public UniqueItemsValidator(@Nullable URI uri, @NotNull JSONPointer location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        super(uri, location);
    }

    @Override
    @NotNull
    public JSONPointer childLocation(@NotNull JSONPointer pointer) {
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        return pointer.child("uniqueItems");
    }

    @Override
    public boolean validate(@Nullable JSONValue json, @NotNull JSONPointer instanceLocation) {
        Intrinsics.checkNotNullParameter((Object)instanceLocation, (String)"instanceLocation");
        JSONValue instance = IndexOpKt.get((JSONValue)json, (JSONPointer)instanceLocation);
        return !(instance instanceof JSONArray) || Companion.uniqueItems((JSONArray)instance);
    }

    @Override
    @Nullable
    public BasicErrorEntry getErrorEntry(@NotNull JSONPointer relativeLocation, @Nullable JSONValue json, @NotNull JSONPointer instanceLocation) {
        Intrinsics.checkNotNullParameter((Object)relativeLocation, (String)"relativeLocation");
        Intrinsics.checkNotNullParameter((Object)instanceLocation, (String)"instanceLocation");
        JSONValue instance = IndexOpKt.get((JSONValue)json, (JSONPointer)instanceLocation);
        return !(instance instanceof JSONArray) || Companion.uniqueItems((JSONArray)instance) ? null : this.createBasicErrorEntry(relativeLocation, instanceLocation, "Array items not unique");
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof UniqueItemsValidator && super.equals(other);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lnet/pwall/json/schema/validation/UniqueItemsValidator$Companion;", "", "<init>", "()V", "uniqueItems", "", "array", "Lio/kjson/JSONArray;", "json-kotlin-schema"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean uniqueItems(@NotNull JSONArray array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            return CollectionsKt.toHashSet((Iterable)((Iterable)array)).size() == array.size();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

