/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json.schema.parser;

import io.kjson.JSON;
import io.kjson.JSONArray;
import io.kjson.JSONBoolean;
import io.kjson.JSONDecimal;
import io.kjson.JSONLong;
import io.kjson.JSONNumber;
import io.kjson.JSONObject;
import io.kjson.JSONPrimitive;
import io.kjson.JSONString;
import io.kjson.JSONValue;
import io.kjson.pointer.FindKt;
import io.kjson.pointer.IndexOpKt;
import io.kjson.pointer.JSONPointer;
import io.kjson.resource.ResourceLoader;
import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.pwall.json.schema.JSONSchema;
import net.pwall.json.schema.JSONSchemaException;
import net.pwall.json.schema.output.BasicOutput;
import net.pwall.json.schema.parser.InputDetails;
import net.pwall.json.schema.parser.JSONReader;
import net.pwall.json.schema.parser.Parser;
import net.pwall.json.schema.subschema.AdditionalItemsSchema;
import net.pwall.json.schema.subschema.AdditionalPropertiesSchema;
import net.pwall.json.schema.subschema.AllOfSchema;
import net.pwall.json.schema.subschema.AnyOfSchema;
import net.pwall.json.schema.subschema.ExtensionSchema;
import net.pwall.json.schema.subschema.IfThenElseSchema;
import net.pwall.json.schema.subschema.ItemsArraySchema;
import net.pwall.json.schema.subschema.ItemsSchema;
import net.pwall.json.schema.subschema.OneOfSchema;
import net.pwall.json.schema.subschema.PatternPropertiesSchema;
import net.pwall.json.schema.subschema.PropertiesSchema;
import net.pwall.json.schema.subschema.PropertyNamesSchema;
import net.pwall.json.schema.subschema.RefSchema;
import net.pwall.json.schema.subschema.RequiredSchema;
import net.pwall.json.schema.validation.ArrayValidator;
import net.pwall.json.schema.validation.ConstValidator;
import net.pwall.json.schema.validation.ContainsValidator;
import net.pwall.json.schema.validation.DefaultValidator;
import net.pwall.json.schema.validation.DelegatingValidator;
import net.pwall.json.schema.validation.EnumValidator;
import net.pwall.json.schema.validation.FormatValidator;
import net.pwall.json.schema.validation.NumberValidator;
import net.pwall.json.schema.validation.PatternValidator;
import net.pwall.json.schema.validation.PropertiesValidator;
import net.pwall.json.schema.validation.StringValidator;
import net.pwall.json.schema.validation.TypeValidator;
import net.pwall.json.schema.validation.UniqueItemsValidator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008e\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 w2\u00020\u0001:\u0002wxB'\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ$\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\r2\u0006\u0010.\u001a\u00020\f2\b\u0010/\u001a\u0004\u0018\u00010\u0006H\u0002J$\u00100\u001a\u0004\u0018\u00010\u000b2\u0006\u00101\u001a\u0002022\b\u0010/\u001a\u0004\u0018\u00010\u00062\u0006\u0010.\u001a\u00020\fH\u0002J\u001a\u00103\u001a\u00020*2\u0006\u00104\u001a\u00020\r2\b\u0010/\u001a\u0004\u0018\u00010\u0006H\u0002J\u000e\u00103\u001a\u00020*2\u0006\u00105\u001a\u000206J\u000e\u00103\u001a\u00020*2\u0006\u0010/\u001a\u00020\u0006J\u000e\u00103\u001a\u00020*2\u0006\u00107\u001a\u000208J\u001a\u00103\u001a\u00020*2\u0006\u00109\u001a\u00020\u000b2\n\b\u0002\u0010/\u001a\u0004\u0018\u00010\u0006J,\u0010:\u001a\u00020;2\u0006\u0010.\u001a\u00020\f2\b\u0010/\u001a\u0004\u0018\u00010\u00062\u0006\u0010<\u001a\u00020=2\b\u0010>\u001a\u0004\u0018\u00010\rH\u0002J&\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010.\u001a\u00020\f2\b\u0010/\u001a\u0004\u0018\u00010\u00062\b\u0010>\u001a\u0004\u0018\u00010\rH\u0002JT\u0010A\u001a\u00020*2\u0006\u00104\u001a\u00020\r2\u0006\u0010.\u001a\u00020\f2\b\u0010/\u001a\u0004\u0018\u00010\u00062\b\u0010B\u001a\u0004\u0018\u00010\r2&\u0010C\u001a\"\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0E\u0012\u0004\u0012\u00020*0DH\u0002J\"\u0010F\u001a\u00020G2\u0006\u00104\u001a\u00020\r2\u0006\u0010.\u001a\u00020\f2\b\u0010/\u001a\u0004\u0018\u00010\u0006H\u0002J\"\u0010H\u001a\u00020*2\u0006\u00104\u001a\u00020\r2\u0006\u0010.\u001a\u00020\f2\b\u0010I\u001a\u0004\u0018\u00010\u0006H\u0002J$\u0010J\u001a\u00020K2\u0006\u0010.\u001a\u00020\f2\b\u0010/\u001a\u0004\u0018\u00010\u00062\b\u0010>\u001a\u0004\u0018\u00010\rH\u0002J\u000e\u0010L\u001a\u00020*2\u0006\u0010M\u001a\u00020\u000bJ$\u0010N\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\f2\b\u0010/\u001a\u0004\u0018\u00010\u00062\b\u0010>\u001a\u0004\u0018\u00010\rH\u0002J\"\u0010O\u001a\u00020*2\u0006\u00104\u001a\u00020\r2\u0006\u0010.\u001a\u00020\f2\b\u0010/\u001a\u0004\u0018\u00010\u0006H\u0002J,\u0010P\u001a\u00020Q2\u0006\u00104\u001a\u00020\r2\u0006\u0010.\u001a\u00020\f2\b\u0010/\u001a\u0004\u0018\u00010\u00062\b\u0010>\u001a\u0004\u0018\u00010\rH\u0002J,\u0010R\u001a\u00020S2\u0006\u0010.\u001a\u00020\f2\b\u0010/\u001a\u0004\u0018\u00010\u00062\u0006\u0010<\u001a\u00020T2\b\u0010>\u001a\u0004\u0018\u00010\rH\u0002J$\u0010U\u001a\u00020V2\u0006\u0010.\u001a\u00020\f2\b\u0010/\u001a\u0004\u0018\u00010\u00062\b\u0010>\u001a\u0004\u0018\u00010\rH\u0002J,\u0010W\u001a\u00020X2\u0006\u00104\u001a\u00020\r2\u0006\u0010.\u001a\u00020\f2\b\u0010/\u001a\u0004\u0018\u00010\u00062\b\u0010>\u001a\u0004\u0018\u00010\rH\u0002J,\u0010Y\u001a\u00020Z2\u0006\u00104\u001a\u00020\r2\u0006\u0010.\u001a\u00020\f2\b\u0010/\u001a\u0004\u0018\u00010\u00062\b\u0010>\u001a\u0004\u0018\u00010\rH\u0002J,\u0010[\u001a\u00020\\2\u0006\u0010.\u001a\u00020\f2\b\u0010/\u001a\u0004\u0018\u00010\u00062\u0006\u0010<\u001a\u00020]2\b\u0010>\u001a\u0004\u0018\u00010\rH\u0002J\"\u0010^\u001a\u00020_2\u0006\u00104\u001a\u00020\r2\u0006\u0010.\u001a\u00020\f2\b\u0010/\u001a\u0004\u0018\u00010\u0006H\u0002J,\u0010`\u001a\u00020a2\u0006\u00104\u001a\u00020\r2\u0006\u0010.\u001a\u00020\f2\b\u0010/\u001a\u0004\u0018\u00010\u00062\b\u0010>\u001a\u0004\u0018\u00010\rH\u0002J$\u0010b\u001a\u00020c2\u0006\u0010.\u001a\u00020\f2\b\u0010/\u001a\u0004\u0018\u00010\u00062\b\u0010>\u001a\u0004\u0018\u00010\rH\u0002J \u0010d\u001a\u00020*2\u0006\u00104\u001a\u00020\r2\u0006\u0010.\u001a\u00020\f2\b\u0010I\u001a\u0004\u0018\u00010\u0006J,\u0010e\u001a\u00020f2\u0006\u0010.\u001a\u00020\f2\b\u0010/\u001a\u0004\u0018\u00010\u00062\u0006\u0010<\u001a\u00020g2\b\u0010>\u001a\u0004\u0018\u00010\rH\u0002J$\u0010h\u001a\u00020i2\u0006\u0010.\u001a\u00020\f2\b\u0010/\u001a\u0004\u0018\u00010\u00062\b\u0010>\u001a\u0004\u0018\u00010\rH\u0002J\u000e\u0010j\u001a\u00020*2\u0006\u0010k\u001a\u00020\u000bJ\u000e\u0010l\u001a\u00020m2\u0006\u00105\u001a\u000206J\u000e\u0010l\u001a\u00020m2\u0006\u00107\u001a\u000208J\u000e\u0010l\u001a\u00020m2\u0006\u0010M\u001a\u00020\u000bJ\u001c\u0010n\u001a\u00020m2\u0014\u0010o\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010p0\u0005J8\u0010q\u001a\u00020m2\u0006\u0010r\u001a\u00020*2\u0006\u0010s\u001a\u00020\f2\b\u0010t\u001a\u0004\u0018\u00010\r2\u0006\u0010u\u001a\u00020\f2\f\u0010v\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002R>\u0010\t\u001a&\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR(\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020*0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006y"}, d2={"Lnet/pwall/json/schema/parser/Parser;", "", "options", "Lnet/pwall/json/schema/parser/Parser$Options;", "uriResolver", "Lkotlin/Function1;", "Ljava/net/URI;", "Ljava/io/InputStream;", "(Lnet/pwall/json/schema/parser/Parser$Options;Lkotlin/jvm/functions/Function1;)V", "customValidationHandler", "Lkotlin/Function4;", "", "Lio/kjson/pointer/JSONPointer;", "Lio/kjson/JSONValue;", "Lnet/pwall/json/schema/JSONSchema$Validator;", "getCustomValidationHandler", "()Lkotlin/jvm/functions/Function4;", "setCustomValidationHandler", "(Lkotlin/jvm/functions/Function4;)V", "defaultValidationErrors", "", "Lnet/pwall/json/schema/output/BasicOutput;", "getDefaultValidationErrors", "()Ljava/util/List;", "examplesValidationErrors", "getExamplesValidationErrors", "jsonReader", "Lnet/pwall/json/schema/parser/JSONReader;", "getJsonReader", "()Lnet/pwall/json/schema/parser/JSONReader;", "nonstandardFormatHandler", "Lnet/pwall/json/schema/validation/FormatValidator$FormatChecker;", "getNonstandardFormatHandler", "()Lkotlin/jvm/functions/Function1;", "setNonstandardFormatHandler", "(Lkotlin/jvm/functions/Function1;)V", "getOptions", "()Lnet/pwall/json/schema/parser/Parser$Options;", "setOptions", "(Lnet/pwall/json/schema/parser/Parser$Options;)V", "schemaCache", "", "Lnet/pwall/json/schema/JSONSchema;", "checkType", "Lnet/pwall/json/schema/JSONSchema$Type;", "item", "pointer", "uri", "getDescription", "schemaJSON", "Lio/kjson/JSONObject;", "parse", "json", "file", "Ljava/io/File;", "path", "Ljava/nio/file/Path;", "string", "parseArrayNumberOfItems", "Lnet/pwall/json/schema/validation/ArrayValidator;", "condition", "Lnet/pwall/json/schema/validation/ArrayValidator$ValidationType;", "value", "parseArrayUniqueItems", "Lnet/pwall/json/schema/validation/UniqueItemsValidator;", "parseCombinationSchema", "array", "creator", "Lkotlin/Function3;", "", "parseContains", "Lnet/pwall/json/schema/validation/ContainsValidator;", "parseDraft07", "parentUri", "parseEnum", "Lnet/pwall/json/schema/validation/EnumValidator;", "parseFile", "filename", "parseFormat", "parseIf", "parseItems", "Lnet/pwall/json/schema/JSONSchema$SubSchema;", "parseNumberLimit", "Lnet/pwall/json/schema/validation/NumberValidator;", "Lnet/pwall/json/schema/validation/NumberValidator$ValidationType;", "parsePattern", "Lnet/pwall/json/schema/validation/PatternValidator;", "parsePatternProperties", "Lnet/pwall/json/schema/subschema/PatternPropertiesSchema;", "parseProperties", "Lnet/pwall/json/schema/subschema/PropertiesSchema;", "parsePropertiesSize", "Lnet/pwall/json/schema/validation/PropertiesValidator;", "Lnet/pwall/json/schema/validation/PropertiesValidator$ValidationType;", "parsePropertyNames", "Lnet/pwall/json/schema/subschema/PropertyNamesSchema;", "parseRef", "Lnet/pwall/json/schema/subschema/RefSchema;", "parseRequired", "Lnet/pwall/json/schema/subschema/RequiredSchema;", "parseSchema", "parseStringLength", "Lnet/pwall/json/schema/validation/StringValidator;", "Lnet/pwall/json/schema/validation/StringValidator$ValidationType;", "parseType", "Lnet/pwall/json/schema/validation/TypeValidator;", "parseURI", "uriString", "preLoad", "", "setExtendedResolver", "extendedResolver", "Lnet/pwall/json/schema/parser/InputDetails;", "validateExample", "schema", "relativeLocation", "root", "location", "errorList", "Companion", "Options", "json-kotlin-schema"})
@SourceDebugExtension(value={"SMAP\nParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Parser.kt\nnet/pwall/json/schema/parser/Parser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,663:1\n1#2:664\n1549#3:665\n1620#3,3:666\n1549#3:669\n1620#3,3:670\n1549#3:673\n1620#3,3:674\n1549#3:677\n1620#3,3:678\n1559#3:681\n1590#3,4:682\n1559#3:686\n1590#3,4:687\n*S KotlinDebug\n*F\n+ 1 Parser.kt\nnet/pwall/json/schema/parser/Parser\n*L\n333#1:665\n333#1:666,3\n387#1:669\n387#1:670,3\n395#1:673\n395#1:674,3\n402#1:677\n402#1:678,3\n422#1:681\n422#1:682,4\n432#1:686\n432#1:687,4\n*E\n"})
public final class Parser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Options options;
    @NotNull
    private final List<BasicOutput> examplesValidationErrors;
    @NotNull
    private final List<BasicOutput> defaultValidationErrors;
    @NotNull
    private Function4<? super String, ? super URI, ? super JSONPointer, ? super JSONValue, ? extends JSONSchema.Validator> customValidationHandler;
    @NotNull
    private Function1<? super String, ? extends FormatValidator.FormatChecker> nonstandardFormatHandler;
    @NotNull
    private final JSONReader jsonReader;
    @NotNull
    private final Map<URI, JSONSchema> schemaCache;
    @NotNull
    private static final List<String> schemaVersion202012;
    @NotNull
    private static final List<String> schemaVersion201909;
    @NotNull
    private static final List<String> schemaVersionDraft07;
    @NotNull
    private static final List<Function1<HttpURLConnection, HttpURLConnection>> connectionFilters;
    @NotNull
    private static final Function1<URI, InputStream> defaultURIResolver;
    @NotNull
    private static final Function1<URI, InputDetails> defaultExtendedResolver;

    public Parser(@NotNull Options options, @NotNull Function1<? super URI, ? extends InputStream> uriResolver) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter(uriResolver, (String)"uriResolver");
        this.options = options;
        this.examplesValidationErrors = new ArrayList();
        this.defaultValidationErrors = new ArrayList();
        this.customValidationHandler = customValidationHandler.1.INSTANCE;
        this.nonstandardFormatHandler = nonstandardFormatHandler.1.INSTANCE;
        this.jsonReader = new JSONReader(uriResolver);
        this.schemaCache = new LinkedHashMap();
    }

    public /* synthetic */ Parser(Options options, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            options = new Options(false, false, false, 7, null);
        }
        if ((n & 2) != 0) {
            function1 = defaultURIResolver;
        }
        this(options, function1);
    }

    @NotNull
    public final Options getOptions() {
        return this.options;
    }

    public final void setOptions(@NotNull Options options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"<set-?>");
        this.options = options;
    }

    @NotNull
    public final List<BasicOutput> getExamplesValidationErrors() {
        return this.examplesValidationErrors;
    }

    @NotNull
    public final List<BasicOutput> getDefaultValidationErrors() {
        return this.defaultValidationErrors;
    }

    @NotNull
    public final Function4<String, URI, JSONPointer, JSONValue, JSONSchema.Validator> getCustomValidationHandler() {
        return this.customValidationHandler;
    }

    public final void setCustomValidationHandler(@NotNull Function4<? super String, ? super URI, ? super JSONPointer, ? super JSONValue, ? extends JSONSchema.Validator> function4) {
        Intrinsics.checkNotNullParameter(function4, (String)"<set-?>");
        this.customValidationHandler = function4;
    }

    @NotNull
    public final Function1<String, FormatValidator.FormatChecker> getNonstandardFormatHandler() {
        return this.nonstandardFormatHandler;
    }

    public final void setNonstandardFormatHandler(@NotNull Function1<? super String, ? extends FormatValidator.FormatChecker> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.nonstandardFormatHandler = function1;
    }

    @NotNull
    public final JSONReader getJsonReader() {
        return this.jsonReader;
    }

    public final void setExtendedResolver(@NotNull Function1<? super URI, InputDetails> extendedResolver) {
        Intrinsics.checkNotNullParameter(extendedResolver, (String)"extendedResolver");
        this.jsonReader.setExtendedResolver(extendedResolver);
    }

    public final void preLoad(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        this.jsonReader.preLoad(filename);
    }

    public final void preLoad(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.jsonReader.preLoad(file);
    }

    public final void preLoad(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.jsonReader.preLoad(path);
    }

    @NotNull
    public final JSONSchema parseFile(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return this.parse(new File(filename));
    }

    @NotNull
    public final JSONSchema parseURI(@NotNull String uriString) {
        Intrinsics.checkNotNullParameter((Object)uriString, (String)"uriString");
        return this.parse(new URI(uriString));
    }

    @NotNull
    public final JSONSchema parse(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.isFile()) {
            throw new JSONSchemaException("Invalid file - " + file);
        }
        URI uri = file.toURI();
        JSONSchema jSONSchema = this.schemaCache.get(uri);
        if (jSONSchema != null) {
            JSONSchema it = jSONSchema;
            boolean bl = false;
            return it;
        }
        JSONValue json = this.jsonReader.readJSON(file);
        return this.parse(json, uri);
    }

    @NotNull
    public final JSONSchema parse(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        JSONSchema jSONSchema = this.schemaCache.get(uri);
        if (jSONSchema != null) {
            JSONSchema it = jSONSchema;
            boolean bl = false;
            return it;
        }
        JSONValue json = this.jsonReader.readJSON(uri);
        return this.parse(json, uri);
    }

    @NotNull
    public final JSONSchema parse(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new JSONSchemaException("Invalid file - " + path);
        }
        URI uri = path.toUri();
        JSONSchema jSONSchema = this.schemaCache.get(uri);
        if (jSONSchema != null) {
            JSONSchema it = jSONSchema;
            boolean bl = false;
            return it;
        }
        JSONValue json = this.jsonReader.readJSON(path);
        return this.parse(json, uri);
    }

    @NotNull
    public final JSONSchema parse(@NotNull String string, @Nullable URI uri) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        JSONValue json = this.jsonReader.readJSON(string, uri);
        return this.parse(json, uri);
    }

    public static /* synthetic */ JSONSchema parse$default(Parser parser2, String string, URI uRI, int n, Object object) {
        if ((n & 2) != 0) {
            uRI = null;
        }
        return parser2.parse(string, uRI);
    }

    private final JSONSchema parse(JSONValue json, URI uri) {
        JSONObject jSONObject = json instanceof JSONObject ? (JSONObject)json : null;
        String schemaVersion = jSONObject != null ? Companion.getStringOrNull(jSONObject, uri, JSONPointer.Companion.getRoot().child("$schema")) : null;
        JSONPointer pointer = JSONPointer.Companion.getRoot();
        String string = schemaVersion;
        return CollectionsKt.contains((Iterable)schemaVersion201909, (Object)string) ? this.parseSchema(json, pointer, uri) : (CollectionsKt.contains((Iterable)schemaVersionDraft07, (Object)string) ? this.parseDraft07(json, pointer, uri) : this.parseSchema(json, pointer, uri));
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final JSONSchema parseSchema(@NotNull JSONValue json, @NotNull JSONPointer pointer, @Nullable URI parentUri) {
        block102: {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
            schemaJSON = IndexOpKt.get((JSONValue)json, (JSONPointer)pointer);
            if (schemaJSON instanceof JSONBoolean) {
                return JSONSchema.Companion.booleanSchema(((JSONBoolean)schemaJSON).getValue(), parentUri, pointer);
            }
            if (!(schemaJSON instanceof JSONObject)) {
                throw new JSONSchemaException("Schema is not boolean or object - " + net.pwall.json.schema.parser.Parser$Companion.access$errorPointer(Parser.Companion, parentUri, pointer));
            }
            id = Parser.Companion.getIdOrNull(schemaJSON);
            if (id == null) {
                v0 = parentUri;
            } else if (parentUri == null) {
                v0 = Parser.Companion.dropFragment(new URI(id));
            } else {
                v1 = parentUri.resolve(id);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"resolve(...)");
                v0 = Parser.Companion.dropFragment(v1);
            }
            v2 = uri = v0;
            if (v2 != null) {
                it = v2;
                $i$a$-let-Parser$parseSchema$1 = false;
                fragmentURI = Parser.Companion.withFragment(uri, pointer);
                v3 = this.schemaCache.get(fragmentURI);
                if (v3 != null) {
                    it = v3;
                    $i$a$-let-Parser$parseSchema$1$1 = false;
                    if (it instanceof JSONSchema.False) {
                        net.pwall.json.schema.parser.Parser$Companion.access$fatal(Parser.Companion, "Recursive $ref", uri, pointer);
                        throw new KotlinNothingValueException();
                    }
                    return it;
                }
                this.schemaCache.put(fragmentURI, new JSONSchema.False(uri, pointer));
            }
            title = Parser.Companion.getStringOrNull((JSONObject)schemaJSON, uri, "title");
            description = this.getDescription((JSONObject)schemaJSON, uri, pointer);
            children = new ArrayList<E>();
            result = new JSONSchema.General(Parser.schemaVersion201909.get(0), title, description, uri, pointer, children);
            for (Map.Entry $i$a$-let-Parser$parseSchema$1$1 : ((JSONObject)schemaJSON).entrySet()) {
                block100: {
                    block101: {
                        block99: {
                            key = (String)$i$a$-let-Parser$parseSchema$1$1.getKey();
                            value = (JSONValue)$i$a$-let-Parser$parseSchema$1$1.getValue();
                            childPointer = pointer.child(key);
                            var16_22 = key;
                            if (!Intrinsics.areEqual((Object)var16_22, (Object)"$schema")) break block99;
                            if (!Intrinsics.areEqual((Object)pointer, (Object)JSONPointer.Companion.getRoot())) {
                                net.pwall.json.schema.parser.Parser$Companion.access$fatal(Parser.Companion, "May only appear in the root of the document", uri, childPointer);
                                throw new KotlinNothingValueException();
                            }
                            if (!(value instanceof JSONString)) {
                                net.pwall.json.schema.parser.Parser$Companion.access$fatal(Parser.Companion, "String expected", uri, childPointer);
                                throw new KotlinNothingValueException();
                            }
                            break block100;
                        }
                        switch (var16_22.hashCode()) {
                            case 3116345: {
                                if (!var16_22.equals("else")) {
                                    break;
                                }
                                ** GOTO lbl87
                            }
                            case 36326194: {
                                if (!var16_22.equals("$defs")) {
                                    break;
                                }
                                ** GOTO lbl87
                            }
                            case -1724546052: {
                                if (!var16_22.equals("description")) {
                                    break;
                                }
                                ** GOTO lbl87
                            }
                            case 3558941: {
                                if (!var16_22.equals("then")) {
                                    break;
                                }
                                ** GOTO lbl87
                            }
                            case 110371416: {
                                if (!var16_22.equals("title")) {
                                    break;
                                }
                                ** GOTO lbl87
                            }
                            case 1464851363: {
                                if (!var16_22.equals("maxContains")) {
                                    break;
                                }
                                ** GOTO lbl87
                            }
                            case 787418769: {
                                if (!var16_22.equals("minContains")) {
                                    break;
                                }
                                ** GOTO lbl87
                            }
                            case 37951: {
                                if (!var16_22.equals("$id")) break;
lbl87:
                                // 8 sources

                                v4 = true;
                                break block101;
                            }
                        }
                        v4 = Intrinsics.areEqual((Object)var16_22, (Object)"example");
                    }
                    if (!v4) {
                        if (Intrinsics.areEqual((Object)var16_22, (Object)"$comment")) {
                            if (!(value instanceof JSONString)) {
                                net.pwall.json.schema.parser.Parser$Companion.access$fatal(Parser.Companion, "String expected", uri, childPointer);
                                throw new KotlinNothingValueException();
                            }
                        } else if (Intrinsics.areEqual((Object)var16_22, (Object)"examples")) {
                            if (!(value instanceof JSONArray)) {
                                net.pwall.json.schema.parser.Parser$Companion.access$fatal(Parser.Companion, "Must be array", uri, childPointer);
                                throw new KotlinNothingValueException();
                            }
                        } else if (Intrinsics.areEqual((Object)var16_22, (Object)"$ref")) {
                            children.add(this.parseRef(json, childPointer, uri, value));
                        } else if (Intrinsics.areEqual((Object)var16_22, (Object)"default")) {
                            children.add(new DefaultValidator(uri, childPointer, value));
                        } else if (Intrinsics.areEqual((Object)var16_22, (Object)"allOf")) {
                            children.add(this.parseCombinationSchema(json, childPointer, uri, value, (Function3<? super URI, ? super JSONPointer, ? super List<? extends JSONSchema>, ? extends JSONSchema>)((Function3)new Function3<URI, JSONPointer, List<? extends JSONSchema>, AllOfSchema>((Object)JSONSchema.Companion){

                                @NotNull
                                public final AllOfSchema invoke(@Nullable URI p0, @NotNull JSONPointer p1, @NotNull List<? extends JSONSchema> p2) {
                                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                    Intrinsics.checkNotNullParameter(p2, (String)"p2");
                                    return ((JSONSchema.Companion)this.receiver).allOf(p0, p1, p2);
                                }
                            })));
                        } else if (Intrinsics.areEqual((Object)var16_22, (Object)"anyOf")) {
                            children.add(this.parseCombinationSchema(json, childPointer, uri, value, (Function3<? super URI, ? super JSONPointer, ? super List<? extends JSONSchema>, ? extends JSONSchema>)((Function3)new Function3<URI, JSONPointer, List<? extends JSONSchema>, AnyOfSchema>((Object)JSONSchema.Companion){

                                @NotNull
                                public final AnyOfSchema invoke(@Nullable URI p0, @NotNull JSONPointer p1, @NotNull List<? extends JSONSchema> p2) {
                                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                    Intrinsics.checkNotNullParameter(p2, (String)"p2");
                                    return ((JSONSchema.Companion)this.receiver).anyOf(p0, p1, p2);
                                }
                            })));
                        } else if (Intrinsics.areEqual((Object)var16_22, (Object)"oneOf")) {
                            children.add(this.parseCombinationSchema(json, childPointer, uri, value, (Function3<? super URI, ? super JSONPointer, ? super List<? extends JSONSchema>, ? extends JSONSchema>)((Function3)new Function3<URI, JSONPointer, List<? extends JSONSchema>, OneOfSchema>((Object)JSONSchema.Companion){

                                @NotNull
                                public final OneOfSchema invoke(@Nullable URI p0, @NotNull JSONPointer p1, @NotNull List<? extends JSONSchema> p2) {
                                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                    Intrinsics.checkNotNullParameter(p2, (String)"p2");
                                    return ((JSONSchema.Companion)this.receiver).oneOf(p0, p1, p2);
                                }
                            })));
                        } else if (Intrinsics.areEqual((Object)var16_22, (Object)"not")) {
                            children.add(new JSONSchema.Not(uri, childPointer, this.parseSchema(json, pointer.child("not"), uri)));
                        } else if (Intrinsics.areEqual((Object)var16_22, (Object)"if")) {
                            children.add(this.parseIf(json, pointer, uri));
                        } else if (Intrinsics.areEqual((Object)var16_22, (Object)"type")) {
                            children.add(this.parseType(childPointer, uri, value));
                        } else if (Intrinsics.areEqual((Object)var16_22, (Object)"enum")) {
                            children.add(this.parseEnum(childPointer, uri, value));
                        } else if (Intrinsics.areEqual((Object)var16_22, (Object)"const")) {
                            children.add(new ConstValidator(uri, childPointer, value));
                        } else if (Intrinsics.areEqual((Object)var16_22, (Object)"properties")) {
                            children.add(this.parseProperties(json, childPointer, uri, value));
                        } else if (Intrinsics.areEqual((Object)var16_22, (Object)"patternProperties")) {
                            children.add(this.parsePatternProperties(json, childPointer, uri, value));
                        } else if (Intrinsics.areEqual((Object)var16_22, (Object)"propertyNames")) {
                            children.add(this.parsePropertyNames(json, childPointer, uri));
                        } else if (Intrinsics.areEqual((Object)var16_22, (Object)"minProperties")) {
                            children.add(this.parsePropertiesSize(childPointer, uri, PropertiesValidator.ValidationType.MIN_PROPERTIES, value));
                        } else if (Intrinsics.areEqual((Object)var16_22, (Object)"maxProperties")) {
                            children.add(this.parsePropertiesSize(childPointer, uri, PropertiesValidator.ValidationType.MAX_PROPERTIES, value));
                        } else if (Intrinsics.areEqual((Object)var16_22, (Object)"required")) {
                            children.add(this.parseRequired(childPointer, uri, value));
                        } else if (Intrinsics.areEqual((Object)var16_22, (Object)"items")) {
                            children.add(this.parseItems(json, childPointer, uri, value));
                        } else if (NumberValidator.Companion.getTypeKeywords().contains(var16_22)) {
                            children.add(this.parseNumberLimit(childPointer, uri, NumberValidator.Companion.findType(key), value));
                        } else if (Intrinsics.areEqual((Object)var16_22, (Object)"maxItems")) {
                            children.add(this.parseArrayNumberOfItems(childPointer, uri, ArrayValidator.ValidationType.MAX_ITEMS, value));
                        } else if (Intrinsics.areEqual((Object)var16_22, (Object)"minItems")) {
                            children.add(this.parseArrayNumberOfItems(childPointer, uri, ArrayValidator.ValidationType.MIN_ITEMS, value));
                        } else if (Intrinsics.areEqual((Object)var16_22, (Object)"uniqueItems")) {
                            if (this.parseArrayUniqueItems(childPointer, uri, value) != null) {
                                $i$a$-let-Parser$parseSchema$5 = false;
                                children.add(it);
                            }
                        } else if (Intrinsics.areEqual((Object)var16_22, (Object)"maxLength")) {
                            children.add(this.parseStringLength(childPointer, uri, StringValidator.ValidationType.MAX_LENGTH, value));
                        } else if (Intrinsics.areEqual((Object)var16_22, (Object)"minLength")) {
                            children.add(this.parseStringLength(childPointer, uri, StringValidator.ValidationType.MIN_LENGTH, value));
                        } else if (Intrinsics.areEqual((Object)var16_22, (Object)"pattern")) {
                            children.add(this.parsePattern(childPointer, uri, value));
                        } else if (Intrinsics.areEqual((Object)var16_22, (Object)"format")) {
                            children.add(this.parseFormat(childPointer, uri, value));
                        } else if (Intrinsics.areEqual((Object)var16_22, (Object)"additionalProperties")) {
                            children.add(new AdditionalPropertiesSchema(result, uri, childPointer, this.parseSchema(json, childPointer, uri)));
                        } else if (Intrinsics.areEqual((Object)var16_22, (Object)"additionalItems")) {
                            children.add(new AdditionalItemsSchema(result, uri, childPointer, this.parseSchema(json, childPointer, uri)));
                        } else if (Intrinsics.areEqual((Object)var16_22, (Object)"contains")) {
                            children.add(this.parseContains(json, pointer, uri));
                        } else if ((JSONSchema.Validator)this.customValidationHandler.invoke((Object)key, (Object)uri, (Object)childPointer, (Object)value) != null) {
                            $i$a$-let-Parser$parseSchema$6 = false;
                            children.add(new DelegatingValidator(it.getUri(), it.getLocation(), key, it));
                        }
                    }
                }
                if (!StringsKt.startsWith$default((String)key, (String)"x-", (boolean)false, (int)2, null)) continue;
                v5 = value;
                children.add(new ExtensionSchema(uri, childPointer, key, v5 != null ? Parser.Companion.toSimpleValue(v5) : null));
            }
            if (this.options.getValidateExamples()) {
                if (((JSONObject)schemaJSON).containsKey((Object)"example")) {
                    this.validateExample(result, pointer, json, pointer.child("example"), this.examplesValidationErrors);
                }
                if (((JSONObject)schemaJSON).containsKey((Object)"examples")) {
                    v6 = ((JSONObject)schemaJSON).get((Object)"examples");
                    Intrinsics.checkNotNull((Object)v6, (String)"null cannot be cast to non-null type io.kjson.JSONArray");
                    examplesArray = (JSONArray)v6;
                    examplesPointer = pointer.child("examples");
                    var14_20 = examplesArray.size();
                    for (i = 0; i < var14_20; ++i) {
                        this.validateExample(result, pointer, json, examplesPointer.child(i), this.examplesValidationErrors);
                    }
                }
            }
            if (this.options.getValidateDefault() && ((JSONObject)schemaJSON).containsKey((Object)"default")) {
                this.validateExample(result, pointer, json, pointer.child("default"), this.defaultValidationErrors);
            }
            v7 = uri;
            if (v7 == null) break block102;
            it = v7;
            $i$a$-let-Parser$parseSchema$7 = false;
            this.schemaCache.put(Parser.Companion.withFragment(uri, pointer), result);
        }
        return result;
    }

    private final void validateExample(JSONSchema schema, JSONPointer relativeLocation, JSONValue root, JSONPointer location, List<BasicOutput> errorList) {
        BasicOutput result = schema.validateBasic(relativeLocation, root, location);
        if (!result.getValid()) {
            errorList.add(result);
        }
    }

    private final String getDescription(JSONObject schemaJSON, URI uri, JSONPointer pointer) {
        JSONValue ref;
        JSONValue jSONValue = (JSONValue)schemaJSON.get((Object)"description");
        if (jSONValue == null) {
            return null;
        }
        JSONValue value = jSONValue;
        if (value instanceof JSONString) {
            return ((JSONString)value).getValue();
        }
        if (this.options.getAllowDescriptionRef() && value instanceof JSONObject && ((JSONObject)value).size() == 1 && (ref = (JSONValue)((JSONObject)value).get((Object)"$ref")) instanceof JSONString) {
            try {
                URI uRI = uri;
                URL uRL = (uRI == null ? new URI(((JSONString)ref).getValue()) : uRI.resolve(((JSONString)ref).getValue())).toURL();
                Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
                URL uRL2 = uRL;
                Charset charset = Charsets.UTF_8;
                byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
                return new String(byArray, charset);
            }
            catch (Exception e) {
                Parser.Companion.fatal("Error reading external description " + ref, uri, pointer);
                throw new KotlinNothingValueException();
            }
        }
        Parser.Companion.fatal("Invalid description", uri, pointer);
        throw new KotlinNothingValueException();
    }

    private final JSONSchema parseIf(JSONValue json, JSONPointer pointer, URI uri) {
        JSONSchema ifSchema = this.parseSchema(json, pointer.child("if"), uri);
        JSONPointer it = pointer.child("then");
        boolean bl = false;
        JSONSchema thenSchema = FindKt.existsIn((JSONPointer)it, (JSONValue)json) ? this.parseSchema(json, it, uri) : null;
        JSONPointer it2 = pointer.child("else");
        boolean bl2 = false;
        JSONSchema elseSchema = FindKt.existsIn((JSONPointer)it2, (JSONValue)json) ? this.parseSchema(json, it2, uri) : null;
        return new IfThenElseSchema(uri, pointer, ifSchema, thenSchema, elseSchema);
    }

    private final ContainsValidator parseContains(JSONValue json, JSONPointer pointer, URI uri) {
        JSONSchema containsSchema = this.parseSchema(json, pointer.child("contains"), uri);
        JSONPointer it = pointer.child("minContains");
        boolean bl = false;
        Integer minContains = FindKt.existsIn((JSONPointer)it, (JSONValue)json) ? Integer.valueOf(Companion.getNonNegativeInteger(json, uri, it)) : null;
        JSONPointer it2 = pointer.child("maxContains");
        boolean bl2 = false;
        Integer maxContains = FindKt.existsIn((JSONPointer)it2, (JSONValue)json) ? Integer.valueOf(Companion.getNonNegativeInteger(json, uri, it2)) : null;
        return new ContainsValidator(uri, pointer.child("contains"), containsSchema, minContains, maxContains);
    }

    private final JSONSchema.Validator parseFormat(JSONPointer pointer, URI uri, JSONValue value) {
        if (!(value instanceof JSONString)) {
            Parser.Companion.fatal("String expected", uri, pointer);
            throw new KotlinNothingValueException();
        }
        String keyword = ((JSONString)value).getValue();
        boolean bl = false;
        FormatValidator.FormatChecker formatChecker = (FormatValidator.FormatChecker)this.nonstandardFormatHandler.invoke((Object)keyword);
        if (formatChecker == null && (formatChecker = FormatValidator.Companion.findChecker(keyword)) == null) {
            formatChecker = new FormatValidator.NullFormatChecker(keyword);
        }
        FormatValidator.FormatChecker checker = formatChecker;
        return new FormatValidator(uri, pointer, checker);
    }

    /*
     * WARNING - void declaration
     */
    private final JSONSchema parseCombinationSchema(JSONValue json, JSONPointer pointer, URI uri, JSONValue array, Function3<? super URI, ? super JSONPointer, ? super List<? extends JSONSchema>, ? extends JSONSchema> creator) {
        Collection<JSONSchema> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (!(array instanceof JSONArray)) {
            Parser.Companion.fatal("Compound must take array", uri, pointer);
            throw new KotlinNothingValueException();
        }
        Iterable iterable = (Iterable)CollectionsKt.getIndices((Collection)((Collection)array));
        JSONPointer jSONPointer = pointer;
        URI uRI = uri;
        Function3<? super URI, ? super JSONPointer, ? super List<? extends JSONSchema>, ? extends JSONSchema> function3 = creator;
        boolean $i$f$map = false;
        void var8_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void i;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.parseSchema(json, pointer.child((int)i), uri));
        }
        collection = (List)destination$iv$iv;
        return (JSONSchema)function3.invoke((Object)uRI, (Object)jSONPointer, (Object)collection);
    }

    private final RefSchema parseRef(JSONValue json, JSONPointer pointer, URI uri, JSONValue value) {
        if (!(value instanceof JSONString)) {
            Parser.Companion.fatal("$ref must be string", uri, pointer);
            throw new KotlinNothingValueException();
        }
        String refString = ((JSONString)value).getValue();
        URI refURI = null;
        JSONValue refJSON = null;
        String refURIFragment = null;
        JSONPointer refPointer = null;
        int hashIndex = StringsKt.indexOf$default((CharSequence)refString, (char)'#', (int)0, (boolean)false, (int)6, null);
        if (hashIndex < 0) {
            URI uRI = uri;
            if (uRI == null || (uRI = uRI.resolve(refString)) == null) {
                uRI = new URI(refString);
            }
            refURI = uRI;
            refJSON = this.jsonReader.readJSON(refURI);
            refURIFragment = null;
            refPointer = JSONPointer.Companion.getRoot();
        } else if (hashIndex == 0) {
            refURI = uri;
            refJSON = json;
            String string = refString.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            refURIFragment = string;
            String string2 = refString.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            refPointer = JSONPointer.Companion.fromURIFragment(string2);
        } else {
            String string = refString.substring(0, hashIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String refStringWithoutFragment = string;
            if (uri != null && Intrinsics.areEqual((Object)uri.toString(), (Object)refStringWithoutFragment)) {
                refURI = uri;
                refJSON = json;
            } else {
                URI uRI = uri;
                if (uRI == null || (uRI = uRI.resolve(refStringWithoutFragment)) == null) {
                    uRI = new URI(refStringWithoutFragment);
                }
                refURI = uRI;
                refJSON = this.jsonReader.readJSON(refURI);
            }
            String string3 = refString.substring(hashIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            refURIFragment = string3;
            String string4 = refString.substring(hashIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            refPointer = JSONPointer.Companion.fromURIFragment(string4);
        }
        if (!FindKt.existsIn((JSONPointer)refPointer, (JSONValue)refJSON)) {
            Parser.Companion.fatal("$ref not found " + refString, uri, pointer);
            throw new KotlinNothingValueException();
        }
        return new RefSchema(uri, pointer, this.parseSchema(refJSON, refPointer, refURI), refURIFragment);
    }

    /*
     * WARNING - void declaration
     */
    private final JSONSchema.SubSchema parseItems(JSONValue json, JSONPointer pointer, URI uri, JSONValue value) {
        JSONSchema.SubSchema subSchema;
        if (value instanceof JSONArray) {
            Collection<JSONSchema> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = (Iterable)CollectionsKt.getIndices((Collection)((Collection)value));
            JSONPointer jSONPointer = pointer;
            URI uRI = uri;
            boolean $i$f$map = false;
            void var7_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void i;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.parseSchema(json, pointer.child((int)i), uri));
            }
            collection = (List)destination$iv$iv;
            List list = collection;
            JSONPointer jSONPointer2 = jSONPointer;
            URI uRI2 = uRI;
            subSchema = new ItemsArraySchema(uRI2, jSONPointer2, list);
        } else {
            subSchema = new ItemsSchema(uri, pointer, this.parseSchema(json, pointer, uri));
        }
        return subSchema;
    }

    /*
     * WARNING - void declaration
     */
    private final PropertiesSchema parseProperties(JSONValue json, JSONPointer pointer, URI uri, JSONValue value) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (!(value instanceof JSONObject)) {
            Parser.Companion.fatal("properties must be object", uri, pointer);
            throw new KotlinNothingValueException();
        }
        Iterable iterable = ((JSONObject)value).keySet();
        JSONPointer jSONPointer = pointer;
        URI uRI = uri;
        boolean $i$f$map = false;
        void var7_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it, (Object)this.parseSchema(json, pointer.child((String)it), uri)));
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        JSONPointer jSONPointer2 = jSONPointer;
        URI uRI2 = uRI;
        return new PropertiesSchema(uRI2, jSONPointer2, list);
    }

    /*
     * WARNING - void declaration
     */
    private final PatternPropertiesSchema parsePatternProperties(JSONValue json, JSONPointer pointer, URI uri, JSONValue value) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (!(value instanceof JSONObject)) {
            Parser.Companion.fatal("patternProperties must be object", uri, pointer);
            throw new KotlinNothingValueException();
        }
        Iterable iterable = ((JSONObject)value).keySet();
        JSONPointer jSONPointer = pointer;
        URI uRI = uri;
        boolean $i$f$map = false;
        void var7_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Regex regex;
            void key;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            JSONPointer childPointer = pointer.child((String)key);
            try {
                regex = new Regex((String)key);
            }
            catch (Exception e) {
                Parser.Companion.fatal("Invalid regex in patternProperties", uri, childPointer);
                throw new KotlinNothingValueException();
            }
            Regex regex2 = regex;
            collection.add(TuplesKt.to((Object)regex2, (Object)this.parseSchema(json, childPointer, uri)));
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        JSONPointer jSONPointer2 = jSONPointer;
        URI uRI2 = uRI;
        return new PatternPropertiesSchema(uRI2, jSONPointer2, list);
    }

    private final PropertyNamesSchema parsePropertyNames(JSONValue json, JSONPointer pointer, URI uri) {
        return new PropertyNamesSchema(uri, pointer, this.parseSchema(json, pointer, uri));
    }

    private final PropertiesValidator parsePropertiesSize(JSONPointer pointer, URI uri, PropertiesValidator.ValidationType condition, JSONValue value) {
        return new PropertiesValidator(uri, pointer, condition, Companion.getInteger(value, uri, pointer));
    }

    /*
     * WARNING - void declaration
     */
    private final RequiredSchema parseRequired(JSONPointer pointer, URI uri, JSONValue value) {
        Collection<String> collection;
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        if (!(value instanceof JSONArray)) {
            Parser.Companion.fatal("required must be array", uri, pointer);
            throw new KotlinNothingValueException();
        }
        Iterable iterable = (Iterable)value;
        JSONPointer jSONPointer = pointer;
        URI uRI = uri;
        boolean $i$f$mapIndexed = false;
        void var6_8 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void entry;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            JSONValue jSONValue = (JSONValue)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl = false;
            if (!(entry instanceof JSONString)) {
                void i;
                Parser.Companion.fatal("required item must be string", uri, pointer.child((int)i));
                throw new KotlinNothingValueException();
            }
            collection.add(((JSONString)entry).getValue());
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        JSONPointer jSONPointer2 = jSONPointer;
        URI uRI2 = uRI;
        return new RequiredSchema(uRI2, jSONPointer2, list);
    }

    /*
     * WARNING - void declaration
     */
    private final TypeValidator parseType(JSONPointer pointer, URI uri, JSONValue value) {
        List list;
        JSONValue jSONValue = value;
        if (jSONValue instanceof JSONString) {
            list = CollectionsKt.listOf((Object)((Object)this.checkType(value, pointer, uri)));
        } else if (jSONValue instanceof JSONArray) {
            void $this$mapIndexedTo$iv$iv;
            Iterable $this$mapIndexed$iv = (Iterable)value;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index;
                void item;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                JSONValue jSONValue2 = (JSONValue)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.checkType((JSONValue)item, pointer.child((int)index), uri));
            }
            list = (List)destination$iv$iv;
        } else {
            Parser.Companion.fatal("Invalid type", uri, pointer);
            throw new KotlinNothingValueException();
        }
        List types = list;
        return new TypeValidator(uri, pointer, types);
    }

    private final JSONSchema.Type checkType(JSONValue item, JSONPointer pointer, URI uri) {
        if (item instanceof JSONString) {
            for (JSONSchema.Type type : JSONSchema.Type.getEntries()) {
                if (!Intrinsics.areEqual((Object)((JSONString)item).getValue(), (Object)type.getValue())) continue;
                return type;
            }
        }
        Parser.Companion.fatal("Invalid type", uri, pointer);
        throw new KotlinNothingValueException();
    }

    private final EnumValidator parseEnum(JSONPointer pointer, URI uri, JSONValue value) {
        if (!(value instanceof JSONArray)) {
            Parser.Companion.fatal("enum must be array", uri, pointer);
            throw new KotlinNothingValueException();
        }
        return new EnumValidator(uri, pointer, (JSONArray)value);
    }

    private final NumberValidator parseNumberLimit(JSONPointer pointer, URI uri, NumberValidator.ValidationType condition, JSONValue value) {
        Number number;
        if (!(value instanceof JSONNumber)) {
            Parser.Companion.fatal("Must be number (was " + JSONSchema.Companion.toErrorDisplay(value) + ')', uri, pointer);
            throw new KotlinNothingValueException();
        }
        JSONNumber jSONNumber = (JSONNumber)value;
        Number number2 = jSONNumber instanceof JSONDecimal ? (Number)((JSONDecimal)value).getValue() : (Number)(number = jSONNumber instanceof JSONLong ? (Number)((JSONNumber)value).longValue() : (Number)((JSONNumber)value).intValue());
        if (condition == NumberValidator.ValidationType.MULTIPLE_OF && !Companion.isPositive(number)) {
            Parser.Companion.fatal("multipleOf must be greater than 0", uri, pointer);
            throw new KotlinNothingValueException();
        }
        return new NumberValidator(uri, pointer, number, condition);
    }

    private final StringValidator parseStringLength(JSONPointer pointer, URI uri, StringValidator.ValidationType condition, JSONValue value) {
        return new StringValidator(uri, pointer, condition, Companion.getInteger(value, uri, pointer));
    }

    private final ArrayValidator parseArrayNumberOfItems(JSONPointer pointer, URI uri, ArrayValidator.ValidationType condition, JSONValue value) {
        return new ArrayValidator(uri, pointer, condition, Companion.getInteger(value, uri, pointer));
    }

    private final UniqueItemsValidator parseArrayUniqueItems(JSONPointer pointer, URI uri, JSONValue value) {
        if (!(value instanceof JSONBoolean)) {
            Parser.Companion.fatal("Must be boolean", uri, pointer);
            throw new KotlinNothingValueException();
        }
        return ((JSONBoolean)value).getValue() != false ? new UniqueItemsValidator(uri, pointer) : null;
    }

    private final PatternValidator parsePattern(JSONPointer pointer, URI uri, JSONValue value) {
        Regex regex;
        if (!(value instanceof JSONString)) {
            Parser.Companion.fatal("Must be string", uri, pointer);
            throw new KotlinNothingValueException();
        }
        try {
            regex = new Regex(((JSONString)value).getValue());
        }
        catch (Exception e) {
            String string;
            block7: {
                block6: {
                    string = e.getMessage();
                    if (string == null) break block6;
                    String it = string;
                    boolean bl = false;
                    String string2 = "- " + ((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)it, (char)'\n', null, (int)2, null))).toString();
                    string = string2;
                    if (string2 != null) break block7;
                }
                string = "";
            }
            String msg = string;
            Parser.Companion.fatal("Pattern invalid " + msg + " (" + JSONSchema.Companion.toErrorDisplay(value) + ')', uri, pointer);
            throw new KotlinNothingValueException();
        }
        Regex regex2 = regex;
        return new PatternValidator(uri, pointer, regex2);
    }

    private final JSONSchema parseDraft07(JSONValue json, JSONPointer pointer, URI parentUri) {
        return this.parseSchema(json, pointer, parentUri);
    }

    public Parser() {
        this(null, null, 3, null);
    }

    static {
        Object[] objectArray = new String[]{"http://json-schema.org/draft/2020-12/schema", "https://json-schema.org/draft/2020-12/schema"};
        schemaVersion202012 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"http://json-schema.org/draft/2019-09/schema", "https://json-schema.org/draft/2019-09/schema"};
        schemaVersion201909 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"http://json-schema.org/draft-07/schema", "https://json-schema.org/draft-07/schema"};
        schemaVersionDraft07 = CollectionsKt.listOf((Object[])objectArray);
        connectionFilters = new ArrayList();
        defaultURIResolver = Companion.defaultURIResolver.1.INSTANCE;
        defaultExtendedResolver = Companion.defaultExtendedResolver.1.INSTANCE;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0004\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00132\b\u0010\u001e\u001a\u0004\u0018\u00010\u0013J\u001c\u0010\u001f\u001a\u00020\u001b2\u0014\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005J*\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u00132\b\b\u0002\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00132\b\b\u0002\u0010&\u001a\u00020$J\u001a\u0010'\u001a\u00020\u00132\b\u0010(\u001a\u0004\u0018\u00010\n2\u0006\u0010)\u001a\u00020*H\u0002J\"\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00132\b\u0010(\u001a\u0004\u0018\u00010\n2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010.\u001a\u0004\u0018\u00010\u00132\u0006\u0010/\u001a\u000200J\"\u00101\u001a\u00020$2\b\u00102\u001a\u0004\u0018\u0001002\b\u0010(\u001a\u0004\u0018\u00010\n2\u0006\u0010)\u001a\u00020*J \u00103\u001a\u00020$2\u0006\u00104\u001a\u0002002\b\u0010(\u001a\u0004\u0018\u00010\n2\u0006\u0010)\u001a\u00020*J\n\u00105\u001a\u00020\n*\u00020\nJ>\u00106\u001a\u0004\u0018\u0001H7\"\u0004\b\u0000\u00107*\b\u0012\u0004\u0012\u0002H70\u00122\b\b\u0002\u00108\u001a\u00020$2\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u0002H7\u0012\u0004\u0012\u00020:0\u0005H\u0082\b\u00a2\u0006\u0002\u0010;J\u001e\u0010<\u001a\u0004\u0018\u00010\u0013*\u00020=2\u0006\u0010)\u001a\u00020*2\b\u0010>\u001a\u0004\u0018\u00010\u0013J\u001e\u0010?\u001a\u0004\u0018\u00010\u0013*\u00020=2\b\u0010(\u001a\u0004\u0018\u00010\n2\u0006\u0010)\u001a\u00020*J\u001e\u0010?\u001a\u0004\u0018\u00010\u0013*\u00020=2\b\u0010(\u001a\u0004\u0018\u00010\n2\u0006\u0010@\u001a\u00020\u0013J\n\u0010A\u001a\u00020:*\u00020BJ\n\u0010C\u001a\u00020:*\u00020BJ\f\u0010D\u001a\u00020\u0013*\u00020*H\u0002J\f\u0010E\u001a\u0004\u0018\u00010\u0001*\u000200J\u0012\u0010F\u001a\u00020\n*\u00020\n2\u0006\u0010)\u001a\u00020*J\u0014\u0010F\u001a\u00020\n*\u00020\n2\u0006\u0010G\u001a\u00020\u0013H\u0002R%\u0010\u0003\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001f\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001f\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\bR\u001d\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0016\u0010\u0002\u001a\u0004\b\u0017\u0010\bR\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\b\u00a8\u0006H"}, d2={"Lnet/pwall/json/schema/parser/Parser$Companion;", "", "()V", "connectionFilters", "", "Lkotlin/Function1;", "Ljava/net/HttpURLConnection;", "getConnectionFilters", "()Ljava/util/List;", "defaultExtendedResolver", "Ljava/net/URI;", "Lnet/pwall/json/schema/parser/InputDetails;", "getDefaultExtendedResolver", "()Lkotlin/jvm/functions/Function1;", "defaultURIResolver", "Ljava/io/InputStream;", "getDefaultURIResolver", "schemaVersion201909", "", "", "getSchemaVersion201909", "schemaVersion202012", "getSchemaVersion202012$annotations", "getSchemaVersion202012", "schemaVersionDraft07", "getSchemaVersionDraft07", "addAuthorizationFilter", "", "host", "headerName", "headerValue", "addConnectionFilter", "filter", "addRedirectionFilter", "fromHost", "fromPort", "", "toHost", "toPort", "errorPointer", "uri", "pointer", "Lio/kjson/pointer/JSONPointer;", "fatal", "", "message", "getIdOrNull", "jsonValue", "Lio/kjson/JSONValue;", "getInteger", "value", "getNonNegativeInteger", "json", "dropFragment", "findStartingFrom", "T", "index", "predicate", "", "(Ljava/util/List;ILkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "getStringOrDefault", "Lio/kjson/JSONObject;", "default", "getStringOrNull", "key", "isPositive", "", "isZero", "pointerOrRoot", "toSimpleValue", "withFragment", "newFragment", "json-kotlin-schema"})
    @SourceDebugExtension(value={"SMAP\nParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Parser.kt\nnet/pwall/json/schema/parser/Parser$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 JSON.kt\nio/kjson/JSON\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,663:1\n1#2:664\n420#3:665\n1549#4:666\n1620#4,3:667\n1238#4,4:672\n453#5:670\n403#5:671\n*S KotlinDebug\n*F\n+ 1 Parser.kt\nnet/pwall/json/schema/parser/Parser$Companion\n*L\n600#1:665\n656#1:666\n656#1:667,3\n657#1:672,4\n657#1:670\n657#1:671\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getSchemaVersion202012() {
            return schemaVersion202012;
        }

        public static /* synthetic */ void getSchemaVersion202012$annotations() {
        }

        @NotNull
        public final List<String> getSchemaVersion201909() {
            return schemaVersion201909;
        }

        @NotNull
        public final List<String> getSchemaVersionDraft07() {
            return schemaVersionDraft07;
        }

        @NotNull
        public final List<Function1<HttpURLConnection, HttpURLConnection>> getConnectionFilters() {
            return connectionFilters;
        }

        public final void addConnectionFilter(@NotNull Function1<? super HttpURLConnection, ? extends HttpURLConnection> filter) {
            Intrinsics.checkNotNullParameter(filter, (String)"filter");
            this.getConnectionFilters().add(filter);
        }

        public final void addAuthorizationFilter(@NotNull String host, @NotNull String headerName, @Nullable String headerValue) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)headerName, (String)"headerName");
            this.addConnectionFilter((Function1<? super HttpURLConnection, ? extends HttpURLConnection>)((Function1)new ResourceLoader.AuthorizationFilter(host, headerName, headerValue)));
        }

        public final void addRedirectionFilter(@NotNull String fromHost, int fromPort, @NotNull String toHost, int toPort) {
            Intrinsics.checkNotNullParameter((Object)fromHost, (String)"fromHost");
            Intrinsics.checkNotNullParameter((Object)toHost, (String)"toHost");
            this.addConnectionFilter((Function1<? super HttpURLConnection, ? extends HttpURLConnection>)((Function1)new ResourceLoader.RedirectionFilter(fromHost, fromPort, toHost, toPort)));
        }

        public static /* synthetic */ void addRedirectionFilter$default(Companion companion, String string, int n, String string2, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = -1;
            }
            if ((n3 & 8) != 0) {
                n2 = -1;
            }
            companion.addRedirectionFilter(string, n, string2, n2);
        }

        @NotNull
        public final Function1<URI, InputStream> getDefaultURIResolver() {
            return defaultURIResolver;
        }

        @NotNull
        public final Function1<URI, InputDetails> getDefaultExtendedResolver() {
            return defaultExtendedResolver;
        }

        private final <T> T findStartingFrom(List<? extends T> $this$findStartingFrom, int index, Function1<? super T, Boolean> predicate) {
            boolean $i$f$findStartingFrom = false;
            int n = $this$findStartingFrom.size();
            for (int i = index; i < n; ++i) {
                T it = $this$findStartingFrom.get(i);
                boolean bl = false;
                if (!((Boolean)predicate.invoke(it)).booleanValue()) continue;
                return it;
            }
            return null;
        }

        static /* synthetic */ Object findStartingFrom$default(Companion $this, List $receiver, int index, Function1 predicate, int n, Object object) {
            if ((n & 1) != 0) {
                index = 0;
            }
            boolean $i$f$findStartingFrom = false;
            int n2 = $receiver.size();
            for (int i = index; i < n2; ++i) {
                Object it = $receiver.get(i);
                boolean bl = false;
                if (!((Boolean)predicate.invoke(it)).booleanValue()) continue;
                return it;
            }
            return null;
        }

        @NotNull
        public final URI dropFragment(@NotNull URI $this$dropFragment) {
            Intrinsics.checkNotNullParameter((Object)$this$dropFragment, (String)"<this>");
            return $this$dropFragment.getFragment() == null ? $this$dropFragment : ($this$dropFragment.isOpaque() ? new URI($this$dropFragment.getScheme(), $this$dropFragment.getSchemeSpecificPart(), null) : new URI($this$dropFragment.getScheme(), $this$dropFragment.getAuthority(), $this$dropFragment.getPath(), $this$dropFragment.getQuery(), null));
        }

        private final URI withFragment(URI $this$withFragment, String newFragment) {
            return $this$withFragment.isOpaque() ? new URI($this$withFragment.getScheme(), $this$withFragment.getSchemeSpecificPart(), newFragment) : new URI($this$withFragment.getScheme(), $this$withFragment.getAuthority(), $this$withFragment.getPath(), $this$withFragment.getQuery(), newFragment);
        }

        @NotNull
        public final URI withFragment(@NotNull URI $this$withFragment, @NotNull JSONPointer pointer) {
            URI uRI;
            Intrinsics.checkNotNullParameter((Object)$this$withFragment, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
            if (Intrinsics.areEqual((Object)pointer, (Object)JSONPointer.Companion.getRoot())) {
                uRI = this.dropFragment($this$withFragment);
            } else {
                String string = pointer.toURIFragment().substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                uRI = this.withFragment($this$withFragment, string);
            }
            return uRI;
        }

        private final Void fatal(String message, URI uri, JSONPointer pointer) {
            throw new JSONSchemaException(message + " - " + this.errorPointer(uri, pointer));
        }

        private final String errorPointer(URI uri, JSONPointer pointer) {
            String string;
            URI uRI = uri;
            if ((uRI != null && (uRI = this.withFragment(uRI, pointer)) != null ? uRI.toString() : (string = null)) == null) {
                string = this.pointerOrRoot(pointer);
            }
            return string;
        }

        private final String pointerOrRoot(JSONPointer $this$pointerOrRoot) {
            return Intrinsics.areEqual((Object)$this$pointerOrRoot, (Object)JSONPointer.Companion.getRoot()) ? "root" : $this$pointerOrRoot.toString();
        }

        public final int getInteger(@Nullable JSONValue value, @Nullable URI uri, @NotNull JSONPointer pointer) {
            Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
            JSON jSON = JSON.INSTANCE;
            JSONValue $this$asIntOr$iv = value;
            boolean $i$f$asIntOr = false;
            if (!($this$asIntOr$iv instanceof JSONNumber) || !((JSONNumber)$this$asIntOr$iv).isInt()) {
                JSONValue $this$getInteger_u24lambda_u241 = $this$asIntOr$iv;
                boolean bl = false;
                Companion.fatal("Must be integer", uri, pointer);
                throw new KotlinNothingValueException();
            }
            return ((JSONNumber)$this$asIntOr$iv).intValue();
        }

        public final int getNonNegativeInteger(@NotNull JSONValue json, @Nullable URI uri, @NotNull JSONPointer pointer) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
            JSONValue value = IndexOpKt.get((JSONValue)json, (JSONPointer)pointer);
            if (value instanceof JSONNumber && ((JSONNumber)value).isInt() && ((JSONNumber)value).isNotNegative()) {
                return ((JSONNumber)value).intValue();
            }
            this.fatal("Must be non-negative integer", uri, pointer);
            throw new KotlinNothingValueException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final String getStringOrNull(@NotNull JSONObject $this$getStringOrNull, @Nullable URI uri, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)$this$getStringOrNull, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            JSONValue jSONValue = (JSONValue)$this$getStringOrNull.get((Object)key);
            if (jSONValue == null) return null;
            JSONValue it = jSONValue;
            boolean bl = false;
            if (!(it instanceof JSONString)) {
                Companion.fatal("Must be string", uri, JSONPointer.Companion.getRoot().child(key));
                throw new KotlinNothingValueException();
            }
            String string = ((JSONString)it).getValue();
            return string;
        }

        @Nullable
        public final String getStringOrNull(@NotNull JSONObject $this$getStringOrNull, @Nullable URI uri, @NotNull JSONPointer pointer) {
            Intrinsics.checkNotNullParameter((Object)$this$getStringOrNull, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
            if (!FindKt.existsIn((JSONPointer)pointer, (JSONValue)((JSONValue)$this$getStringOrNull))) {
                return null;
            }
            JSONValue value = IndexOpKt.get((JSONValue)((JSONValue)$this$getStringOrNull), (JSONPointer)pointer);
            if (!(value instanceof JSONString)) {
                this.fatal("Must be string", uri, pointer);
                throw new KotlinNothingValueException();
            }
            return ((JSONString)value).getValue();
        }

        @Nullable
        public final String getStringOrDefault(@NotNull JSONObject $this$getStringOrDefault, @NotNull JSONPointer pointer, @Nullable String string) {
            Intrinsics.checkNotNullParameter((Object)$this$getStringOrDefault, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
            if (!FindKt.existsIn((JSONPointer)pointer, (JSONValue)((JSONValue)$this$getStringOrDefault))) {
                return string;
            }
            JSONValue value = IndexOpKt.get((JSONValue)((JSONValue)$this$getStringOrDefault), (JSONPointer)pointer);
            if (!(value instanceof JSONString)) {
                throw new JSONSchemaException("Incorrect " + pointer);
            }
            return ((JSONString)value).getValue();
        }

        public final boolean isZero(@NotNull Number $this$isZero) {
            Intrinsics.checkNotNullParameter((Object)$this$isZero, (String)"<this>");
            Number number = $this$isZero;
            return number instanceof BigDecimal ? ((BigDecimal)$this$isZero).compareTo(BigDecimal.ZERO) == 0 : (number instanceof BigInteger ? Intrinsics.areEqual((Object)$this$isZero, (Object)BigInteger.ZERO) : (number instanceof Double ? $this$isZero.doubleValue() == 0.0 : (number instanceof Float ? $this$isZero.floatValue() == 0.0f : (number instanceof Long ? Intrinsics.areEqual((Object)$this$isZero, (Object)0L) : $this$isZero.intValue() == 0))));
        }

        public final boolean isPositive(@NotNull Number $this$isPositive) {
            Intrinsics.checkNotNullParameter((Object)$this$isPositive, (String)"<this>");
            Number number = $this$isPositive;
            return number instanceof BigDecimal ? ((BigDecimal)$this$isPositive).compareTo(BigDecimal.ZERO) > 0 : (number instanceof BigInteger ? ((BigInteger)$this$isPositive).compareTo(BigInteger.ZERO) > 0 : (number instanceof Double ? $this$isPositive.doubleValue() > 0.0 : (number instanceof Float ? $this$isPositive.floatValue() > 0.0f : (number instanceof Long ? $this$isPositive.longValue() > 0L : $this$isPositive.intValue() > 0))));
        }

        @Nullable
        public final String getIdOrNull(@NotNull JSONValue jsonValue) {
            Intrinsics.checkNotNullParameter((Object)jsonValue, (String)"jsonValue");
            JSONObject jSONObject = jsonValue instanceof JSONObject ? (JSONObject)jsonValue : null;
            JSONValue jSONValue = jSONObject != null ? (JSONValue)jSONObject.get((Object)"$id") : null;
            JSONString jSONString = jSONValue instanceof JSONString ? (JSONString)jSONValue : null;
            return jSONString != null ? jSONString.getValue() : null;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Object toSimpleValue(@NotNull JSONValue $this$toSimpleValue) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)$this$toSimpleValue, (String)"<this>");
            JSONValue jSONValue = $this$toSimpleValue;
            if (jSONValue instanceof JSONPrimitive) {
                object = ((JSONPrimitive)$this$toSimpleValue).getValue();
            } else if (jSONValue instanceof JSONArray) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)$this$toSimpleValue;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JSONValue jSONValue2 = (JSONValue)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    void v1 = it;
                    collection.add(v1 != null ? Companion.toSimpleValue((JSONValue)v1) : null);
                }
                object = (List)destination$iv$iv;
            } else if (jSONValue instanceof JSONObject) {
                void $this$mapValuesTo$iv$iv;
                Map $this$mapValues$iv = (Map)$this$toSimpleValue;
                boolean $i$f$mapValues = false;
                Map $this$mapTo$iv$iv = $this$mapValues$iv;
                Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it;
                    void it$iv$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    Map map = destination$iv$iv;
                    boolean bl = false;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    Object k = it$iv$iv.getKey();
                    Map map2 = map;
                    boolean bl2 = false;
                    JSONValue jSONValue3 = (JSONValue)it.getValue();
                    Object object2 = jSONValue3 != null ? Companion.toSimpleValue(jSONValue3) : null;
                    map2.put(k, object2);
                }
                object = destination$iv$iv;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return object;
        }

        public static final /* synthetic */ String access$errorPointer(Companion $this, URI uri, JSONPointer pointer) {
            return $this.errorPointer(uri, pointer);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\b\"\u0004\b\u000e\u0010\n\u00a8\u0006\u0019"}, d2={"Lnet/pwall/json/schema/parser/Parser$Options;", "", "allowDescriptionRef", "", "validateExamples", "validateDefault", "(ZZZ)V", "getAllowDescriptionRef", "()Z", "setAllowDescriptionRef", "(Z)V", "getValidateDefault", "setValidateDefault", "getValidateExamples", "setValidateExamples", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "json-kotlin-schema"})
    public static final class Options {
        private boolean allowDescriptionRef;
        private boolean validateExamples;
        private boolean validateDefault;

        public Options(boolean allowDescriptionRef, boolean validateExamples, boolean validateDefault) {
            this.allowDescriptionRef = allowDescriptionRef;
            this.validateExamples = validateExamples;
            this.validateDefault = validateDefault;
        }

        public /* synthetic */ Options(boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            if ((n & 4) != 0) {
                bl3 = false;
            }
            this(bl, bl2, bl3);
        }

        public final boolean getAllowDescriptionRef() {
            return this.allowDescriptionRef;
        }

        public final void setAllowDescriptionRef(boolean bl) {
            this.allowDescriptionRef = bl;
        }

        public final boolean getValidateExamples() {
            return this.validateExamples;
        }

        public final void setValidateExamples(boolean bl) {
            this.validateExamples = bl;
        }

        public final boolean getValidateDefault() {
            return this.validateDefault;
        }

        public final void setValidateDefault(boolean bl) {
            this.validateDefault = bl;
        }

        public final boolean component1() {
            return this.allowDescriptionRef;
        }

        public final boolean component2() {
            return this.validateExamples;
        }

        public final boolean component3() {
            return this.validateDefault;
        }

        @NotNull
        public final Options copy(boolean allowDescriptionRef, boolean validateExamples, boolean validateDefault) {
            return new Options(allowDescriptionRef, validateExamples, validateDefault);
        }

        public static /* synthetic */ Options copy$default(Options options, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
            if ((n & 1) != 0) {
                bl = options.allowDescriptionRef;
            }
            if ((n & 2) != 0) {
                bl2 = options.validateExamples;
            }
            if ((n & 4) != 0) {
                bl3 = options.validateDefault;
            }
            return options.copy(bl, bl2, bl3);
        }

        @NotNull
        public String toString() {
            return "Options(allowDescriptionRef=" + this.allowDescriptionRef + ", validateExamples=" + this.validateExamples + ", validateDefault=" + this.validateDefault + ')';
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.allowDescriptionRef);
            result = result * 31 + Boolean.hashCode(this.validateExamples);
            result = result * 31 + Boolean.hashCode(this.validateDefault);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Options)) {
                return false;
            }
            Options options = (Options)other;
            if (this.allowDescriptionRef != options.allowDescriptionRef) {
                return false;
            }
            if (this.validateExamples != options.validateExamples) {
                return false;
            }
            return this.validateDefault == options.validateDefault;
        }

        public Options() {
            this(false, false, false, 7, null);
        }
    }
}

