/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json.schema.subschema;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.pwall.json.JSONSequence;
import net.pwall.json.JSONValue;
import net.pwall.json.pointer.JSONPointer;
import net.pwall.json.schema.JSONSchema;
import net.pwall.json.schema.output.BasicOutput;
import net.pwall.json.schema.output.DetailedOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\"\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\"\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lnet/pwall/json/schema/subschema/ItemsArraySchema;", "Lnet/pwall/json/schema/JSONSchema$SubSchema;", "uri", "Ljava/net/URI;", "location", "Lnet/pwall/json/pointer/JSONPointer;", "itemSchemaList", "", "Lnet/pwall/json/schema/JSONSchema;", "(Ljava/net/URI;Lnet/pwall/json/pointer/JSONPointer;Ljava/util/List;)V", "getItemSchemaList", "()Ljava/util/List;", "childLocation", "pointer", "equals", "", "other", "", "hashCode", "", "validate", "json", "Lnet/pwall/json/JSONValue;", "instanceLocation", "validateBasic", "Lnet/pwall/json/schema/output/BasicOutput;", "relativeLocation", "validateDetailed", "Lnet/pwall/json/schema/output/DetailedOutput;", "json-kotlin-schema"})
public final class ItemsArraySchema
extends JSONSchema.SubSchema {
    @NotNull
    private final List<JSONSchema> itemSchemaList;

    public ItemsArraySchema(@Nullable URI uri, @NotNull JSONPointer location, @NotNull List<? extends JSONSchema> itemSchemaList) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter(itemSchemaList, (String)"itemSchemaList");
        super(uri, location);
        this.itemSchemaList = itemSchemaList;
    }

    @NotNull
    public final List<JSONSchema> getItemSchemaList() {
        return this.itemSchemaList;
    }

    @Override
    @NotNull
    public JSONPointer childLocation(@NotNull JSONPointer pointer) {
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        JSONPointer jSONPointer = pointer.child("items");
        Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"pointer.child(\"items\")");
        return jSONPointer;
    }

    @Override
    public boolean validate(@Nullable JSONValue json, @NotNull JSONPointer instanceLocation) {
        Intrinsics.checkNotNullParameter((Object)instanceLocation, (String)"instanceLocation");
        JSONValue instance = instanceLocation.eval(json);
        if (!(instance instanceof JSONSequence)) {
            return true;
        }
        int n = 0;
        int n2 = Math.min(((JSONSequence)instance).size(), this.itemSchemaList.size());
        while (n < n2) {
            int i = n++;
            JSONPointer jSONPointer = instanceLocation.child(i);
            Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"instanceLocation.child(i)");
            if (this.itemSchemaList.get(i).validate(json, jSONPointer)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public BasicOutput validateBasic(@NotNull JSONPointer relativeLocation, @Nullable JSONValue json, @NotNull JSONPointer instanceLocation) {
        Intrinsics.checkNotNullParameter((Object)relativeLocation, (String)"relativeLocation");
        Intrinsics.checkNotNullParameter((Object)instanceLocation, (String)"instanceLocation");
        JSONValue instance = instanceLocation.eval(json);
        if (!(instance instanceof JSONSequence)) {
            return BasicOutput.Companion.getTrueOutput();
        }
        List errors = new ArrayList();
        int n = 0;
        int n2 = Math.min(((JSONSequence)instance).size(), this.itemSchemaList.size());
        while (n < n2) {
            int i = n++;
            JSONPointer jSONPointer = relativeLocation.child(i);
            Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"relativeLocation.child(i)");
            JSONPointer jSONPointer2 = jSONPointer;
            jSONPointer = instanceLocation.child(i);
            Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"instanceLocation.child(i)");
            BasicOutput it = this.itemSchemaList.get(i).validateBasic(jSONPointer2, json, jSONPointer);
            boolean bl = false;
            if (it.getValid()) continue;
            JSONSchema.Companion.addAllFromNullable(errors, (Collection)it.getErrors());
        }
        if (errors.isEmpty()) {
            return BasicOutput.Companion.getTrueOutput();
        }
        return new BasicOutput(false, errors);
    }

    @Override
    @NotNull
    public DetailedOutput validateDetailed(@NotNull JSONPointer relativeLocation, @Nullable JSONValue json, @NotNull JSONPointer instanceLocation) {
        DetailedOutput detailedOutput;
        Intrinsics.checkNotNullParameter((Object)relativeLocation, (String)"relativeLocation");
        Intrinsics.checkNotNullParameter((Object)instanceLocation, (String)"instanceLocation");
        JSONValue instance = instanceLocation.eval(json);
        if (!(instance instanceof JSONSequence)) {
            return JSONSchema.createAnnotation$default(this, relativeLocation, instanceLocation, "Value is not an array", null, null, 24, null);
        }
        List errors = new ArrayList();
        int n = 0;
        int n2 = Math.min(((JSONSequence)instance).size(), this.itemSchemaList.size());
        while (n < n2) {
            int i = n++;
            JSONPointer jSONPointer = relativeLocation.child(i);
            Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"relativeLocation.child(i)");
            JSONPointer jSONPointer2 = jSONPointer;
            jSONPointer = instanceLocation.child(i);
            Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"instanceLocation.child(i)");
            DetailedOutput it = this.itemSchemaList.get(i).validateDetailed(jSONPointer2, json, jSONPointer);
            boolean bl = false;
            if (it.getValid()) continue;
            errors.add(it);
        }
        switch (errors.size()) {
            case 0: {
                detailedOutput = JSONSchema.createAnnotation$default(this, relativeLocation, instanceLocation, "All items are valid", null, null, 24, null);
                break;
            }
            case 1: {
                detailedOutput = (DetailedOutput)errors.get(0);
                break;
            }
            default: {
                detailedOutput = JSONSchema.createError$default(this, relativeLocation, instanceLocation, "Errors in array items", errors, null, 16, null);
            }
        }
        return detailedOutput;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof ItemsArraySchema && super.equals(other) && Intrinsics.areEqual(this.itemSchemaList, ((ItemsArraySchema)other).itemSchemaList);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ ((Object)this.itemSchemaList).hashCode();
    }
}

