/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.rqm;

import hudson.model.Action;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.praqma.jenkins.rqm.model.RqmObject;
import net.praqma.jenkins.rqm.model.TestCase;
import net.praqma.jenkins.rqm.model.TopLevelObject;

public class RqmBuildAction
implements Action {
    private static final String NAME = "RQM Test Report";
    public final List<? extends RqmObject> topLevelObjects;
    private int index;

    public RqmBuildAction(List<? extends RqmObject> topLevelObjects) {
        this.topLevelObjects = topLevelObjects;
    }

    public String getIconFileName() {
        return "/plugin/rqm-plugin/images/64x64/rqm-icon.png";
    }

    public String getDisplayName() {
        return "RQM Test Report " + this.index;
    }

    public String getUrlName() {
        return NAME.replaceAll(" ", "") + this.index;
    }

    public List<TestCase> getSelectedTestCases() {
        ArrayList<TestCase> testcases = new ArrayList<TestCase>();
        if (this.topLevelObjects != null) {
            for (RqmObject rqmObject : this.topLevelObjects) {
                if (!(rqmObject instanceof TopLevelObject)) continue;
                testcases.addAll(((TopLevelObject)((Object)rqmObject)).getAllTestCases());
            }
        }
        return testcases;
    }

    public List<TestCase> getFailedTests() {
        ArrayList<TestCase> failedTests = new ArrayList<TestCase>();
        if (this.topLevelObjects != null) {
            for (RqmObject rqmObject : this.topLevelObjects) {
                if (!(rqmObject instanceof TopLevelObject)) continue;
                Set<TestCase> allCases = ((TopLevelObject)((Object)rqmObject)).getAllTestCases();
                for (TestCase tc : allCases) {
                    if (!tc.hasTestScriptExecutionErrors()) continue;
                    failedTests.add(tc);
                }
            }
        }
        return failedTests;
    }

    public boolean isProblem() {
        return !this.getFailedTests().isEmpty();
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

