/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.rqm.request;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.praqma.jenkins.rqm.model.exception.ClientCreationException;
import net.praqma.jenkins.rqm.request.RQMSSLFactory;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

public class RQMHttpClient
extends HttpClient {
    private final String usr;
    private final String contextRoot;
    private final String password;
    private final String project;
    private final String host;
    private final int port;
    private URL url;
    private static final Logger log = Logger.getLogger(RQMHttpClient.class.getName());
    private static final String JAZZ_LOGOUT_URL = "/service/com.ibm.team.repository.service.internal.ILogoutRestService";

    public RQMHttpClient(String host, int port, String contextRoot, String project, String usr, String password) throws ClientCreationException {
        this.usr = usr;
        this.password = password;
        try {
            this.project = URLEncoder.encode(project, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new ClientCreationException("Failed to create RQMHttpClient (constructor) ", ex);
        }
        this.contextRoot = contextRoot;
        this.host = host;
        this.port = port;
        try {
            if (host.contains("https://")) {
                this.url = new URL("https", host.replace("https://", ""), port, "/");
            } else if (host.contains("http://")) {
                this.url = new URL("http", host.replace("http://", ""), port, "/");
            }
        }
        catch (MalformedURLException malformedUrl) {
            throw new ClientCreationException("Failed to create RQMHttpClient(constructor)", malformedUrl);
        }
        this.getParams().setParameter("http.protocol.single-cookie-header", (Object)true);
        String cookiePolicy = System.getenv("RQM_CLIENT_COOKIE_POLICY");
        if (cookiePolicy == null) {
            cookiePolicy = "compatibility";
        }
        this.getParams().setCookiePolicy(cookiePolicy);
    }

    public void registerTrustingSSL() throws GeneralSecurityException {
        log.finest("registering trusting ssl factory");
        Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (SecureProtocolSocketFactory)RQMSSLFactory.getInstance(), 443));
    }

    public int login() throws HttpException, IOException, GeneralSecurityException {
        log.finest("Register trusting ssl");
        this.registerTrustingSSL();
        GetMethod methodPart1 = new GetMethod(this.url.toString() + this.contextRoot + "/auth/authrequired");
        int response = this.executeMethod((HttpMethod)methodPart1);
        this.followRedirects((HttpMethodBase)methodPart1, response);
        GetMethod methodPart2 = new GetMethod(this.url.toString() + this.contextRoot + "/authenticated/identity");
        response = this.executeMethod((HttpMethod)methodPart2);
        this.followRedirects((HttpMethodBase)methodPart2, response);
        PostMethod authenticationMethod = null;
        Header authenticateHeader = methodPart2.getResponseHeader("WWW-Authenticate");
        if (response == 401 && authenticateHeader != null && authenticateHeader.getValue().toLowerCase().indexOf("basic realm") == 0) {
            super.getState().setCredentials(new AuthScope(this.host, this.port), (Credentials)new UsernamePasswordCredentials(this.getUsr(), this.getPassword()));
            String authMethod = this.url.toString() + "/authenticated/identity";
            authenticationMethod = new GetMethod(authMethod);
            response = super.executeMethod((HttpMethod)methodPart2);
        } else {
            authenticationMethod = new PostMethod(this.url.toString() + this.contextRoot + "/j_security_check");
            NameValuePair[] nvps = new NameValuePair[]{new NameValuePair("j_username", this.getUsr()), new NameValuePair("j_password", this.getPassword())};
            authenticationMethod.addParameters(nvps);
            authenticationMethod.addRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
            response = this.executeMethod((HttpMethod)authenticationMethod);
            Header location = authenticationMethod.getResponseHeader("X-com-ibm-team-repository-web-auth-msg");
            if (location != null && location.getValue().indexOf("authfailed") >= 0) {
                response = 401;
            }
        }
        if (response != 200 && response != 302) {
            if (response != 401) {
                String body = "";
                try {
                    body = authenticationMethod.getResponseBodyAsString();
                }
                catch (Exception e) {
                    log.severe(String.format("Failed to login, with response code %s %n Response body: %n %s", response, body));
                }
                log.severe(String.format("Failed to login, with response code %s %n Response body: %n %s", response, body));
            }
        } else {
            this.followRedirects((HttpMethodBase)authenticationMethod, response);
            String methodText = String.format("%s%s/service/com.ibm.team.repository.service.internal.webuiInitializer.IWebUIInitializerRestService/initializationData", this.url.toString(), this.contextRoot);
            GetMethod get3 = new GetMethod(methodText);
            response = this.executeMethod((HttpMethod)get3);
            this.followRedirects((HttpMethodBase)get3, response);
        }
        log.finest("Response was: " + response);
        return response;
    }

    public int logout() {
        log.finest("Logout");
        try {
            log.finest("URI:" + this.url.toURI().toString());
        }
        catch (URISyntaxException ex) {
            log.finest("Logout URISyntaxException " + ex.getMessage());
        }
        String logoutUrl = this.url.toString() + this.contextRoot + JAZZ_LOGOUT_URL;
        log.finest("Attempting to log out with this url: " + logoutUrl);
        PostMethod authenticationMethod = new PostMethod(this.url.toString() + this.contextRoot + JAZZ_LOGOUT_URL);
        authenticationMethod.setFollowRedirects(false);
        UsernamePasswordCredentials credentials = (UsernamePasswordCredentials)super.getState().getCredentials(new AuthScope(this.host, this.port));
        if (!(null == credentials || credentials.getUserName().isEmpty() && credentials.getPassword().isEmpty())) {
            log.finest(String.format("Adding authorizationheadder for logout for user: %s", credentials.getUserName()));
            authenticationMethod.addRequestHeader("Authorization:", "Base " + credentials.getUserName() + ":" + credentials.getPassword());
        }
        String body = "";
        String status = "";
        int responseCode = 0;
        try {
            responseCode = this.executeMethod((HttpMethod)authenticationMethod);
            body = authenticationMethod.getResponseBodyAsString();
            status = authenticationMethod.getStatusText();
            log.finest(String.format("Response code %s, Status text %s", responseCode, status));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to log out!", e);
            log.log(Level.SEVERE, body);
        }
        return responseCode;
    }

    public void followRedirects(HttpMethodBase method, int responseCode) throws HttpException, IOException {
        Header location = method.getResponseHeader("Location");
        while (location != null && responseCode == 302) {
            GetMethod get3 = new GetMethod(location.getValue());
            responseCode = this.executeMethod((HttpMethod)get3);
            if (responseCode != 200) {
                log.fine(String.format("Follow redirects returned code %s", responseCode));
            }
            location = get3.getResponseHeader("Location");
        }
    }

    public String getUsr() {
        return this.usr;
    }

    public String getPassword() {
        return this.password;
    }
}

