/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.rqm.collector;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.EnvironmentContributingAction;
import hudson.model.Result;
import hudson.tasks.BuildStep;
import java.util.List;
import java.util.logging.Logger;
import net.praqma.jenkins.rqm.RqmBuilder;
import net.praqma.jenkins.rqm.RqmCollector;
import net.praqma.jenkins.rqm.RqmCollectorDescriptor;
import net.praqma.jenkins.rqm.RqmObjectCreator;
import net.praqma.jenkins.rqm.model.RqmObject;
import net.praqma.jenkins.rqm.model.TestCase;
import net.praqma.jenkins.rqm.model.TestScript;
import net.praqma.jenkins.rqm.model.TestSuiteExecutionRecord;
import net.praqma.jenkins.rqm.request.RqmParameterList;
import org.apache.commons.httpclient.NameValuePair;
import org.kohsuke.stapler.DataBoundConstructor;

public class RqmTestSuiteExectionRecordCollectionStrategy
extends RqmCollector {
    private static final Logger log = Logger.getLogger(RqmTestSuiteExectionRecordCollectionStrategy.class.getName());
    public final String executionRecordName;
    public final String planName;
    public final String projectName;

    @DataBoundConstructor
    public RqmTestSuiteExectionRecordCollectionStrategy(String executionRecordName, String planName, String projectName) {
        this.executionRecordName = executionRecordName;
        this.planName = planName;
        this.projectName = projectName;
    }

    @Override
    public <T extends RqmObject> List<T> collect(BuildListener listener, AbstractBuild<?, ?> build) throws Exception {
        NameValuePair[] filterProperties = TestSuiteExecutionRecord.getFilteringProperties(this.planName, this.getPort(), this.planName, this.executionRecordName);
        String request = TestSuiteExecutionRecord.getResourceFeedUrl(this.getHostName(), this.getPort(), this.getContextRoot(), this.projectName);
        RqmParameterList list = new RqmParameterList(this.getHostName(), this.getPort(), this.getContextRoot(), this.projectName, this.getUsrName(), this.getPasswd(), request, filterProperties, "GET", null);
        log.fine(list.toString());
        RqmObjectCreator<TestSuiteExecutionRecord> object = new RqmObjectCreator<TestSuiteExecutionRecord>(TestSuiteExecutionRecord.class, list);
        return (List)build.getWorkspace().act(object);
    }

    @Override
    public boolean execute(AbstractBuild<?, ?> build, BuildListener listener, Launcher launcher, List<BuildStep> preBuildSteps, List<BuildStep> postBuildSteps, List<BuildStep> iterativeTestCaseBuilders, List<? extends RqmObject> results) throws Exception {
        boolean success = true;
        List<? extends RqmObject> records = results;
        if (preBuildSteps != null) {
            listener.getLogger().println(String.format("Performing pre build step", new Object[0]));
            for (BuildStep buildStep : preBuildSteps) {
                success &= buildStep.perform(build, launcher, listener);
            }
        }
        for (final TestSuiteExecutionRecord testSuiteExecutionRecord : records) {
            listener.getLogger().println(String.format("Test Suite %s [%s] ", testSuiteExecutionRecord.getTestSuite().getTestSuiteTitle(), testSuiteExecutionRecord.getTestSuite().getRqmObjectResourceUrl()));
            listener.getLogger().println(String.format("Test Suite Execution Record %s [%s]", testSuiteExecutionRecord.getTestSuiteExecutionRecordTitle(), testSuiteExecutionRecord.getRqmObjectResourceUrl()));
            for (final TestCase tc : testSuiteExecutionRecord.getTestSuite().getTestcases()) {
                listener.getLogger().println(String.format(" Test Case %s [%s]", tc.getTestCaseTitle(), tc.getRqmObjectResourceUrl()));
                if (tc.getScripts().isEmpty()) {
                    listener.getLogger().println("Test case %s does not contain any scripts, setting result to unstable");
                    build.setResult(Result.UNSTABLE);
                }
                for (final TestScript ts : tc.getScripts()) {
                    listener.getLogger().println(String.format(" * Test Script %s [%s]", ts.getScriptTitle(), ts.getRqmObjectResourceUrl()));
                    for (BuildStep bstep : iterativeTestCaseBuilders) {
                        EnvironmentContributingAction envAction = new EnvironmentContributingAction(){

                            public void buildEnvVars(AbstractBuild<?, ?> ab, EnvVars ev) {
                                RqmBuilder.addToEnvironment(ev, testSuiteExecutionRecord.getTestSuite().attributes());
                                RqmBuilder.addToEnvironment(ev, testSuiteExecutionRecord.getTestPlan().attributes());
                                RqmBuilder.addToEnvironment(ev, tc.attributes());
                                RqmBuilder.addToEnvironment(ev, ts.attributes());
                            }

                            public String getIconFileName() {
                                return null;
                            }

                            public String getDisplayName() {
                                return null;
                            }

                            public String getUrlName() {
                                return null;
                            }
                        };
                        build.addAction((Action)envAction);
                        success &= bstep.perform(build, launcher, listener);
                        build.getActions().remove(envAction);
                    }
                }
            }
        }
        if (postBuildSteps != null) {
            listener.getLogger().println(String.format("Performing post build step", new Object[0]));
            for (BuildStep buildStep : postBuildSteps) {
                success &= buildStep.perform(build, launcher, listener);
            }
        }
        return success;
    }

    @Extension
    public static class RqmTestSuiteCollectionStrategyImpl
    extends RqmCollectorDescriptor {
        public String getDisplayName() {
            return "Test suite exection record selection stategy";
        }
    }
}

