/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.rqm.request;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.praqma.jenkins.rqm.model.exception.LoginException;
import net.praqma.jenkins.rqm.model.exception.RequestException;
import net.praqma.jenkins.rqm.request.RQMHttpClient;
import net.praqma.jenkins.rqm.request.RQMRequest;
import net.praqma.util.structure.Tuple;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;

public class RQMPutRequest
implements RQMRequest {
    private static final Pattern RESOURCE_PATTERN = Pattern.compile("http([s]?)://(.+)(:([0-9]+))?/(.+)/service/com.ibm.rqm.integration.service.IIntegrationService/resources/([^/]+)/([^/]+)(/(.*))?");
    private PutMethod method = null;
    private RQMHttpClient client;
    private String requestContent;
    private static final Logger log = Logger.getLogger(RQMPutRequest.class.getName());

    public RQMPutRequest(RQMHttpClient client, String url, NameValuePair[] parameters, String requestContent) {
        this.method = new PutMethod(url);
        this.client = client;
        this.requestContent = requestContent;
    }

    @Override
    public Tuple<Integer, String> executeRequest() throws LoginException, RequestException {
        Tuple result = new Tuple();
        try {
            this.client.login();
            BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(this.requestContent.getBytes(Charset.forName("utf8"))));
            this.method.setRequestEntity((RequestEntity)new InputStreamRequestEntity((InputStream)bis, "application/xml"));
            int returnCode = this.client.executeMethod((HttpMethod)this.method);
            result.t1 = returnCode;
            result.t2 = this.method.getResponseBodyAsString();
            bis.close();
            Tuple tuple = result;
            return tuple;
        }
        catch (HttpException ex) {
            log.finest(String.format("HttpException: %s", ex.getMessage()));
            throw new LoginException(this.client.getUsr(), this.client.getPassword(), ex);
        }
        catch (IOException ex) {
            log.finest(String.format("IOException: %s", ex.getMessage()));
            throw new LoginException(this.client.getUsr(), this.client.getPassword(), ex);
        }
        catch (GeneralSecurityException ex) {
            log.finest(String.format("GeneralSecurityException: %s", ex.getMessage()));
            throw new LoginException(this.client.getUsr(), this.client.getPassword(), ex);
        }
        finally {
            this.client.logout();
        }
    }
}

