/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.rqm;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.tasks.junit.JUnitParser;
import hudson.tasks.junit.TestResult;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashSet;
import jenkins.model.Jenkins;
import net.praqma.jenkins.rqm.RQMBuildAction;
import net.praqma.jenkins.rqm.RQMProjectAction;
import net.praqma.jenkins.rqm.RQMTestCaseScriptExecutor;
import net.praqma.jenkins.rqm.RqmObjectCreator;
import net.praqma.jenkins.rqm.model.TestCase;
import net.praqma.jenkins.rqm.model.TestCaseExecutionRecord;
import net.praqma.jenkins.rqm.model.TestExecutionResult;
import net.praqma.jenkins.rqm.model.TestPlan;
import net.praqma.jenkins.rqm.model.TestScript;
import net.praqma.jenkins.rqm.model.TestSuite;
import net.praqma.jenkins.rqm.model.exception.RequestException;
import net.praqma.jenkins.rqm.request.RQMUtilities;
import net.praqma.jenkins.rqm.request.RqmParameterList;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.NameValuePair;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class RqmBuilder
extends Builder {
    public final String projectName;
    public final String contextRoot;
    public final String usrName;
    public final String passwd;
    public final String hostName;
    public final String customProperty;
    public final String planName;
    public final int port;

    @DataBoundConstructor
    public RqmBuilder(String projectName, String contextRoot, String usrName, String passwd, int port, String hostName, String customProperty, String planName) {
        this.projectName = projectName;
        this.contextRoot = contextRoot;
        this.hostName = hostName;
        this.usrName = usrName;
        this.passwd = passwd;
        this.port = port;
        this.customProperty = customProperty;
        this.planName = planName;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        PrintStream console = listener.getLogger();
        console.println(Jenkins.getInstance().getPlugin("rqm-plugin").getWrapper().getVersion());
        console.println(String.format("Project name: %s", this.projectName));
        console.println(String.format("Test plan name: %s", this.planName));
        console.println(String.format("QM Server Port: %s", this.port));
        console.println(String.format("QM Server Host Name: %s", this.hostName));
        console.println(String.format("Context root: %s", this.contextRoot));
        console.println(String.format("Username: %s", this.usrName));
        console.println(String.format("Password: %s", this.passwd));
        console.println(String.format("Custom field: %s", this.customProperty));
        Object res = null;
        boolean success = true;
        try {
            TestPlan plan = new TestPlan(this.planName);
            String planRequestFeed = plan.getFeedUrlForTestPlans(this.hostName, this.port, this.contextRoot, this.projectName);
            NameValuePair[] requestParameters = plan.getParametersForFeedUrlForTestPlans();
            console.println("Getting TestPlans using feed url:");
            console.println(planRequestFeed + "?fields=" + requestParameters[0].getValue());
            RqmParameterList list = new RqmParameterList(this.hostName, this.port, this.contextRoot, this.projectName, this.usrName, this.passwd, planRequestFeed, requestParameters, "GET", null);
            plan = (TestPlan)build.getWorkspace().act(new RqmObjectCreator<TestPlan>(new TestPlan(this.planName), list));
            for (TestCase testcase : plan.getTestCases()) {
                list.requestString = testcase.getRqmObjectResourceUrl();
                build.getWorkspace().act(new RqmObjectCreator<TestCase>(testcase, list));
                for (TestScript script : testcase.getScripts()) {
                    list.requestString = script.getRqmObjectResourceUrl();
                    build.getWorkspace().act(new RqmObjectCreator<TestScript>(script, list));
                }
            }
            for (TestSuite suite : plan.getTestSuites()) {
                list.requestString = suite.getRqmObjectResourceUrl();
                build.getWorkspace().act(new RqmObjectCreator<TestSuite>(suite, list));
                for (TestCase testcase : suite.getTestcases()) {
                    list.requestString = testcase.getRqmObjectResourceUrl();
                    build.getWorkspace().act(new RqmObjectCreator<TestCase>(testcase, list));
                    for (TestScript script : testcase.getScripts()) {
                        list.requestString = script.getRqmObjectResourceUrl();
                        build.getWorkspace().act(new RqmObjectCreator<TestScript>(script, list));
                    }
                }
            }
            RQMBuildAction action = new RQMBuildAction(plan, this.customProperty, build);
            console.println(String.format("Test cases in total: %s", plan.getAllTestCases().size()));
            console.println(String.format("Test cases with scripts in total: %s", plan.getAllTestCasesWithScripts().size()));
            console.println(String.format("Test cases with scripts having the specified custom property value: %s", plan.getTestCaseHavingCustomFieldWithName(this.customProperty).size()));
            HashSet interestingCases = plan.getTestCaseHavingCustomFieldWithName(this.customProperty);
            for (TestCase tc : interestingCases) {
                build.getWorkspace().act((FilePath.FileCallable)new RQMTestCaseScriptExecutor(tc, this.customProperty));
                JUnitParser parser = new JUnitParser(false);
                TestResult tr = parser.parse(String.format("tc_%s/*.xml", tc.getInternalId()), build, launcher, (TaskListener)listener);
                if (tr.getFailCount() > 0) {
                    tc.setOverallResult(TestCase.TestCaseTestResultStatus.FAIL);
                } else {
                    tc.setOverallResult(TestCase.TestCaseTestResultStatus.PASS);
                }
                if (tc.isPass()) continue;
                success = false;
            }
            for (TestCase tc : interestingCases) {
                console.println(tc);
            }
            console.println("Publishing results to RQM");
            for (TestCase tc : interestingCases) {
                String putRequestUrl;
                TestCaseExecutionRecord tcer = new TestCaseExecutionRecord(tc);
                list.requestString = putRequestUrl = RQMUtilities.getSingleResourceBaseUrlWithId((String)this.contextRoot, (String)this.hostName, (int)this.port, (String)this.projectName, (String)"executionworkitem", (String)tc.getExternalAssignedTestCaseExecutonRecordId());
                list.methodType = "PUT";
                build.getWorkspace().act(new RqmObjectCreator<TestCaseExecutionRecord>(tcer, list));
                TestExecutionResult ter = new TestExecutionResult(tcer);
                list.requestString = RQMUtilities.getSingleResourceBaseUrlWithId((String)this.contextRoot, (String)this.hostName, (int)this.port, (String)this.projectName, (String)"executionresult", (String)tc.getExternalAssignedTestCaseResultId());
                build.getWorkspace().act(new RqmObjectCreator<TestExecutionResult>(ter, list));
            }
            console.println("Done publishing results");
            build.getActions().add(action);
        }
        catch (Exception ex) {
            if (ex instanceof RequestException) {
                console.println(String.format("Return code: %s", ((RequestException)ex).result.t1));
            }
            console.println("Failed to retrieve relevant test data, error when discarding wrapper exception was:");
            ex.printStackTrace(console);
            success = false;
        }
        return true;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new RQMProjectAction(project);
    }

    @Extension
    public static class Descriptor
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> arg0) {
            return true;
        }

        public String getDisplayName() {
            return "RQM Build Publisher";
        }

        public Builder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            RqmBuilder builder = (RqmBuilder)((Object)req.bindJSON(RqmBuilder.class, formData));
            this.save();
            return builder;
        }
    }
}

