/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.rqm;

import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.praqma.jenkins.rqm.model.TestCase;
import net.praqma.jenkins.rqm.model.TestScript;

public class RQMTestCaseScriptExecutor
implements FilePath.FileCallable<TestCase> {
    private static final Logger log = Logger.getLogger(RQMTestCaseScriptExecutor.class.getName());
    public final TestCase tc;
    public final String customField;

    public RQMTestCaseScriptExecutor(TestCase tc, String customField) {
        this.tc = tc;
        this.customField = customField;
    }

    public TestCase invoke(File file, VirtualChannel vc) throws IOException, InterruptedException {
        for (TestScript script : this.tc.getScripts()) {
            try {
                File testCaseWorkspaceFolder = new File(file, String.format("tc_%s", this.tc.getInternalId()));
                testCaseWorkspaceFolder.mkdir();
                script.runScriptContainedInCustomField(this.customField, testCaseWorkspaceFolder);
            }
            catch (Exception ex) {
                log.logp(Level.SEVERE, this.getClass().getName(), "invoke", "Error in script exectuion", ex);
                throw new IOException("Caught exception in class RQMTestCaseScriptExectuor");
            }
        }
        TestCase.TestCaseTestResultStatus result = this.tc.getAggregatedTestCaseResult();
        log.fine(String.format("Setting test case result to %s", result));
        this.tc.setOverallResult(result);
        return this.tc;
    }

    private int generateDummyResults(File f) throws IOException {
        int randNumber = new Random().nextInt(2);
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        builder.append("<testsuite>");
        builder.append("<testcase classname=\"foo\" name=\"ASuccessfulTest\"/>");
        builder.append("<testcase classname=\"foo\" name=\"AnotherSuccessfulTest\"/>");
        if (randNumber == 0) {
            builder.append("<testcase classname=\"foo\" name=\"AnotFailingTest\"/>");
        } else {
            builder.append("<testcase classname=\"foo\" name=\"AFailingTest\">");
            builder.append("<failure type=\"NotEnoughFoo\"> details about failure </failure>");
            builder.append("</testcase>");
        }
        builder.append("</testsuite>");
        FileWriter fw = new FileWriter(f, false);
        fw.write(builder.toString());
        fw.close();
        return randNumber;
    }
}

