/*
 * Decompiled with CFR 0.152.
 */
package net.praqma.jenkins.rqm;

import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.praqma.jenkins.rqm.model.exception.ClientCreationException;
import net.praqma.jenkins.rqm.model.exception.LoginException;
import net.praqma.jenkins.rqm.model.exception.RequestException;
import net.praqma.jenkins.rqm.request.RQMGetRequest;
import net.praqma.jenkins.rqm.request.RQMHttpClient;
import net.praqma.jenkins.rqm.request.RQMPutRequest;
import net.praqma.jenkins.rqm.request.RQMUtilities;
import net.praqma.util.structure.Tuple;
import org.apache.commons.httpclient.NameValuePair;

public class RQMMethodInvoker
implements FilePath.FileCallable<Tuple<Integer, String>> {
    private static final Logger log = Logger.getLogger(RQMMethodInvoker.class.getName());
    private transient RQMHttpClient client = null;
    public final NameValuePair[] parameterList;
    public final String hostName;
    public final String contextRoot;
    public final String requestString;
    public final String projectName;
    public final String userName;
    public final String passwd;
    public final int port;
    public final String methodType;
    public final String requestContent;

    public RQMMethodInvoker(String hostName, int port, String contextRoot, String projectName, String userName, String passwd, String requestString, NameValuePair[] parameterList) throws ClientCreationException {
        this.hostName = hostName;
        this.port = port;
        this.projectName = projectName;
        this.userName = userName;
        this.passwd = passwd;
        this.contextRoot = contextRoot;
        this.requestString = requestString;
        this.parameterList = parameterList;
        this.methodType = "GET";
        this.requestContent = null;
    }

    public RQMMethodInvoker(String hostName, int port, String contextRoot, String projectName, String userName, String passwd, String requestString, NameValuePair[] parameterList, String methodType, String requestContent) throws ClientCreationException {
        this.hostName = hostName;
        this.port = port;
        this.projectName = projectName;
        this.userName = userName;
        this.passwd = passwd;
        this.contextRoot = contextRoot;
        this.requestString = requestString;
        this.parameterList = parameterList;
        this.methodType = methodType;
        this.requestContent = requestContent;
    }

    public Tuple<Integer, String> invoke(File file, VirtualChannel vc) throws IOException, InterruptedException {
        Tuple result = null;
        try {
            this.client = RQMUtilities.createClient((String)this.hostName, (int)this.port, (String)this.contextRoot, (String)this.projectName, (String)this.userName, (String)this.passwd);
        }
        catch (MalformedURLException ex) {
            log.logp(Level.SEVERE, this.getClass().getName(), "invoke", "Caught MalformedURLException in invoke throwing IO Exception", ex);
            throw new IOException("RqmMethodInvoker exception", ex);
        }
        catch (ClientCreationException cre) {
            log.logp(Level.SEVERE, this.getClass().getName(), "invoke", "Caught ClientCreationException in invoke throwing IO Exception", cre);
            throw new IOException("RqmMethodInvoker exception(ClientCreationException)", cre);
        }
        try {
            result = this.methodType.equals("GET") ? new RQMGetRequest(this.client, this.requestString, this.parameterList).executeRequest() : (this.methodType.equals("POST") ? null : new RQMPutRequest(this.client, this.userName, this.parameterList, this.requestContent).executeRequest());
        }
        catch (LoginException loginex) {
            log.logp(Level.SEVERE, this.getClass().getName(), "invoke", "Caught login exception in invoke");
            throw new IOException("RqmMethodInvoker exception(LoginException)", loginex);
        }
        catch (RequestException reqExeception) {
            log.logp(Level.SEVERE, this.getClass().getName(), "invoke", "Caught RequestException in invoke");
            throw new IOException("RqmMethodInvoker exception(RequestException)", reqExeception);
        }
        catch (Exception ex) {
            log.logp(Level.SEVERE, this.getClass().getName(), "invoke", "Caught Exception in invoke");
            throw new IOException("RqmMethodInvoker exception(Exception)", ex);
        }
        return result;
    }
}

