package net.peanuuutz.fork.util.common

import kotlin.reflect.KProperty

// -------- Factory Functions --------

public fun ref(value: Boolean): BooleanRef {
    return BooleanRef(value)
}

public fun ref(value: Byte): ByteRef {
    return ByteRef(value)
}

public fun ref(value: Short): ShortRef {
    return ShortRef(value)
}

public fun ref(value: Int): IntRef {
    return IntRef(value)
}

public fun ref(value: Long): LongRef {
    return LongRef(value)
}

public fun ref(value: Float): FloatRef {
    return FloatRef(value)
}

public fun ref(value: Double): DoubleRef {
    return DoubleRef(value)
}

public fun ref(value: Char): CharRef {
    return CharRef(value)
}

public fun <T> ref(value: T): Ref<T> {
    return Ref(value)
}

public fun <T : Any> nullableRef(value: T? = null): NullableRef<T> {
    return NullableRef(value)
}

public fun <T : Any> lazyRef(): LazyRef<T> {
    return LazyRef()
}

// -------- BooleanRef --------

public class BooleanRef(
    public var value: Boolean = false
) {
    override fun equals(other: Any?): Boolean {
        return value == other
    }

    override fun hashCode(): Int {
        return value.hashCode()
    }

    override fun toString(): String {
        return value.toString()
    }
}

@Suppress("NOTHING_TO_INLINE")
public inline operator fun BooleanRef.getValue(
    thisRef: Any?,
    property: KProperty<*>
): Boolean {
    return value
}

@Suppress("NOTHING_TO_INLINE")
public inline operator fun BooleanRef.setValue(
    thisRef: Any?,
    property: KProperty<*>,
    value: Boolean
) {
    this.value = value
}

// -------- ByteRef --------

public class ByteRef(
    public var value: Byte = 0
) {
    override fun equals(other: Any?): Boolean {
        return value == other
    }

    override fun hashCode(): Int {
        return value.hashCode()
    }

    override fun toString(): String {
        return value.toString()
    }
}

@Suppress("NOTHING_TO_INLINE")
public inline operator fun ByteRef.getValue(
    thisRef: Any?,
    property: KProperty<*>
): Byte {
    return value
}

@Suppress("NOTHING_TO_INLINE")
public inline operator fun ByteRef.setValue(
    thisRef: Any?,
    property: KProperty<*>,
    value: Byte
) {
    this.value = value
}

// -------- ShortRef --------

public class ShortRef(
    public var value: Short = 0
) {
    override fun equals(other: Any?): Boolean {
        return value == other
    }

    override fun hashCode(): Int {
        return value.hashCode()
    }

    override fun toString(): String {
        return value.toString()
    }
}

@Suppress("NOTHING_TO_INLINE")
public inline operator fun ShortRef.getValue(
    thisRef: Any?,
    property: KProperty<*>
): Short {
    return value
}

@Suppress("NOTHING_TO_INLINE")
public inline operator fun ShortRef.setValue(
    thisRef: Any?,
    property: KProperty<*>,
    value: Short
) {
    this.value = value
}

// -------- IntRef --------

public class IntRef(
    public var value: Int = 0
) {
    override fun equals(other: Any?): Boolean {
        return value == other
    }

    override fun hashCode(): Int {
        return value.hashCode()
    }

    override fun toString(): String {
        return value.toString()
    }
}

@Suppress("NOTHING_TO_INLINE")
public inline operator fun IntRef.getValue(
    thisRef: Any?,
    property: KProperty<*>
): Int {
    return value
}

@Suppress("NOTHING_TO_INLINE")
public inline operator fun IntRef.setValue(
    thisRef: Any?,
    property: KProperty<*>,
    value: Int
) {
    this.value = value
}

// -------- LongRef --------

public class LongRef(
    public var value: Long = 0L
) {
    override fun equals(other: Any?): Boolean {
        return value == other
    }

    override fun hashCode(): Int {
        return value.hashCode()
    }

    override fun toString(): String {
        return value.toString()
    }
}

@Suppress("NOTHING_TO_INLINE")
public inline operator fun LongRef.getValue(
    thisRef: Any?,
    property: KProperty<*>
): Long {
    return value
}

@Suppress("NOTHING_TO_INLINE")
public inline operator fun LongRef.setValue(
    thisRef: Any?,
    property: KProperty<*>,
    value: Long
) {
    this.value = value
}

// -------- FloatRef --------

public class FloatRef(
    public var value: Float = 0.0f
) {
    override fun equals(other: Any?): Boolean {
        return value == other
    }

    override fun hashCode(): Int {
        return value.hashCode()
    }

    override fun toString(): String {
        return value.toString()
    }
}

@Suppress("NOTHING_TO_INLINE")
public inline operator fun FloatRef.getValue(
    thisRef: Any?,
    property: KProperty<*>
): Float {
    return value
}

@Suppress("NOTHING_TO_INLINE")
public inline operator fun FloatRef.setValue(
    thisRef: Any?,
    property: KProperty<*>,
    value: Float
) {
    this.value = value
}

// -------- DoubleRef --------

public class DoubleRef(
    public var value: Double = 0.0
) {
    override fun equals(other: Any?): Boolean {
        return value == other
    }

    override fun hashCode(): Int {
        return value.hashCode()
    }

    override fun toString(): String {
        return value.toString()
    }
}

@Suppress("NOTHING_TO_INLINE")
public inline operator fun DoubleRef.getValue(
    thisRef: Any?,
    property: KProperty<*>
): Double {
    return value
}

@Suppress("NOTHING_TO_INLINE")
public inline operator fun DoubleRef.setValue(
    thisRef: Any?,
    property: KProperty<*>,
    value: Double
) {
    this.value = value
}

// -------- CharRef --------

public class CharRef(
    public var value: Char = 0.toChar()
) {
    override fun equals(other: Any?): Boolean {
        return value == other
    }

    override fun hashCode(): Int {
        return value.hashCode()
    }

    override fun toString(): String {
        return value.toString()
    }
}

@Suppress("NOTHING_TO_INLINE")
public inline operator fun CharRef.getValue(
    thisRef: Any?,
    property: KProperty<*>
): Char {
    return value
}

@Suppress("NOTHING_TO_INLINE")
public inline operator fun CharRef.setValue(
    thisRef: Any?,
    property: KProperty<*>,
    value: Char
) {
    this.value = value
}

// -------- Ref --------

public class Ref<T>(
    public var value: T
) {
    override fun equals(other: Any?): Boolean {
        return value == other
    }

    override fun hashCode(): Int {
        return value.hashCode()
    }

    override fun toString(): String {
        return value.toString()
    }
}

@Suppress("NOTHING_TO_INLINE")
public inline operator fun <T> Ref<T>.getValue(
    thisRef: Any?,
    property: KProperty<*>
): T {
    return value
}

@Suppress("NOTHING_TO_INLINE")
public inline operator fun <T> Ref<T>.setValue(
    thisRef: Any?,
    property: KProperty<*>,
    value: T
) {
    this.value = value
}

// -------- NullableRef --------

public class NullableRef<T : Any>(
    public var value: T? = null
) {
    override fun equals(other: Any?): Boolean {
        return value == other
    }

    override fun hashCode(): Int {
        return value.hashCode()
    }

    override fun toString(): String {
        return value.toString()
    }
}

@Suppress("NOTHING_TO_INLINE")
public inline operator fun <T : Any> NullableRef<T>.getValue(
    thisRef: Any?,
    property: KProperty<*>
): T? {
    return value
}

@Suppress("NOTHING_TO_INLINE")
public inline operator fun <T : Any> NullableRef<T>.setValue(
    thisRef: Any?,
    property: KProperty<*>,
    value: T?
) {
    this.value = value
}

// -------- LazyRef --------

public class LazyRef<T : Any> {
    public lateinit var value: T

    override fun equals(other: Any?): Boolean {
        return value == other
    }

    override fun hashCode(): Int {
        return value.hashCode()
    }

    override fun toString(): String {
        return value.toString()
    }
}

@Suppress("NOTHING_TO_INLINE")
public inline operator fun <T : Any> LazyRef<T>.getValue(
    thisRef: Any?,
    property: KProperty<*>
): T {
    return value
}

@Suppress("NOTHING_TO_INLINE")
public inline operator fun <T : Any> LazyRef<T>.setValue(
    thisRef: Any?,
    property: KProperty<*>,
    value: T
) {
    this.value = value
}
