/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.hashing;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.openhft.hashing.Access;
import net.openhft.hashing.ByteBufferAccess;
import net.openhft.hashing.CharSequenceAccess;
import net.openhft.hashing.UnsafeAccess;

public final class Accesses {
    public static <T> Access<T> unsafe() {
        return UnsafeAccess.INSTANCE;
    }

    public static Access<ByteBuffer> toByteBuffer() {
        return ByteBufferAccess.INSTANCE;
    }

    public static <T extends CharSequence> Access<T> toNativeCharSequence() {
        return CharSequenceAccess.nativeCharSequenceAccess();
    }

    public static <T extends CharSequence> Access<T> toCharSequence(ByteOrder backingOrder) {
        return CharSequenceAccess.charSequenceAccess(backingOrder);
    }

    private Accesses() {
    }
}

