/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.lang.reflect.Field;
import net.openhft.lang.io.NativeBytes;
import org.jetbrains.annotations.NotNull;

public enum StringBuilderUtils {

    private static final Field SB_VALUE;
    private static final Field SB_COUNT;
    private static final long SB_COUNT_OFFSET;

    public static boolean endsWith(@NotNull CharSequence source, @NotNull String endsWith) {
        for (int i = 1; i <= endsWith.length(); ++i) {
            if (Character.toLowerCase(source.charAt(source.length() - i)) == Character.toLowerCase(endsWith.charAt(endsWith.length() - i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqual(CharSequence s, CharSequence cs) {
        if (s == null) {
            return false;
        }
        if (s.length() != cs.length()) {
            return false;
        }
        for (int i = 0; i < cs.length(); ++i) {
            if (s.charAt(i) == cs.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static String toString(Object o) {
        return o == null ? null : o.toString();
    }

    public static char[] extractChars(StringBuilder sb) {
        try {
            return (char[])SB_VALUE.get(sb);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void setCount(StringBuilder sb, int count) {
        NativeBytes.UNSAFE.putInt(sb, SB_COUNT_OFFSET, count);
    }

    static {
        try {
            SB_VALUE = Class.forName("java.lang.AbstractStringBuilder").getDeclaredField("value");
            SB_VALUE.setAccessible(true);
            SB_COUNT = Class.forName("java.lang.AbstractStringBuilder").getDeclaredField("count");
            SB_COUNT.setAccessible(true);
            SB_COUNT_OFFSET = NativeBytes.UNSAFE.objectFieldOffset(SB_COUNT);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

