/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.nio.channels.FileChannel;

public enum VanillaMappedMode {
    RO("r", 0, FileChannel.MapMode.READ_ONLY),
    RW("rw", 1, FileChannel.MapMode.READ_WRITE);

    private static final VanillaMappedMode[] VALUES;
    private String stringValue;
    private int intValue;
    private FileChannel.MapMode mapValue;

    private VanillaMappedMode(String stringValue, int intValue, FileChannel.MapMode mapValue) {
        this.stringValue = stringValue;
        this.intValue = intValue;
        this.mapValue = mapValue;
    }

    public int intValue() {
        return this.intValue;
    }

    public String stringValue() {
        return this.stringValue;
    }

    public FileChannel.MapMode mapValue() {
        return this.mapValue;
    }

    public static VanillaMappedMode defaultMode() {
        return RO;
    }

    public static VanillaMappedMode fromValue(int value) {
        for (VanillaMappedMode mode : VALUES) {
            if (mode.intValue() != value) continue;
            return mode;
        }
        return VanillaMappedMode.defaultMode();
    }

    public static VanillaMappedMode fromValue(String value) {
        for (VanillaMappedMode mode : VALUES) {
            if (!mode.stringValue().equalsIgnoreCase(value)) continue;
            return mode;
        }
        return VanillaMappedMode.defaultMode();
    }

    public static VanillaMappedMode fromValue(FileChannel.MapMode value) {
        for (VanillaMappedMode mode : VALUES) {
            if (mode.mapValue() != value) continue;
            return mode;
        }
        return VanillaMappedMode.defaultMode();
    }

    static {
        VALUES = VanillaMappedMode.values();
    }
}

