/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.lang.io.AbstractBytes;
import net.openhft.lang.io.ByteBufferReuse;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.RandomDataInput;
import net.openhft.lang.io.StringBuilderUtils;
import net.openhft.lang.io.serialization.BytesMarshallerFactory;
import net.openhft.lang.io.serialization.ObjectSerializer;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

public class NativeBytes
extends AbstractBytes {
    @NotNull
    public static final Unsafe UNSAFE;
    protected static final long NO_PAGE;
    static final int BYTES_OFFSET;
    static final int CHARS_OFFSET;
    protected long startAddr;
    protected long positionAddr;
    protected long limitAddr;
    protected long capacityAddr;

    public static NativeBytes empty() {
        return new NativeBytes(NO_PAGE, NO_PAGE);
    }

    public NativeBytes(long startAddr, long capacityAddr) {
        this.setStartPositionAddress(startAddr, capacityAddr);
    }

    public void setStartPositionAddress(long startAddr, long capacityAddr) {
        this.setStartPositionAddress(startAddr);
        if (startAddr > capacityAddr) {
            throw new IllegalArgumentException("Missorted capacity address");
        }
        this.limitAddr = this.capacityAddr = capacityAddr;
        this.positionChecks(this.positionAddr);
    }

    @Deprecated
    public NativeBytes(BytesMarshallerFactory bytesMarshallerFactory, long startAddr, long capacityAddr, AtomicInteger refCount) {
        super(bytesMarshallerFactory, refCount);
        this.setStartPositionAddress(startAddr);
        this.limitAddr = this.capacityAddr = capacityAddr;
        this.positionChecks(this.positionAddr);
    }

    public NativeBytes(ObjectSerializer objectSerializer, long startAddr, long capacityAddr, AtomicInteger refCount) {
        super(objectSerializer, refCount);
        this.setStartPositionAddress(startAddr);
        this.limitAddr = this.capacityAddr = capacityAddr;
        this.positionChecks(this.positionAddr);
    }

    public NativeBytes(NativeBytes bytes) {
        super(bytes.objectSerializer(), new AtomicInteger(1));
        this.setStartPositionAddress(bytes.startAddr);
        this.positionAddr = bytes.positionAddr;
        this.limitAddr = bytes.limitAddr;
        this.capacityAddr = bytes.capacityAddr;
        this.positionChecks(this.positionAddr);
    }

    public static NativeBytes wrap(long address, long capacity) {
        return new NativeBytes(address, address + capacity);
    }

    public static long longHash(byte[] bytes, int off, int len) {
        int pos;
        long hash = 0L;
        for (pos = 0; pos < len - 7; pos += 8) {
            hash = hash * 10191L + UNSAFE.getLong(bytes, (long)BYTES_OFFSET + (long)off + (long)pos);
        }
        while (pos < len) {
            hash = hash * 57L + (long)bytes[off + pos];
            ++pos;
        }
        return hash;
    }

    static long nextSetBit0(int firstByte, int maximum, long startAddr) {
        for (int i = firstByte; i < maximum; i += 8) {
            long l = UNSAFE.getLong(startAddr + (long)i);
            if (l == 0L) continue;
            return (i << 3) + Long.numberOfTrailingZeros(l);
        }
        return -1L;
    }

    static long nextSetBit0(long firstByte, long maximum, long startAddr) {
        for (long i = firstByte; i < maximum; i += 8L) {
            long l = UNSAFE.getLong(startAddr + i);
            if (l == 0L) continue;
            return (i << 3) + (long)Long.numberOfTrailingZeros(l);
        }
        return -1L;
    }

    public void setStartPositionAddress(long startAddr) {
        if ((startAddr & 0xFFFFFFFFFFFFC000L) == 0L) {
            throw new AssertionError((Object)("Invalid address " + Long.toHexString(startAddr)));
        }
        this.positionAddr = this.startAddr = startAddr;
    }

    @Override
    public void readUTF0(@NotNull Appendable appendable, int utflen) throws IOException {
        if ((long)utflen > this.remaining()) {
            throw new BufferUnderflowException();
        }
        if (appendable instanceof StringBuilder) {
            this.readUTF1((StringBuilder)appendable, utflen);
        } else {
            this.readUTF1(appendable, utflen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readUTF1(@NotNull StringBuilder sb, int utflen) throws IOException {
        int count;
        block6: {
            count = 0;
            sb.ensureCapacity(utflen);
            char[] chars = StringBuilderUtils.extractChars(sb);
            try {
                while (count < utflen) {
                    int c;
                    if ((c = UNSAFE.getByte(this.positionAddr++) & 0xFF) < 128) {
                        chars[count++] = (char)c;
                        continue;
                    }
                    break block6;
                }
                return;
            }
            finally {
                StringBuilderUtils.setCount(sb, count);
            }
        }
        --this.positionAddr;
        NativeBytes.readUTF2(this, sb, utflen, count);
    }

    private void readUTF1(@NotNull Appendable appendable, int utflen) throws IOException {
        for (int count = 0; count < utflen; ++count) {
            int c;
            if ((c = UNSAFE.getByte(this.positionAddr++) & 0xFF) >= 128) {
                --this.positionAddr;
                NativeBytes.readUTF2(this, appendable, utflen, count);
                break;
            }
            appendable.append((char)c);
        }
    }

    @Override
    public NativeBytes slice() {
        return new NativeBytes(this.objectSerializer(), this.positionAddr, this.limitAddr, this.refCount);
    }

    @Override
    public NativeBytes slice(long offset, long length) {
        long sliceStart = this.positionAddr + offset;
        assert (sliceStart >= this.startAddr && sliceStart < this.capacityAddr);
        long sliceEnd = sliceStart + length;
        assert (sliceEnd > sliceStart && sliceEnd <= this.capacityAddr);
        return new NativeBytes(this.objectSerializer(), sliceStart, sliceEnd, this.refCount);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        long subStart = this.positionAddr + (long)start;
        if (subStart < this.positionAddr || subStart > this.limitAddr) {
            throw new IndexOutOfBoundsException();
        }
        long subEnd = this.positionAddr + (long)end;
        if (subEnd < subStart || subEnd > this.limitAddr) {
            throw new IndexOutOfBoundsException();
        }
        if (start == end) {
            return "";
        }
        return new NativeBytes(this.objectSerializer(), subStart, subEnd, this.refCount);
    }

    @Override
    public NativeBytes bytes() {
        return new NativeBytes(this.objectSerializer(), this.startAddr, this.capacityAddr, this.refCount);
    }

    @Override
    public NativeBytes bytes(long offset, long length) {
        long sliceStart = this.startAddr + offset;
        assert (sliceStart >= this.startAddr && sliceStart < this.capacityAddr);
        long sliceEnd = sliceStart + length;
        assert (sliceEnd > sliceStart && sliceEnd <= this.capacityAddr);
        return new NativeBytes(this.objectSerializer(), sliceStart, sliceEnd, this.refCount);
    }

    @Override
    public long address() {
        return this.startAddr;
    }

    @Override
    public Bytes zeroOut() {
        this.clear();
        UNSAFE.setMemory(this.startAddr, this.capacity(), (byte)0);
        return this;
    }

    @Override
    public Bytes zeroOut(long start, long end) {
        if (start < 0L || end > this.limit()) {
            throw new IllegalArgumentException("start: " + start + ", end: " + end);
        }
        if (start >= end) {
            return this;
        }
        UNSAFE.setMemory(this.startAddr + start, end - start, (byte)0);
        return this;
    }

    @Override
    public Bytes zeroOut(long start, long end, boolean ifNotZero) {
        return ifNotZero ? this.zeroOutDirty(start, end) : this.zeroOut(start, end);
    }

    private Bytes zeroOutDirty(long start, long end) {
        if (start < 0L || end > this.limit()) {
            throw new IllegalArgumentException("start: " + start + ", end: " + end);
        }
        if (start >= end) {
            return this;
        }
        while (start < end && (start & 7L) != 0L) {
            byte b = UNSAFE.getByte(this.startAddr + start);
            if (b != 0) {
                UNSAFE.putByte(this.startAddr + start, (byte)0);
            }
            ++start;
        }
        while (start < end - 7L) {
            long l = UNSAFE.getLong(this.startAddr + start);
            if (l != 0L) {
                UNSAFE.putLong(this.startAddr + start, 0L);
            }
            start += 8L;
        }
        while (start < end) {
            byte b = UNSAFE.getByte(this.startAddr + start);
            if (b != 0) {
                UNSAFE.putByte(this.startAddr + start, (byte)0);
            }
            ++start;
        }
        return this;
    }

    @Override
    public int read(@NotNull byte[] bytes, int off, int len) {
        if (len < 0 || off < 0 || off + len > bytes.length) {
            throw new IllegalArgumentException();
        }
        long left = this.remaining();
        if (left <= 0L) {
            return -1;
        }
        int len2 = (int)Math.min((long)len, left);
        UNSAFE.copyMemory(null, this.positionAddr, bytes, BYTES_OFFSET + off, len2);
        this.addPosition(len2);
        return len2;
    }

    @Override
    public byte readByte() {
        byte aByte = UNSAFE.getByte(this.positionAddr);
        this.addPosition(1L);
        return aByte;
    }

    @Override
    public byte readByte(long offset) {
        return UNSAFE.getByte(this.startAddr + offset);
    }

    @Override
    public void readFully(@NotNull byte[] b, int off, int len) {
        NativeBytes.checkArrayOffs(b.length, off, len);
        long left = this.remaining();
        if (left < (long)len) {
            throw new IllegalStateException(new EOFException());
        }
        UNSAFE.copyMemory(null, this.positionAddr, b, BYTES_OFFSET + off, len);
        this.addPosition(len);
    }

    @Override
    public void readFully(long offset, byte[] bytes, int off, int len) {
        NativeBytes.checkArrayOffs(bytes.length, off, len);
        UNSAFE.copyMemory(null, this.startAddr + offset, bytes, BYTES_OFFSET + off, len);
    }

    @Override
    public void readFully(@NotNull char[] data, int off, int len) {
        NativeBytes.checkArrayOffs(data.length, off, len);
        long bytesOff = (long)off * 2L;
        long bytesLen = (long)len * 2L;
        long left = this.remaining();
        if (left < bytesLen) {
            throw new IllegalStateException(new EOFException());
        }
        UNSAFE.copyMemory(null, this.positionAddr, data, (long)BYTES_OFFSET + bytesOff, bytesLen);
        this.addPosition(bytesLen);
    }

    @Override
    public short readShort() {
        short s = UNSAFE.getShort(this.positionAddr);
        this.addPosition(2L);
        return s;
    }

    @Override
    public short readShort(long offset) {
        return UNSAFE.getShort(this.startAddr + offset);
    }

    @Override
    public char readChar() {
        char ch = UNSAFE.getChar(this.positionAddr);
        this.addPosition(2L);
        return ch;
    }

    @Override
    public char readChar(long offset) {
        return UNSAFE.getChar(this.startAddr + offset);
    }

    @Override
    public int readInt() {
        int i = UNSAFE.getInt(this.positionAddr);
        this.addPosition(4L);
        return i;
    }

    @Override
    public int readInt(long offset) {
        return UNSAFE.getInt(this.startAddr + offset);
    }

    @Override
    public int readVolatileInt() {
        int i = UNSAFE.getIntVolatile(null, this.positionAddr);
        this.addPosition(4L);
        return i;
    }

    @Override
    public int readVolatileInt(long offset) {
        return UNSAFE.getIntVolatile(null, this.startAddr + offset);
    }

    @Override
    public long readLong() {
        long l = UNSAFE.getLong(this.positionAddr);
        this.addPosition(8L);
        return l;
    }

    @Override
    public long readLong(long offset) {
        return UNSAFE.getLong(this.startAddr + offset);
    }

    @Override
    public long readVolatileLong() {
        long l = UNSAFE.getLongVolatile(null, this.positionAddr);
        this.addPosition(8L);
        return l;
    }

    @Override
    public long readVolatileLong(long offset) {
        return UNSAFE.getLongVolatile(null, this.startAddr + offset);
    }

    @Override
    public float readFloat() {
        float f = UNSAFE.getFloat(this.positionAddr);
        this.addPosition(4L);
        return f;
    }

    @Override
    public float readFloat(long offset) {
        return UNSAFE.getFloat(this.startAddr + offset);
    }

    @Override
    public double readDouble() {
        double d = UNSAFE.getDouble(this.positionAddr);
        this.addPosition(8L);
        return d;
    }

    @Override
    public double readDouble(long offset) {
        return UNSAFE.getDouble(this.startAddr + offset);
    }

    @Override
    public void write(int b) {
        UNSAFE.putByte(this.positionAddr, (byte)b);
        this.incrementPositionAddr(1L);
    }

    @Override
    public void writeByte(long offset, int b) {
        this.offsetChecks(offset, 1L);
        UNSAFE.putByte(this.startAddr + offset, (byte)b);
    }

    @Override
    public void write(long offset, @NotNull byte[] bytes) {
        if (offset < 0L || offset + (long)bytes.length > this.capacity()) {
            throw new IllegalArgumentException();
        }
        UNSAFE.copyMemory(bytes, BYTES_OFFSET, null, this.startAddr + offset, bytes.length);
        this.addPosition(bytes.length);
    }

    @Override
    public void write(byte[] bytes, int off, int len) {
        if (off < 0 || off + len > bytes.length || (long)len > this.remaining()) {
            throw new IllegalArgumentException();
        }
        UNSAFE.copyMemory(bytes, BYTES_OFFSET + off, null, this.positionAddr, len);
        this.addPosition(len);
    }

    @Override
    public void write(long offset, byte[] bytes, int off, int len) {
        if (offset < 0L || off + len > bytes.length || offset + (long)len > this.capacity()) {
            throw new IllegalArgumentException();
        }
        UNSAFE.copyMemory(bytes, BYTES_OFFSET + off, null, this.startAddr + offset, len);
    }

    @Override
    public void writeShort(int v) {
        this.positionChecks(this.positionAddr + 2L);
        UNSAFE.putShort(this.positionAddr, (short)v);
        this.positionAddr += 2L;
    }

    private long incrementPositionAddr(long value) {
        this.positionAddr(this.positionAddr() + value);
        return this.positionAddr();
    }

    @Override
    public void writeShort(long offset, int v) {
        this.offsetChecks(offset, 2L);
        UNSAFE.putShort(this.startAddr + offset, (short)v);
    }

    @Override
    public void writeChar(int v) {
        this.positionChecks(this.positionAddr + 2L);
        UNSAFE.putChar(this.positionAddr, (char)v);
        this.positionAddr += 2L;
    }

    void addPosition(long delta) {
        this.positionAddr(this.positionAddr() + delta);
    }

    @Override
    public void writeChar(long offset, int v) {
        this.offsetChecks(offset, 2L);
        UNSAFE.putChar(this.startAddr + offset, (char)v);
    }

    @Override
    public void writeInt(int v) {
        this.positionChecks(this.positionAddr + 4L);
        UNSAFE.putInt(this.positionAddr, v);
        this.positionAddr += 4L;
    }

    @Override
    public void writeInt(long offset, int v) {
        this.offsetChecks(offset, 4L);
        UNSAFE.putInt(this.startAddr + offset, v);
    }

    @Override
    public void writeOrderedInt(int v) {
        this.positionChecks(this.positionAddr + 4L);
        UNSAFE.putOrderedInt(null, this.positionAddr, v);
        this.positionAddr += 4L;
    }

    @Override
    public void writeOrderedInt(long offset, int v) {
        this.offsetChecks(offset, 4L);
        UNSAFE.putOrderedInt(null, this.startAddr + offset, v);
    }

    @Override
    public boolean compareAndSwapInt(long offset, int expected, int x) {
        this.offsetChecks(offset, 4L);
        return UNSAFE.compareAndSwapInt(null, this.startAddr + offset, expected, x);
    }

    @Override
    public void writeLong(long v) {
        this.positionChecks(this.positionAddr + 8L);
        UNSAFE.putLong(this.positionAddr, v);
        this.positionAddr += 8L;
    }

    @Override
    public void writeLong(long offset, long v) {
        this.offsetChecks(offset, 8L);
        UNSAFE.putLong(this.startAddr + offset, v);
    }

    @Override
    public void writeOrderedLong(long v) {
        this.positionChecks(this.positionAddr + 8L);
        UNSAFE.putOrderedLong(null, this.positionAddr, v);
        this.positionAddr += 8L;
    }

    @Override
    public void writeOrderedLong(long offset, long v) {
        this.offsetChecks(offset, 8L);
        UNSAFE.putOrderedLong(null, this.startAddr + offset, v);
    }

    @Override
    public boolean compareAndSwapLong(long offset, long expected, long x) {
        this.offsetChecks(offset, 8L);
        return UNSAFE.compareAndSwapLong(null, this.startAddr + offset, expected, x);
    }

    @Override
    public void writeFloat(float v) {
        this.positionChecks(this.positionAddr + 4L);
        UNSAFE.putFloat(this.positionAddr, v);
        this.positionAddr += 4L;
    }

    @Override
    public void writeFloat(long offset, float v) {
        this.offsetChecks(offset, 4L);
        UNSAFE.putFloat(this.startAddr + offset, v);
    }

    @Override
    public void writeDouble(double v) {
        this.positionChecks(this.positionAddr + 8L);
        UNSAFE.putDouble(this.positionAddr, v);
        this.positionAddr += 8L;
    }

    @Override
    public void writeDouble(long offset, double v) {
        this.offsetChecks(offset, 8L);
        UNSAFE.putDouble(this.startAddr + offset, v);
    }

    @Override
    public void readObject(Object object, int start, int end) {
        int len = end - start;
        if (this.positionAddr + (long)len >= this.limitAddr) {
            throw new IndexOutOfBoundsException("Length out of bounds len: " + len);
        }
        while (len >= 8) {
            UNSAFE.putLong(object, start, UNSAFE.getLong(this.positionAddr));
            this.incrementPositionAddr(8L);
            start += 8;
            len -= 8;
        }
        while (len > 0) {
            UNSAFE.putByte(object, start, UNSAFE.getByte(this.positionAddr));
            this.incrementPositionAddr(1L);
            ++start;
            --len;
        }
    }

    @Override
    public void writeObject(Object object, int start, int end) {
        int len;
        for (len = end - start; len >= 8; len -= 8) {
            this.positionChecks(this.positionAddr + 8L);
            UNSAFE.putLong(this.positionAddr, UNSAFE.getLong(object, start));
            this.positionAddr += 8L;
            start += 8;
        }
        while (len > 0) {
            this.positionChecks(this.positionAddr + 1L);
            UNSAFE.putByte(this.positionAddr, UNSAFE.getByte(object, start));
            ++this.positionAddr;
            ++start;
            --len;
        }
    }

    @Override
    public boolean compare(long offset, RandomDataInput input, long inputOffset, long len) {
        long i;
        if (offset < 0L || inputOffset < 0L || len < 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (offset + len < 0L || offset + len > this.capacity() || inputOffset + len < 0L || inputOffset + len > input.capacity()) {
            return false;
        }
        for (i = 0L; i < len - 7L; i += 8L) {
            if (UNSAFE.getLong(this.startAddr + offset + i) == input.readLong(inputOffset + i)) continue;
            return false;
        }
        if (i < len - 3L) {
            if (UNSAFE.getInt(this.startAddr + offset + i) != input.readInt(inputOffset + i)) {
                return false;
            }
            i += 4L;
        }
        if (i < len - 1L) {
            if (UNSAFE.getChar(this.startAddr + offset + i) != input.readChar(inputOffset + i)) {
                return false;
            }
            i += 2L;
        }
        return i >= len || UNSAFE.getByte(this.startAddr + offset + i) == input.readByte(inputOffset + i);
    }

    @Override
    public long position() {
        return this.positionAddr - this.startAddr;
    }

    @Override
    public NativeBytes position(long position) {
        if (position < 0L || position > this.limit()) {
            throw new IndexOutOfBoundsException("position: " + position + " limit: " + this.limit());
        }
        this.positionAddr(this.startAddr + position);
        return this;
    }

    public NativeBytes lazyPosition(long position) {
        if (position < 0L || position > this.limit()) {
            throw new IndexOutOfBoundsException("position: " + position + " limit: " + this.limit());
        }
        this.positionAddr(this.startAddr + position);
        return this;
    }

    @Override
    public void write(RandomDataInput bytes, long position, long length) {
        if (length > this.remaining()) {
            throw new IllegalArgumentException("Attempt to write " + length + " bytes with " + this.remaining() + " remaining");
        }
        if (bytes instanceof NativeBytes) {
            UNSAFE.copyMemory(((NativeBytes)bytes).startAddr + position, this.positionAddr, length);
            this.skip(length);
        } else {
            super.write(bytes, position, length);
        }
    }

    @Override
    public long capacity() {
        return this.capacityAddr - this.startAddr;
    }

    @Override
    public long remaining() {
        return this.limitAddr - this.positionAddr;
    }

    @Override
    public long limit() {
        return this.limitAddr - this.startAddr;
    }

    @Override
    public NativeBytes limit(long limit) {
        if (limit < 0L || limit > this.capacity()) {
            throw new IllegalArgumentException("limit: " + limit + " capacity: " + this.capacity());
        }
        this.limitAddr = this.startAddr + limit;
        return this;
    }

    @Override
    @NotNull
    public ByteOrder byteOrder() {
        return ByteOrder.nativeOrder();
    }

    @Override
    public void checkEndOfBuffer() throws IndexOutOfBoundsException {
        if (this.position() > this.limit()) {
            throw new IndexOutOfBoundsException("position is beyond the end of the buffer " + this.position() + " > " + this.limit());
        }
    }

    public long startAddr() {
        return this.startAddr;
    }

    long capacityAddr() {
        return this.capacityAddr;
    }

    @Override
    protected void cleanup() {
    }

    @Override
    public Bytes load() {
        int pageSize = UNSAFE.pageSize();
        for (long addr = this.startAddr; addr < this.capacityAddr; addr += (long)pageSize) {
            UNSAFE.getByte(addr);
        }
        return this;
    }

    @Override
    public void alignPositionAddr(int powerOf2) {
        long value = this.positionAddr + (long)powerOf2 - 1L & (long)(~(powerOf2 - 1));
        this.positionAddr(value);
    }

    public void positionAddr(long positionAddr) {
        this.positionChecks(positionAddr);
        this.positionAddr = positionAddr;
    }

    void positionChecks(long positionAddr) {
        assert (this.actualPositionChecks(positionAddr));
    }

    boolean actualPositionChecks(long positionAddr) {
        if (positionAddr < this.startAddr) {
            throw new IndexOutOfBoundsException("position before the start by " + (this.startAddr - positionAddr) + " bytes");
        }
        if (positionAddr > this.limitAddr) {
            throw new IndexOutOfBoundsException("position after the limit by " + (positionAddr - this.limitAddr) + " bytes");
        }
        return true;
    }

    void offsetChecks(long offset, long len) {
        assert (this.actualOffsetChecks(offset, len));
    }

    boolean actualOffsetChecks(long offset, long len) {
        if (offset < 0L || offset + len > this.capacity()) {
            throw new IndexOutOfBoundsException("offset out of bounds: " + offset + ", len: " + len + ", capacity: " + this.capacity());
        }
        return true;
    }

    public long positionAddr() {
        return this.positionAddr;
    }

    @Override
    public ByteBuffer sliceAsByteBuffer(ByteBuffer toReuse) {
        return this.sliceAsByteBuffer(toReuse, null);
    }

    protected ByteBuffer sliceAsByteBuffer(ByteBuffer toReuse, Object att) {
        return ByteBufferReuse.INSTANCE.reuse(this.positionAddr, (int)this.remaining(), att, toReuse);
    }

    void address(long address) {
        this.setStartPositionAddress(address);
    }

    void capacity(long capacity) {
        this.limitAddr = this.capacityAddr = capacity;
    }

    @Override
    public long nextSetBit(long fromIndex) {
        if (fromIndex < 0L) {
            throw new IndexOutOfBoundsException();
        }
        long fromLongIndex = fromIndex & 0xFFFFFFFFFFFFFFC0L;
        long capacity = this.capacity();
        long maxBit = capacity << 3;
        if (fromLongIndex >= maxBit) {
            return -1L;
        }
        long firstByte = fromLongIndex >>> 3;
        if ((fromIndex & 0x3FL) != 0L) {
            long l = UNSAFE.getLongVolatile(null, this.startAddr + firstByte) >>> (int)fromIndex;
            if (l != 0L) {
                return fromIndex + (long)Long.numberOfTrailingZeros(l);
            }
            firstByte += 8L;
        }
        if (capacity < Integer.MAX_VALUE) {
            return NativeBytes.nextSetBit0((int)firstByte, (int)capacity, this.startAddr);
        }
        return NativeBytes.nextSetBit0(firstByte, capacity, this.startAddr);
    }

    static {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            UNSAFE = (Unsafe)theUnsafe.get(null);
            BYTES_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
            CHARS_OFFSET = UNSAFE.arrayBaseOffset(char[].class);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        NO_PAGE = UNSAFE.allocateMemory(UNSAFE.pageSize());
    }
}

