/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang;

public class Maths {
    private static final double WHOLE_NUMBER = 9.007199254740992E15;
    private static final long[] TENS = new long[19];

    public static double round2(double d) {
        double factor = 100.0;
        return d > 9.007199254740992E15 || d < -9.007199254740992E15 ? d : (double)((long)(d < 0.0 ? d * 100.0 - 0.5 : d * 100.0 + 0.5)) / 100.0;
    }

    public static double round4(double d) {
        double factor = 10000.0;
        return d > 9.223372036854776E14 || d < -9.223372036854776E14 ? d : (double)((long)(d < 0.0 ? d * 10000.0 - 0.5 : d * 10000.0 + 0.5)) / 10000.0;
    }

    public static double round6(double d) {
        double factor = 1000000.0;
        return d > 9.223372036854775E12 || d < -9.223372036854775E12 ? d : (double)((long)(d < 0.0 ? d * 1000000.0 - 0.5 : d * 1000000.0 + 0.5)) / 1000000.0;
    }

    public static double round8(double d) {
        double factor = 1.0E8;
        return d > 9.223372036854776E10 || d < -9.223372036854776E10 ? d : (double)((long)(d < 0.0 ? d * 1.0E8 - 0.5 : d * 1.0E8 + 0.5)) / 1.0E8;
    }

    public static long power10(int n) {
        if (n < 0 || n >= TENS.length) {
            return -1L;
        }
        return TENS[n];
    }

    public static int nextPower2(int n, int min) {
        if (!Maths.isPowerOf2(min)) {
            throw new IllegalArgumentException();
        }
        if (n < min) {
            return min;
        }
        if (Maths.isPowerOf2(n)) {
            return n;
        }
        int i = min;
        while (i < n) {
            if ((i *= 2) > 0) continue;
            return 0x40000000;
        }
        return i;
    }

    public static long nextPower2(long n, long min) {
        if (!Maths.isPowerOf2(min)) {
            throw new IllegalArgumentException();
        }
        if (n < min) {
            return min;
        }
        if (Maths.isPowerOf2(n)) {
            return n;
        }
        long i = min;
        while (i < n) {
            if ((i *= 2L) > 0L) continue;
            return 0x4000000000000000L;
        }
        return i;
    }

    public static boolean isPowerOf2(int n) {
        return (n & n - 1) == 0;
    }

    public static boolean isPowerOf2(long n) {
        return (n & n - 1L) == 0L;
    }

    public static int hash(int n) {
        n ^= (n >>> 21) - (n >>> 11);
        n ^= (n >>> 7) + (n >>> 4);
        return n;
    }

    public static long hash(long n) {
        n ^= (n >>> 41) - (n >>> 21);
        n ^= (n >>> 15) + (n >>> 7);
        return n;
    }

    public static long hash(CharSequence cs) {
        long hash = 0L;
        for (int i = 0; i < cs.length(); ++i) {
            hash = hash * 131L + (long)cs.charAt(i);
        }
        return hash;
    }

    public static int compare(long x, long y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static int intLog2(long num) {
        long l = Double.doubleToRawLongBits(num);
        return (int)((l >> 52) - 1023L);
    }

    public static int toInt(long l, String error) {
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new IllegalStateException(String.format(error, l));
        }
        return (int)l;
    }

    public static long agitate(long l) {
        l ^= l >> 23;
        l += Long.rotateRight(l, 18);
        return l;
    }

    static {
        Maths.TENS[0] = 1L;
        for (int i = 1; i < TENS.length; ++i) {
            Maths.TENS[i] = TENS[i - 1] * 10L;
        }
    }
}

