/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.Random;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.openhft.lang.InterruptedRuntimeException;
import net.openhft.lang.Maths;
import net.openhft.lang.MemoryUnit;
import net.openhft.lang.io.NativeBytes;

public enum Jvm {

    public static String TMP = System.getProperty("java.io.tmpdir");
    private static final boolean IS64BIT = Jvm.is64Bit0();
    private static final int PROCESS_ID = Jvm.getProcessId0();
    private static final String OS = System.getProperty("os.name").toLowerCase();
    public static final int PID_BITS = Maths.intLog2(Jvm.getPidMax());

    public static boolean is64Bit() {
        return IS64BIT;
    }

    private static boolean is64Bit0() {
        String systemProp = System.getProperty("com.ibm.vm.bitmode");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("sun.arch.data.model");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("java.vm.version");
        return systemProp != null && systemProp.contains("_64");
    }

    public static int getProcessId() {
        return PROCESS_ID;
    }

    private static int getProcessId0() {
        String pid = null;
        File self = new File("/proc/self");
        try {
            if (self.exists()) {
                pid = self.getCanonicalFile().getName();
            }
        }
        catch (IOException ignored) {
            // empty catch block
        }
        if (pid == null) {
            pid = ManagementFactory.getRuntimeMXBean().getName().split("@", 0)[0];
        }
        if (pid == null) {
            int rpid = new Random().nextInt(65536);
            LoggerHolder.LOGGER.log(Level.WARNING, "Unable to determine PID, picked a random number=" + rpid);
            return rpid;
        }
        return Integer.parseInt(pid);
    }

    public static long getUniqueTid() {
        return Jvm.getUniqueTid(Thread.currentThread());
    }

    public static long getUniqueTid(Thread thread) {
        return (long)Jvm.getProcessId() << 24 | thread.getId();
    }

    public static boolean isWindows() {
        return OS.startsWith("win");
    }

    public static boolean isMacOSX() {
        return OS.contains("mac");
    }

    public static boolean isLinux() {
        return OS.startsWith("linux");
    }

    public static boolean isUnix() {
        return OS.contains("nix") || OS.contains("nux") || OS.contains("aix") || OS.contains("bsd") || OS.contains("sun") || OS.contains("hpux");
    }

    public static boolean isSolaris() {
        return OS.startsWith("sun");
    }

    public static long getPidMax() {
        if (Jvm.isLinux()) {
            File file = new File("/proc/sys/kernel/pid_max");
            if (file.canRead()) {
                try {
                    return Maths.nextPower2(new Scanner(file).nextLong(), 1L);
                }
                catch (FileNotFoundException e) {
                    LoggerHolder.LOGGER.log(Level.WARNING, "", e);
                }
            }
        } else if (Jvm.isMacOSX()) {
            return 0x1000000L;
        }
        return 65536L;
    }

    private static String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    public static long freePhysicalMemoryOnWindowsInBytes() throws IOException {
        if (!Jvm.isWindows()) {
            throw new IllegalStateException("Method freePhysicalMemoryOnWindowsInBytes() should be called only on windows. Use Jvm.isWindows() to check the OS.");
        }
        Process pr = Runtime.getRuntime().exec("wmic OS get FreePhysicalMemory /Value");
        try {
            int result = pr.waitFor();
            String output = Jvm.convertStreamToString(pr.getInputStream());
            if (result != 0) {
                String errorOutput = Jvm.convertStreamToString(pr.getErrorStream());
                throw new IOException("Couldn't get free physical memory on windows. Command \"wmic OS get FreePhysicalMemory /Value\" exited with " + result + " code, output: \"" + output + "\", error output: \"" + errorOutput + "\"");
            }
            String[] parts = output.trim().split("=");
            if (parts.length != 2) {
                throw new IOException("Couldn't get free physical memory on windows. Command \"wmic OS get FreePhysicalMemory /Value\" output has unexpected format: \"" + output + "\"");
            }
            try {
                return MemoryUnit.KILOBYTES.toBytes(Long.parseLong(parts[1]));
            }
            catch (NumberFormatException e) {
                throw new IOException("Couldn't get free physical memory on windows. Command \"wmic OS get FreePhysicalMemory /Value\" output has unexpected format: \"" + output + "\"", e);
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public static void checkInterrupted() {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedRuntimeException();
        }
    }

    public static RuntimeException rethrow(Throwable t) {
        NativeBytes.UNSAFE.throwException(t);
        throw new AssertionError();
    }

    public static void trimStackTrace(StringBuilder sb, StackTraceElement ... stes) {
        int first = Jvm.trimFirst(stes);
        int last = Jvm.trimLast(first, stes);
        for (int i = first; i <= last; ++i) {
            sb.append("\n\tat ").append(stes[i]);
        }
    }

    private static int trimFirst(StackTraceElement[] stes) {
        int first;
        for (first = 0; first < stes.length && Jvm.isInternal(stes[first].getClassName()); ++first) {
        }
        if (first > 0) {
            --first;
        }
        if (first > 0) {
            --first;
        }
        return first;
    }

    private static int trimLast(int first, StackTraceElement[] stes) {
        int last;
        for (last = stes.length - 1; first < last && Jvm.isInternal(stes[last].getClassName()); --last) {
        }
        if (last < stes.length - 1) {
            ++last;
        }
        return last;
    }

    public static boolean isInternal(String className) {
        return className.startsWith("jdk.") || className.startsWith("sun.") || className.startsWith("java.");
    }

    static class LoggerHolder {
        public static final Logger LOGGER = Logger.getLogger(Jvm.class.getName());

        LoggerHolder() {
        }
    }
}

