/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.pool;

import net.openhft.lang.Maths;
import net.openhft.lang.model.constraints.NotNull;
import net.openhft.lang.model.constraints.Nullable;
import net.openhft.lang.pool.CharSequenceInterner;

public class EnumInterner<E extends Enum<E>>
implements CharSequenceInterner<Enum<E>> {
    private static final ClassValue<EnumInterner> internerForClass = new ClassValue<EnumInterner>(){

        @Override
        protected EnumInterner computeValue(Class<?> type) {
            return new EnumInterner(type);
        }
    };
    private final Enum<E>[] interner;
    private final int mask;
    private final Class<E> enumType;

    private EnumInterner(Class<E> enumType) {
        this.enumType = enumType;
        int n = 128;
        this.interner = new Enum[n];
        this.mask = n - 1;
    }

    public static <T extends Enum<T>> T intern(Class<T> enumType, CharSequence cs) {
        return (T)internerForClass.get(enumType).intern(cs);
    }

    public static boolean isEqual(@Nullable CharSequence s, @NotNull CharSequence cs) {
        if (s == null) {
            return false;
        }
        if (s.length() != cs.length()) {
            return false;
        }
        for (int i = 0; i < cs.length(); ++i) {
            if (s.charAt(i) == cs.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Enum<E> intern(@NotNull CharSequence cs) {
        long hash = 0L;
        for (int i = 0; i < cs.length(); ++i) {
            hash = 57L * hash + (long)cs.charAt(i);
        }
        int h = (int)Maths.hash(hash) & this.mask;
        Enum<E> e = this.interner[h];
        if (e != null && EnumInterner.isEqual(e.name(), cs)) {
            return e;
        }
        String s2 = cs.toString();
        this.interner[h] = Enum.valueOf(this.enumType, s2);
        return this.interner[h];
    }
}

