/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.nio.ByteOrder;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.BytesHasher;

public enum VanillaBytesHash implements BytesHasher
{
    INSTANCE;

    public static final int K0 = 1829709757;
    public static final int K1 = -1040990263;
    public static final int K2 = 1796809623;
    public static final int K3 = 1804686935;
    public static final int M0 = 1539836845;
    public static final int M1 = -361396777;
    public static final int M2 = 2053402137;
    public static final int M3 = -2057448229;
    private static final int HI_BYTES;

    public static long agitate(long l) {
        l += l >>> 22;
        l ^= Long.rotateRight(l, 17);
        return l;
    }

    @Override
    public long hash(Bytes bytes, long offset, long limit) {
        int i;
        long start = offset;
        int remaining = (int)(limit - offset);
        long h0 = (long)remaining * 1829709757L;
        long h1 = 0L;
        long h2 = 0L;
        long h3 = 0L;
        for (i = 0; i < remaining - 31; i += 32) {
            if (i > 0) {
                h0 *= 1829709757L;
                h1 *= -1040990263L;
                h2 *= 1796809623L;
                h3 *= 1804686935L;
            }
            long addrI = start + (long)i;
            long l0 = bytes.readLong(addrI);
            int l0a = bytes.readInt(addrI + (long)HI_BYTES);
            long l1 = bytes.readLong(addrI + 8L);
            int l1a = bytes.readInt(addrI + 8L + (long)HI_BYTES);
            long l2 = bytes.readLong(addrI + 16L);
            int l2a = bytes.readInt(addrI + 16L + (long)HI_BYTES);
            long l3 = bytes.readLong(addrI + 24L);
            int l3a = bytes.readInt(addrI + 24L + (long)HI_BYTES);
            h0 += (l0 + (long)l1a - (long)l2a) * 1539836845L;
            h1 += (l1 + (long)l2a - (long)l3a) * -361396777L;
            h2 += (l2 + (long)l3a - (long)l0a) * 2053402137L;
            h3 += (l3 + (long)l0a - (long)l1a) * -2057448229L;
        }
        int left = remaining - i;
        if (left > 0) {
            if (i > 0) {
                h0 *= 1829709757L;
                h1 *= -1040990263L;
                h2 *= 1796809623L;
                h3 *= 1804686935L;
            }
            long addrI = start + (long)i;
            long l0 = bytes.readIncompleteLong(addrI);
            int l0a = (int)(l0 >> 32);
            long l1 = bytes.readIncompleteLong(addrI + 8L);
            int l1a = (int)(l1 >> 32);
            long l2 = bytes.readIncompleteLong(addrI + 16L);
            int l2a = (int)(l2 >> 32);
            long l3 = bytes.readIncompleteLong(addrI + 24L);
            int l3a = (int)(l3 >> 32);
            h0 += (l0 + (long)l1a - (long)l2a) * 1539836845L;
            h1 += (l1 + (long)l2a - (long)l3a) * -361396777L;
            h2 += (l2 + (long)l3a - (long)l0a) * 2053402137L;
            h3 += (l3 + (long)l0a - (long)l1a) * -2057448229L;
        }
        return VanillaBytesHash.agitate(h0) ^ VanillaBytesHash.agitate(h1) ^ VanillaBytesHash.agitate(h2) ^ VanillaBytesHash.agitate(h3);
    }

    @Override
    public long hash(Bytes bytes) {
        return this.hash(bytes, bytes.position(), bytes.limit());
    }

    static {
        HI_BYTES = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 4 : 0;
    }
}

