/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.lang.io.BoundsCheckingDirectBytes;
import net.openhft.lang.io.BytesStore;
import net.openhft.lang.io.DirectBytes;
import net.openhft.lang.io.NativeBytes;
import net.openhft.lang.io.serialization.BytesMarshallableSerializer;
import net.openhft.lang.io.serialization.BytesMarshallerFactory;
import net.openhft.lang.io.serialization.JDKZObjectSerializer;
import net.openhft.lang.io.serialization.ObjectSerializer;
import net.openhft.lang.io.serialization.impl.VanillaBytesMarshallerFactory;
import net.openhft.lang.model.constraints.NotNull;
import sun.misc.Cleaner;

public class DirectStore
implements BytesStore,
AutoCloseable {
    private final ObjectSerializer objectSerializer;
    private final Cleaner cleaner;
    private final Deallocator deallocator;
    private long address;
    private long size;
    private final AtomicInteger refCount = new AtomicInteger(1);

    public DirectStore(long size) {
        this(new VanillaBytesMarshallerFactory(), size);
    }

    private DirectStore(BytesMarshallerFactory bytesMarshallerFactory, long size) {
        this(bytesMarshallerFactory, size, true);
    }

    private DirectStore(BytesMarshallerFactory bytesMarshallerFactory, long size, boolean zeroOut) {
        this(BytesMarshallableSerializer.create(bytesMarshallerFactory, JDKZObjectSerializer.INSTANCE), size, zeroOut);
    }

    public DirectStore(ObjectSerializer objectSerializer, long size, boolean zeroOut) {
        this.objectSerializer = objectSerializer;
        this.address = NativeBytes.UNSAFE.allocateMemory(size);
        if (zeroOut) {
            NativeBytes.UNSAFE.setMemory(this.address, size, (byte)0);
            NativeBytes.UNSAFE.putLongVolatile(null, this.address, 0L);
        }
        this.size = size;
        this.deallocator = new Deallocator(this.address);
        this.cleaner = Cleaner.create((Object)this, (Runnable)this.deallocator);
    }

    @Override
    public ObjectSerializer objectSerializer() {
        return this.objectSerializer;
    }

    @NotNull
    public static DirectStore allocate(long size) {
        return new DirectStore(new VanillaBytesMarshallerFactory(), size);
    }

    @NotNull
    public static DirectStore allocateLazy(long size) {
        return new DirectStore(new VanillaBytesMarshallerFactory(), size, false);
    }

    public void resize(long newSize, boolean zeroOut) {
        if (newSize <= 0L) {
            throw new IllegalArgumentException("Given newSize is " + newSize + " but should be positive");
        }
        this.address = this.deallocator.address = NativeBytes.UNSAFE.reallocateMemory(this.address, newSize);
        if (zeroOut && newSize > this.size) {
            NativeBytes.UNSAFE.setMemory(this.address + this.size, newSize - this.size, (byte)0);
        }
        this.size = newSize;
    }

    @Override
    @NotNull
    public DirectBytes bytes() {
        boolean debug = false;
        if (!$assertionsDisabled) {
            debug = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return debug ? new BoundsCheckingDirectBytes(this, this.refCount) : new DirectBytes(this, this.refCount);
    }

    @Override
    @NotNull
    public DirectBytes bytes(long offset, long length) {
        return new DirectBytes(this, this.refCount, offset, length);
    }

    @Override
    public long address() {
        return this.address;
    }

    @Override
    public void free() {
        this.cleaner.clean();
    }

    @Override
    public long size() {
        return this.size;
    }

    public static BytesStore allocateLazy(long sizeInBytes, ObjectSerializer objectSerializer) {
        return new DirectStore(objectSerializer, sizeInBytes, false);
    }

    @Override
    public File file() {
        return null;
    }

    @Override
    public void close() {
        this.free();
    }

    private static class Deallocator
    implements Runnable {
        private volatile long address;

        Deallocator(long address) {
            assert (address != 0L);
            this.address = address;
        }

        @Override
        public void run() {
            if (this.address == 0L) {
                return;
            }
            NativeBytes.UNSAFE.freeMemory(this.address);
            this.address = 0L;
        }
    }
}

