/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import net.openhft.lang.io.FileLifecycleListener;
import net.openhft.lang.io.VanillaMappedBytes;
import net.openhft.lang.io.VanillaMappedMode;
import net.openhft.lang.io.VanillaMappedResource;

public class VanillaMappedFile
implements VanillaMappedResource {
    private final File path;
    private final FileChannel fileChannel;
    private final VanillaMappedMode mode;
    private final long size;
    private final FileLifecycleListener fileLifecycleListener;

    public VanillaMappedFile(File path, VanillaMappedMode mode) throws IOException {
        this(path, mode, -1L, FileLifecycleListener.FileLifecycleListeners.IGNORE);
    }

    public VanillaMappedFile(File path, VanillaMappedMode mode, long size, FileLifecycleListener fileLifecycleListener) throws IOException {
        this.path = path;
        this.mode = mode;
        this.size = size;
        this.fileChannel = VanillaMappedFile.fileChannel(path, mode, this.size, fileLifecycleListener);
        this.fileLifecycleListener = fileLifecycleListener;
    }

    public VanillaMappedBytes bytes(long address, long size) throws IOException {
        return new VanillaMappedBytes(this.path, this.map(address, size), -1L, null, this.fileLifecycleListener);
    }

    public VanillaMappedBytes bytes(long address, long size, long index) throws IOException {
        return new VanillaMappedBytes(this.path, this.map(address, size), index, null, this.fileLifecycleListener);
    }

    @Override
    public String path() {
        return this.path.getAbsolutePath();
    }

    @Override
    public long size() {
        try {
            return this.fileChannel.size();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.fileChannel.isOpen()) {
            long start = System.nanoTime();
            this.fileChannel.close();
            this.fileLifecycleListener.onEvent(FileLifecycleListener.EventType.CLOSE, this.path, System.nanoTime() - start);
        }
    }

    private synchronized MappedByteBuffer map(long address, long size) throws IOException {
        long start = System.nanoTime();
        MappedByteBuffer buffer = this.fileChannel.map(this.mode.mapValue(), address, size);
        buffer.order(ByteOrder.nativeOrder());
        this.fileLifecycleListener.onEvent(FileLifecycleListener.EventType.MMAP, this.path, System.nanoTime() - start);
        return buffer;
    }

    private static FileChannel fileChannel(File path, VanillaMappedMode mapMode, long size, FileLifecycleListener fileLifecycleListener) throws IOException {
        long start = System.nanoTime();
        FileChannel fileChannel = null;
        try {
            RandomAccessFile raf = new RandomAccessFile(path, mapMode.stringValue());
            if (size > 0L && raf.length() != size) {
                if (mapMode.mapValue() != FileChannel.MapMode.READ_WRITE) {
                    throw new IOException("Cannot resize file to " + size + " as mode is not READ_WRITE");
                }
                raf.setLength(size);
            }
            fileChannel = raf.getChannel();
        }
        catch (Exception e) {
            throw VanillaMappedFile.wrap(e);
        }
        fileLifecycleListener.onEvent(FileLifecycleListener.EventType.NEW, path, System.nanoTime() - start);
        return fileChannel;
    }

    private static IOException wrap(Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            throwable = throwable.getCause();
        } else if (throwable instanceof IOException) {
            return (IOException)throwable;
        }
        return new IOException(throwable);
    }

    public static VanillaMappedFile readWrite(File path) throws IOException {
        return new VanillaMappedFile(path, VanillaMappedMode.RW);
    }

    public static VanillaMappedFile readWrite(File path, long size) throws IOException {
        return new VanillaMappedFile(path, VanillaMappedMode.RW, size, FileLifecycleListener.FileLifecycleListeners.IGNORE);
    }

    public static VanillaMappedFile readOnly(File path) throws IOException {
        return new VanillaMappedFile(path, VanillaMappedMode.RO);
    }

    public static VanillaMappedFile readOnly(File path, long size) throws IOException {
        return new VanillaMappedFile(path, VanillaMappedMode.RO, size, FileLifecycleListener.FileLifecycleListeners.IGNORE);
    }

    public static VanillaMappedBytes readWriteBytes(File path, long size) throws IOException {
        return VanillaMappedFile.readWriteBytes(path, size, -1L);
    }

    public static VanillaMappedBytes readWriteBytes(File path, long size, long index) throws IOException {
        return VanillaMappedFile.readWriteBytes(path, size, index, FileLifecycleListener.FileLifecycleListeners.IGNORE);
    }

    public static VanillaMappedBytes readWriteBytes(File path, long size, long index, FileLifecycleListener fileLifecycleListener) throws IOException {
        VanillaMappedFile vmf = new VanillaMappedFile(path, VanillaMappedMode.RW, -1L, fileLifecycleListener);
        return new VanillaMappedBytes(path, vmf.map(0L, size), index, vmf.fileChannel, fileLifecycleListener);
    }
}

