/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.io.File;
import org.slf4j.LoggerFactory;

public interface FileLifecycleListener {
    public void onFileGrowth(File var1, long var2);

    public static enum FileLifecycleListeners implements FileLifecycleListener
    {
        IGNORE{

            @Override
            public void onFileGrowth(File file, long timeInNanos) {
            }
        }
        ,
        CONSOLE{

            @Override
            public void onFileGrowth(File file, long timeInNanos) {
                System.out.println("File growth " + file + " took " + (double)(timeInNanos / 1000L) / 1000.0 + " ms.");
            }
        }
        ,
        LOG{

            @Override
            public void onFileGrowth(File file, long timeInNanos) {
                LoggerFactory.getLogger(FileLifecycleListeners.class).info("File growth " + file + " took " + (double)(timeInNanos / 1000L) / 1000.0 + " ms.");
            }
        };

    }
}

