/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.openhft.lang.io.BytesStore;
import net.openhft.lang.io.DirectBytes;
import net.openhft.lang.io.serialization.ObjectSerializer;
import net.openhft.lang.model.constraints.NotNull;
import sun.misc.Cleaner;
import sun.nio.ch.FileChannelImpl;

abstract class AbstractMappedStore
implements BytesStore,
Closeable {
    private static final int MAP_RO = 0;
    private static final int MAP_RW = 1;
    private static final int MAP_PV = 2;
    private final File file;
    private final RandomAccessFile raf;
    private final Cleaner cleaner;
    private final AtomicInteger refCount = new AtomicInteger(1);
    private final FileChannel.MapMode mode;
    protected final MmapInfoHolder mmapInfoHolder;
    private ObjectSerializer objectSerializer;

    AbstractMappedStore(MmapInfoHolder mmapInfoHolder, File file, FileChannel.MapMode mode, long startInFile, long size, ObjectSerializer objectSerializer) throws IOException {
        AbstractMappedStore.validateSize(size);
        this.file = file;
        this.mmapInfoHolder = mmapInfoHolder;
        this.mmapInfoHolder.setSize(size);
        this.objectSerializer = objectSerializer;
        this.mode = mode;
        try {
            this.raf = new RandomAccessFile(file, AbstractMappedStore.accesModeFor(mode));
            this.resizeIfNeeded(startInFile, size);
            this.map(startInFile);
            this.cleaner = Cleaner.create((Object)this, (Runnable)new Unmapper(mmapInfoHolder, this.raf));
        }
        catch (Exception e) {
            throw AbstractMappedStore.wrap(e);
        }
    }

    protected static void validateSize(long size) {
        if (size <= 0L || size > 0x800000000000L) {
            throw new IllegalArgumentException("invalid size: " + size);
        }
    }

    protected final void resizeIfNeeded(long startInFile, long newSize) throws IOException {
        if (this.file.getAbsolutePath().startsWith("/dev/")) {
            return;
        }
        if (startInFile > 0L) {
            if (this.raf.length() >= startInFile + newSize) {
                return;
            }
        } else if (startInFile == 0L) {
            if (this.raf.length() == newSize) {
                return;
            }
        } else {
            throw new IllegalArgumentException("Start offset in file needs to be positive: " + startInFile);
        }
        if (this.mode != FileChannel.MapMode.READ_WRITE) {
            throw new IOException("Cannot resize file to " + newSize + " as mode is not READ_WRITE");
        }
        this.raf.setLength(startInFile + newSize);
    }

    protected final void map(long startInFile) throws IOException {
        try {
            this.mmapInfoHolder.setAddress(AbstractMappedStore.map0(this.raf.getChannel(), AbstractMappedStore.imodeFor(this.mode), startInFile, this.mmapInfoHolder.getSize()));
        }
        catch (Exception e) {
            throw AbstractMappedStore.wrap(e);
        }
    }

    protected final void unmapAndSyncToDisk() throws IOException {
        AbstractMappedStore.unmap0(this.mmapInfoHolder.getAddress(), this.mmapInfoHolder.getSize());
        this.raf.getChannel().force(true);
    }

    private static long map0(FileChannel fileChannel, int imode, long start, long size) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method map0 = fileChannel.getClass().getDeclaredMethod("map0", Integer.TYPE, Long.TYPE, Long.TYPE);
        map0.setAccessible(true);
        return (Long)map0.invoke((Object)fileChannel, imode, start, size);
    }

    private static void unmap0(long address, long size) throws IOException {
        try {
            Method unmap0 = FileChannelImpl.class.getDeclaredMethod("unmap0", Long.TYPE, Long.TYPE);
            unmap0.setAccessible(true);
            unmap0.invoke(null, address, size);
        }
        catch (Exception e) {
            throw AbstractMappedStore.wrap(e);
        }
    }

    private static IOException wrap(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = e.getCause();
        }
        if (e instanceof IOException) {
            return (IOException)e;
        }
        return new IOException(e);
    }

    private static String accesModeFor(FileChannel.MapMode mode) {
        return mode == FileChannel.MapMode.READ_WRITE ? "rw" : "r";
    }

    private static int imodeFor(FileChannel.MapMode mode) {
        int imode = -1;
        if (mode == FileChannel.MapMode.READ_ONLY) {
            imode = 0;
        } else if (mode == FileChannel.MapMode.READ_WRITE) {
            imode = 1;
        } else if (mode == FileChannel.MapMode.PRIVATE) {
            imode = 2;
        }
        assert (imode >= 0);
        return imode;
    }

    @Override
    public final ObjectSerializer objectSerializer() {
        return this.objectSerializer;
    }

    @Override
    public final long address() {
        return this.mmapInfoHolder.getAddress();
    }

    @Override
    public final long size() {
        return this.mmapInfoHolder.getSize();
    }

    @Override
    public final void free() {
        this.cleaner.clean();
    }

    @Override
    public final void close() {
        this.free();
    }

    @Override
    @NotNull
    public final DirectBytes bytes() {
        return new DirectBytes(this, this.refCount);
    }

    @Override
    @NotNull
    public final DirectBytes bytes(long offset, long length) {
        return new DirectBytes(this, this.refCount, offset, length);
    }

    @Override
    public final File file() {
        return this.file;
    }

    private static final class UnmapperLoggerHolder {
        private static final Logger LOGGER = Logger.getLogger(Unmapper.class.getName());

        private UnmapperLoggerHolder() {
        }
    }

    private static final class Unmapper
    implements Runnable {
        private final MmapInfoHolder mmapInfoHolder;
        private final RandomAccessFile raf;
        private volatile boolean cleanedUp;

        Unmapper(MmapInfoHolder mmapInfo, RandomAccessFile raf) {
            this.mmapInfoHolder = mmapInfo;
            this.raf = raf;
        }

        @Override
        public void run() {
            if (this.cleanedUp) {
                return;
            }
            this.cleanedUp = true;
            try {
                AbstractMappedStore.unmap0(this.mmapInfoHolder.getAddress(), this.mmapInfoHolder.getSize());
                this.raf.getChannel().force(true);
                this.raf.close();
            }
            catch (IOException e) {
                UnmapperLoggerHolder.LOGGER.log(Level.SEVERE, "An exception has occurred while cleaning up a MappedStore instance: " + e.getMessage(), e);
            }
        }
    }

    static final class MmapInfoHolder {
        private long address;
        private long size;
        private volatile boolean locked;

        MmapInfoHolder() {
        }

        private void checkLock() {
            if (this.locked) {
                throw new IllegalStateException();
            }
        }

        void lock() {
            this.locked = true;
        }

        void setAddress(long address) {
            this.checkLock();
            this.address = address;
        }

        long getAddress() {
            return this.address;
        }

        void setSize(long size) {
            this.checkLock();
            this.size = size;
        }

        long getSize() {
            return this.size;
        }
    }
}

