/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.locks;

import net.openhft.lang.locks.AbstractReadWriteLockingStrategy;
import net.openhft.lang.locks.NativeAtomicAccess;
import net.openhft.lang.locks.ReadWriteWithWaitsLockingStrategy;

public final class VanillaReadWriteWithWaitsLockingStrategy
extends AbstractReadWriteLockingStrategy
implements ReadWriteWithWaitsLockingStrategy {
    private static final ReadWriteWithWaitsLockingStrategy INSTANCE = new VanillaReadWriteWithWaitsLockingStrategy();
    static final int RW_LOCK_LIMIT = 30;
    static final long RW_READ_LOCKED = 1L;
    static final long RW_WRITE_WAITING = 0x40000000L;
    static final long RW_WRITE_LOCKED = 0x1000000000000000L;
    static final int RW_LOCK_MASK = 0x3FFFFFFF;

    public static ReadWriteWithWaitsLockingStrategy instance() {
        return INSTANCE;
    }

    private VanillaReadWriteWithWaitsLockingStrategy() {
    }

    static int rwReadLocked(long lock) {
        return (int)(lock & 0x3FFFFFFFL);
    }

    static int rwWriteWaiting(long lock) {
        return (int)(lock >>> 30 & 0x3FFFFFFFL);
    }

    static int rwWriteLocked(long lock) {
        return (int)(lock >>> 60);
    }

    static <T> long read(NativeAtomicAccess<T> access, T t, long offset) {
        return access.getLongVolatile(t, offset);
    }

    static <T> boolean cas(NativeAtomicAccess<T> access, T t, long offset, long expected, long x) {
        return access.compareAndSwapLong(t, offset, expected, x);
    }

    @Override
    public <T> boolean tryReadLock(NativeAtomicAccess<T> access, T t, long offset) {
        long lock = VanillaReadWriteWithWaitsLockingStrategy.read(access, t, offset);
        int writersWaiting = VanillaReadWriteWithWaitsLockingStrategy.rwWriteWaiting(lock);
        int writersLocked = VanillaReadWriteWithWaitsLockingStrategy.rwWriteLocked(lock);
        if (writersLocked <= 0 && writersWaiting <= 0) {
            int readersLocked = VanillaReadWriteWithWaitsLockingStrategy.rwReadLocked(lock);
            if (readersLocked >= 0x3FFFFFFF) {
                throw new IllegalMonitorStateException("readersLocked has reached a limit of " + readersLocked);
            }
            if (VanillaReadWriteWithWaitsLockingStrategy.cas(access, t, offset, lock, lock + 1L)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public <T> boolean tryWriteLock(NativeAtomicAccess<T> access, T t, long offset) {
        long lock = VanillaReadWriteWithWaitsLockingStrategy.read(access, t, offset);
        int readersLocked = VanillaReadWriteWithWaitsLockingStrategy.rwReadLocked(lock);
        int writersLocked = VanillaReadWriteWithWaitsLockingStrategy.rwWriteLocked(lock);
        return readersLocked <= 0 && writersLocked <= 0 && VanillaReadWriteWithWaitsLockingStrategy.cas(access, t, offset, lock, lock + 0x1000000000000000L);
    }

    @Override
    public <T> boolean tryUpgradeReadToWriteLock(NativeAtomicAccess<T> access, T t, long offset) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public <T> void readUnlock(NativeAtomicAccess<T> access, T t, long offset) {
        long lock;
        do {
            int readersLocked;
            if ((readersLocked = VanillaReadWriteWithWaitsLockingStrategy.rwReadLocked(lock = VanillaReadWriteWithWaitsLockingStrategy.read(access, t, offset))) > 0) continue;
            throw new IllegalMonitorStateException("readerLock underflow");
        } while (!VanillaReadWriteWithWaitsLockingStrategy.cas(access, t, offset, lock, lock - 1L));
    }

    @Override
    public <T> void writeUnlock(NativeAtomicAccess<T> access, T t, long offset) {
        long lock;
        do {
            int writersLocked;
            if ((writersLocked = VanillaReadWriteWithWaitsLockingStrategy.rwWriteLocked(lock = VanillaReadWriteWithWaitsLockingStrategy.read(access, t, offset))) == 1) continue;
            throw new IllegalMonitorStateException("writersLock underflow " + writersLocked);
        } while (!VanillaReadWriteWithWaitsLockingStrategy.cas(access, t, offset, lock, lock - 0x1000000000000000L));
    }

    @Override
    public <T> void downgradeWriteToReadLock(NativeAtomicAccess<T> access, T t, long offset) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public boolean isWriteLocked(long state) {
        return VanillaReadWriteWithWaitsLockingStrategy.rwWriteLocked(state) > 0;
    }

    @Override
    public int readLockCount(long state) {
        return VanillaReadWriteWithWaitsLockingStrategy.rwReadLocked(state);
    }

    @Override
    public <T> void reset(NativeAtomicAccess<T> access, T t, long offset) {
        access.putOrderedLong(t, offset, 0L);
    }

    @Override
    public <T> void resetKeepingWaits(NativeAtomicAccess<T> access, T t, long offset) {
        long onlyWaits;
        long lock;
        while (!VanillaReadWriteWithWaitsLockingStrategy.cas(access, t, offset, lock = VanillaReadWriteWithWaitsLockingStrategy.read(access, t, offset), onlyWaits = lock & 0xFFFFFFFC0000000L)) {
        }
    }

    @Override
    public <T> void registerWait(NativeAtomicAccess<T> access, T t, long offset) {
        long lock;
        do {
            int writersWaiting;
            if ((writersWaiting = VanillaReadWriteWithWaitsLockingStrategy.rwWriteWaiting(lock = VanillaReadWriteWithWaitsLockingStrategy.read(access, t, offset))) < 0x3FFFFFFF) continue;
            throw new IllegalMonitorStateException("writersWaiting has reached a limit of " + writersWaiting);
        } while (!VanillaReadWriteWithWaitsLockingStrategy.cas(access, t, offset, lock, lock + 0x40000000L));
    }

    @Override
    public <T> void deregisterWait(NativeAtomicAccess<T> access, T t, long offset) {
        long lock;
        do {
            int writersWaiting;
            if ((writersWaiting = VanillaReadWriteWithWaitsLockingStrategy.rwWriteWaiting(lock = VanillaReadWriteWithWaitsLockingStrategy.read(access, t, offset))) > 0) continue;
            throw new IllegalMonitorStateException("writersWaiting has underflowed");
        } while (!VanillaReadWriteWithWaitsLockingStrategy.cas(access, t, offset, lock, lock - 0x40000000L));
    }

    @Override
    public <T> boolean tryWriteLockAndDeregisterWait(NativeAtomicAccess<T> access, T t, long offset) {
        long lock = VanillaReadWriteWithWaitsLockingStrategy.read(access, t, offset);
        int readersLocked = VanillaReadWriteWithWaitsLockingStrategy.rwReadLocked(lock);
        int writersWaiting = VanillaReadWriteWithWaitsLockingStrategy.rwWriteWaiting(lock);
        int writersLocked = VanillaReadWriteWithWaitsLockingStrategy.rwWriteLocked(lock);
        if (readersLocked <= 0 && writersLocked <= 0) {
            if (writersWaiting <= 0) {
                throw new IllegalMonitorStateException("writersWaiting has underflowed");
            }
            if (VanillaReadWriteWithWaitsLockingStrategy.cas(access, t, offset, lock, lock + 0x1000000000000000L - 0x40000000L)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public <T> boolean tryUpgradeReadToWriteLockAndDeregisterWait(NativeAtomicAccess<T> access, T t, long offset) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public long resetState() {
        return 0L;
    }

    @Override
    public <T> long getState(NativeAtomicAccess<T> access, T t, long offset) {
        return VanillaReadWriteWithWaitsLockingStrategy.read(access, t, offset);
    }

    @Override
    public int waitCount(long state) {
        return VanillaReadWriteWithWaitsLockingStrategy.rwWriteWaiting(state);
    }

    @Override
    public boolean isLocked(long state) {
        return this.isReadLocked(state) || this.isWriteLocked(state);
    }

    @Override
    public int lockCount(long state) {
        return VanillaReadWriteWithWaitsLockingStrategy.rwReadLocked(state) + VanillaReadWriteWithWaitsLockingStrategy.rwWriteLocked(state);
    }

    @Override
    public String toString(long state) {
        return "[read locks = " + this.readLockCount(state) + ", write locked = " + this.isWriteLocked(state) + ", waits = " + this.waitCount(state) + "]";
    }

    @Override
    public int sizeInBytes() {
        return 8;
    }
}

