/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import net.openhft.lang.io.NativeBytes;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

public class VanillaMappedBytes
extends NativeBytes {
    private final MappedByteBuffer buffer;
    private final FileChannel channel;
    private final long index;
    private boolean unmapped;

    public VanillaMappedBytes(MappedByteBuffer buffer) {
        this(buffer, -1L, null);
    }

    public VanillaMappedBytes(MappedByteBuffer buffer, long index) {
        this(buffer, index, null);
    }

    protected VanillaMappedBytes(MappedByteBuffer buffer, long index, FileChannel channel) {
        super(((DirectBuffer)((Object)buffer)).address(), ((DirectBuffer)((Object)buffer)).address() + (long)buffer.capacity());
        this.buffer = buffer;
        this.channel = channel;
        this.unmapped = false;
        this.index = index;
    }

    public long index() {
        return this.index;
    }

    public synchronized boolean unmapped() {
        return this.unmapped;
    }

    @Override
    public boolean release() {
        if (!this.unmapped()) {
            return super.release();
        }
        return false;
    }

    @Override
    protected synchronized void cleanup() {
        if (!this.unmapped) {
            Cleaner cl = ((DirectBuffer)((Object)this.buffer)).cleaner();
            if (cl != null) {
                cl.clean();
            }
            try {
                if (this.channel != null && this.channel.isOpen()) {
                    this.channel.close();
                }
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            this.unmapped = true;
        }
        super.cleanup();
    }

    public void force() {
        this.buffer.force();
    }

    @Override
    public ByteBuffer sliceAsByteBuffer(ByteBuffer toReuse) {
        return this.sliceAsByteBuffer(toReuse, this.buffer);
    }
}

