/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.BytesStore;
import net.openhft.lang.io.NativeBytes;

public class MultiStoreBytes
extends NativeBytes {
    private Bytes underlyingBytes;
    private long underlyingOffset;

    public MultiStoreBytes() {
        super(NO_PAGE, NO_PAGE);
    }

    public void storePositionAndSize(BytesStore store, long offset, long size) {
        if (offset < 0L || size < 0L || offset + size > store.size()) {
            throw new IllegalArgumentException("offset: " + offset + ", size: " + size + ", store.size: " + store.size());
        }
        this.setObjectSerializer(store.objectSerializer());
        this.startAddr = this.positionAddr = store.address() + offset;
        this.capacityAddr = this.limitAddr = this.startAddr + size;
        this.underlyingBytes = null;
        this.underlyingOffset = 0L;
    }

    public void setBytesOffset(Bytes bytes, long offset) {
        this.setObjectSerializer(bytes.objectSerializer());
        long bytesAddr = bytes.address();
        this.startAddr = this.positionAddr = bytesAddr + offset;
        this.capacityAddr = this.limitAddr = bytesAddr + bytes.capacity();
        this.underlyingBytes = bytes;
        this.underlyingOffset = offset;
    }

    public Bytes underlyingBytes() {
        if (this.underlyingBytes == null) {
            throw new IllegalStateException();
        }
        return this.underlyingBytes;
    }

    public long underlyingOffset() {
        return this.underlyingOffset;
    }
}

