/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.serialization.impl;

import java.nio.ByteBuffer;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.serialization.CompactBytesMarshaller;
import net.openhft.lang.model.constraints.Nullable;

public final class ByteBufferMarshaller
extends Enum<ByteBufferMarshaller>
implements CompactBytesMarshaller<ByteBuffer> {
    public static final /* enum */ ByteBufferMarshaller INSTANCE = new ByteBufferMarshaller();
    private static final /* synthetic */ ByteBufferMarshaller[] $VALUES;

    public static ByteBufferMarshaller[] values() {
        return (ByteBufferMarshaller[])$VALUES.clone();
    }

    public static ByteBufferMarshaller valueOf(String name) {
        return Enum.valueOf(ByteBufferMarshaller.class, name);
    }

    @Override
    public byte code() {
        return 2;
    }

    @Override
    public void write(Bytes bytes, ByteBuffer byteBuffer) {
        int position = byteBuffer.position();
        bytes.writeStopBit(byteBuffer.remaining());
        bytes.write(byteBuffer);
        byteBuffer.position(position);
    }

    @Override
    public ByteBuffer read(Bytes bytes) {
        return this.read(bytes, null);
    }

    @Override
    public ByteBuffer read(Bytes bytes, @Nullable ByteBuffer byteBuffer) {
        long length = bytes.readStopBit();
        assert (length <= Integer.MAX_VALUE);
        if (length < 0L || length > Integer.MAX_VALUE) {
            throw new IllegalStateException("Invalid length: " + length);
        }
        if (byteBuffer == null || (long)byteBuffer.capacity() < length) {
            byteBuffer = this.newByteBuffer((int)length);
        } else {
            byteBuffer.position(0);
            byteBuffer.limit((int)length);
        }
        bytes.read(byteBuffer);
        byteBuffer.flip();
        return byteBuffer;
    }

    protected ByteBuffer newByteBuffer(int length) {
        return ByteBuffer.allocate(length);
    }

    static {
        $VALUES = new ByteBufferMarshaller[]{INSTANCE};
    }
}

