/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.nio.ByteOrder;
import net.openhft.lang.Maths;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.BytesHasher;

public enum VanillaBytesHash implements BytesHasher
{
    INSTANCE;

    private static final int TOP_BYTES;
    static final int K0 = -978308811;
    static final int K1 = 492187003;
    static final int M0 = 1228037679;
    static final int M1 = 846538563;
    static final int M2 = -189059537;
    static final int M3 = 1248073673;

    @Override
    public long hash(Bytes bytes, long offset, long limit) {
        int i;
        int remaining = Maths.toInt(limit - offset, "Hash of a very large data set");
        long h0 = remaining;
        long h1 = 0L;
        for (i = 0; i < remaining - 31; i += 32) {
            h0 *= -978308811L;
            h1 *= 492187003L;
            long addrI = offset + (long)i;
            long l0 = bytes.readLong(addrI);
            int l0a = bytes.readInt(addrI + (long)TOP_BYTES);
            long l1 = bytes.readLong(addrI + 8L);
            int l1a = bytes.readInt(addrI + 8L + (long)TOP_BYTES);
            long l2 = bytes.readLong(addrI + 16L);
            int l2a = bytes.readInt(addrI + 16L + (long)TOP_BYTES);
            long l3 = bytes.readLong(addrI + 24L);
            int l3a = bytes.readInt(addrI + 24L + (long)TOP_BYTES);
            h0 += (l0 + (long)l1a) * 1228037679L + (l2 + (long)l3a) * -189059537L;
            h1 += (l1 + (long)l0a) * 846538563L + (l3 + (long)l2a) * 1248073673L;
        }
        int left = remaining - i;
        if (left > 0) {
            h0 *= -978308811L;
            h1 *= 492187003L;
            long addrI = offset + (long)i;
            long l0 = bytes.readIncompleteLong(addrI);
            int l0a = (int)(l0 >> 32);
            long l1 = bytes.readIncompleteLong(addrI + 8L);
            int l1a = (int)(l1 >> 32);
            long l2 = bytes.readIncompleteLong(addrI + 16L);
            int l2a = (int)(l2 >> 32);
            long l3 = bytes.readIncompleteLong(addrI + 24L);
            int l3a = (int)(l3 >> 32);
            h0 += (l0 + (long)l1a) * 1228037679L + (l2 + (long)l3a) * -189059537L;
            h1 += (l1 + (long)l0a) * 846538563L + (l3 + (long)l2a) * 1248073673L;
        }
        return Maths.agitate(h0) ^ Maths.agitate(h1);
    }

    @Override
    public long hash(Bytes bytes) {
        return this.hash(bytes, bytes.position(), bytes.limit());
    }

    static {
        TOP_BYTES = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 4 : 0;
    }
}

