/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import net.openhft.lang.io.BytesStore;
import net.openhft.lang.io.NativeBytes;
import net.openhft.lang.model.constraints.NotNull;

public class DirectBytes
extends NativeBytes {
    @NotNull
    private final BytesStore store;

    public DirectBytes(@NotNull BytesStore store, AtomicInteger refCount) {
        super(store.objectSerializer(), store.address(), store.address() + store.size(), refCount);
        this.store = store;
    }

    public DirectBytes(@NotNull BytesStore store, AtomicInteger refCount, long offset, long length) {
        super(store.objectSerializer(), store.address() + offset, store.address() + offset + length, refCount);
        this.store = store;
    }

    public void positionAndSize(long offset, long size) {
        if (offset < 0L || size < 0L || offset + size > this.store.size()) {
            throw new IllegalArgumentException();
        }
        this.setStartPositionAddress(this.store.address() + offset);
        this.capacityAddr = this.limitAddr = this.startAddr + size;
    }

    public BytesStore store() {
        return this.store;
    }

    @Override
    protected void cleanup() {
        this.store.free();
    }

    @Override
    public ByteBuffer sliceAsByteBuffer(ByteBuffer toReuse) {
        return this.sliceAsByteBuffer(toReuse, this.store);
    }
}

