/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.serialization.impl;

import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import net.openhft.lang.Compare;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.serialization.CompactBytesMarshaller;
import net.openhft.lang.io.serialization.impl.ImmutableMarshaller;
import net.openhft.lang.io.serialization.impl.StringBuilderPool;
import net.openhft.lang.model.constraints.NotNull;
import net.openhft.lang.model.constraints.Nullable;
import net.openhft.lang.pool.StringInterner;

public class ClassMarshaller
extends ImmutableMarshaller<Class>
implements CompactBytesMarshaller<Class> {
    private static final int CACHE_SIZE = 1019;
    private static final Map<String, Class> SC_SHORT_NAME;
    private static final Map<Class, String> CS_SHORT_NAME;
    private final ClassLoader classLoader;
    private static final StringBuilderPool sbp;
    @Nullable
    private WeakReference<Class>[] classWeakReference = null;

    public ClassMarshaller(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void write(@NotNull Bytes bytes, @NotNull Class aClass) {
        String s = CS_SHORT_NAME.get(aClass);
        if (s == null) {
            s = aClass.getName();
        }
        bytes.writeUTF\u0394(s);
    }

    @Override
    @Nullable
    public Class read(@NotNull Bytes bytes) {
        StringBuilder sb = sbp.acquireStringBuilder();
        bytes.readUTF\u0394(sb);
        return this.load(sb);
    }

    @Nullable
    private Class load(@NotNull CharSequence name) {
        Class clazz;
        WeakReference<Class> ref;
        int hash = (int)(Compare.calcLongHashCode(name) & 0x7FFFFFFL) % 1019;
        if (this.classWeakReference == null) {
            this.classWeakReference = new WeakReference[1019];
        }
        if ((ref = this.classWeakReference[hash]) != null && (clazz = (Class)ref.get()) != null && StringInterner.isEqual(clazz.getName(), name)) {
            return clazz;
        }
        try {
            String className = name.toString();
            Class<?> clazz2 = SC_SHORT_NAME.get(className);
            if (clazz2 != null) {
                return clazz2;
            }
            clazz2 = this.classLoader.loadClass(className);
            this.classWeakReference[hash] = new WeakReference(clazz2);
            return clazz2;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public byte code() {
        return 3;
    }

    static {
        Class[] classes;
        SC_SHORT_NAME = new LinkedHashMap<String, Class>();
        CS_SHORT_NAME = new LinkedHashMap<Class, String>();
        for (Class clazz : classes = new Class[]{Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class, Class.class, BigInteger.class, BigDecimal.class, Date.class}) {
            String simpleName = clazz.getSimpleName();
            SC_SHORT_NAME.put(simpleName, clazz);
            CS_SHORT_NAME.put(clazz, simpleName);
        }
        sbp = new StringBuilderPool();
    }
}

