/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.openhft.lang.io.IByteBufferBytes;
import net.openhft.lang.io.IOTools;
import net.openhft.lang.io.NativeBytes;
import sun.nio.ch.DirectBuffer;

public class DirectByteBufferBytes
extends NativeBytes
implements IByteBufferBytes {
    private ByteBuffer buffer;

    public DirectByteBufferBytes(int capacity) {
        this(ByteBuffer.allocateDirect(capacity).order(ByteOrder.nativeOrder()), 0, capacity);
    }

    public DirectByteBufferBytes(ByteBuffer buffer) {
        this(buffer, 0, buffer.capacity());
    }

    public DirectByteBufferBytes(ByteBuffer buffer, int start, int capacity) {
        super(((DirectBuffer)((Object)buffer)).address() + (long)start, ((DirectBuffer)((Object)buffer)).address() + (long)capacity);
        this.buffer = buffer;
    }

    @Override
    public ByteBuffer buffer() {
        return this.buffer;
    }

    @Override
    public ByteBuffer sliceAsByteBuffer(ByteBuffer toReuse) {
        return this.sliceAsByteBuffer(toReuse, this.buffer);
    }

    protected DirectByteBufferBytes resize(int newCapacity, boolean cleanup, boolean preserveData) {
        if ((long)newCapacity != this.capacity()) {
            ByteBuffer oldBuffer = this.buffer;
            long oldAddress = this.startAddr;
            long oldPosition = this.position();
            if (preserveData && oldPosition > (long)newCapacity) {
                throw new IllegalArgumentException("Capacity can't be less than currently used data (size=" + oldPosition + ", capacity=" + newCapacity + ")");
            }
            this.buffer = ByteBuffer.allocateDirect(newCapacity).order(ByteOrder.nativeOrder());
            this.setStartPositionAddress(((DirectBuffer)((Object)this.buffer)).address());
            this.limitAddr = this.capacityAddr = this.startAddr + (long)newCapacity;
            if (preserveData && oldPosition > 0L) {
                UNSAFE.copyMemory(oldAddress, this.startAddr, Math.min((long)newCapacity, oldPosition));
                this.positionAddr = this.startAddr + Math.min((long)newCapacity, oldPosition);
            }
            if (cleanup) {
                IOTools.clean(oldBuffer);
            }
        }
        return this;
    }
}

