/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.io.UTFDataFormatException;
import java.math.BigInteger;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.openhft.lang.Jvm;
import net.openhft.lang.Maths;
import net.openhft.lang.io.ByteStringAppender;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.IOTools;
import net.openhft.lang.io.MutableDecimal;
import net.openhft.lang.io.RandomDataInput;
import net.openhft.lang.io.StopCharTester;
import net.openhft.lang.io.serialization.BytesMarshallableSerializer;
import net.openhft.lang.io.serialization.BytesMarshallerFactory;
import net.openhft.lang.io.serialization.JDKZObjectSerializer;
import net.openhft.lang.io.serialization.ObjectSerializer;
import net.openhft.lang.io.serialization.impl.StringBuilderPool;
import net.openhft.lang.io.serialization.impl.VanillaBytesMarshallerFactory;
import net.openhft.lang.io.view.BytesInputStream;
import net.openhft.lang.io.view.BytesOutputStream;
import net.openhft.lang.model.Byteable;
import net.openhft.lang.pool.StringInterner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBytes
implements Bytes {
    public static final int END_OF_BUFFER = -1;
    public static final long UNSIGNED_INT_MASK = 0xFFFFFFFFL;
    public static final int SLEEP_THRESHOLD = 20000000;
    static final int RW_LOCK_LIMIT = 30;
    static final long RW_READ_LOCKED = 1L;
    static final long RW_WRITE_WAITING = 0x40000000L;
    static final long RW_WRITE_LOCKED = 0x1000000000000000L;
    static final int RW_LOCK_MASK = 0x3FFFFFFF;
    private static final long BUSY_LOCK_LIMIT = 20000000000L;
    private static final int INT_LOCK_MASK;
    private static final int UNSIGNED_BYTE_MASK = 255;
    private static final int UNSIGNED_SHORT_MASK = 65535;
    private static final int USHORT_EXTENDED = 65535;
    private static final int MAX_NUMBER_LENGTH;
    private static final byte[] RADIX_PARSE;
    private static final Logger LOGGER;
    private static final Charset ISO_8859_1;
    private static final byte[] MIN_VALUE_TEXT;
    private static final byte[] Infinity;
    private static final byte[] NaN;
    private static final long MAX_VALUE_DIVIDE_5 = 0x1999999999999999L;
    private static final byte BYTE_MIN_VALUE = -128;
    private static final byte BYTE_EXTENDED = -127;
    private static final byte BYTE_MAX_VALUE = -126;
    private static final short UBYTE_EXTENDED = 255;
    private static final short SHORT_MIN_VALUE = Short.MIN_VALUE;
    private static final short SHORT_EXTENDED = -32767;
    private static final short SHORT_MAX_VALUE = -32766;
    private static final int INT_MIN_VALUE = Integer.MIN_VALUE;
    private static final int INT_EXTENDED = -2147483647;
    private static final int INT_MAX_VALUE = -2147483646;
    private static final long MAX_VALUE_DIVIDE_10 = 0xCCCCCCCCCCCCCCCL;
    private static final byte[] RADIX;
    private static final StringBuilderPool sbp;
    private static final ThreadLocal<DateCache> dateCacheTL;
    private static boolean ID_LIMIT_WARNED;
    final AtomicInteger refCount;
    private final byte[] numberBuffer = new byte[MAX_NUMBER_LENGTH];
    protected boolean finished = false;
    ObjectSerializer objectSerializer;
    private StringInterner stringInterner = null;
    private boolean selfTerminating = false;
    volatile Thread singleThread = null;

    AbstractBytes() {
        this(new VanillaBytesMarshallerFactory(), new AtomicInteger(1));
    }

    AbstractBytes(BytesMarshallerFactory bytesMarshallerFactory, AtomicInteger refCount) {
        this(BytesMarshallableSerializer.create(bytesMarshallerFactory, JDKZObjectSerializer.INSTANCE), refCount);
    }

    AbstractBytes(ObjectSerializer objectSerializer, AtomicInteger refCount) {
        this.refCount = refCount;
        this.objectSerializer = objectSerializer;
    }

    @Override
    public void clearThreadAssociation() {
        this.singleThread = null;
    }

    boolean checkSingleThread() {
        Thread t = Thread.currentThread();
        if (this.singleThread != t) {
            this.setThreadOrThrowException(t);
        }
        return true;
    }

    private void setThreadOrThrowException(Thread t) {
        if (this.singleThread != null) {
            throw new IllegalStateException("Altered by thread " + this.singleThread + " and " + t);
        }
        this.singleThread = t;
    }

    private static boolean equalsCaseIgnore(StringBuilder sb, String s) {
        if (sb.length() != s.length()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Character.toLowerCase(sb.charAt(i)) == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static double asDouble(long value, int exp, boolean negative, int decimalPlaces) {
        if (decimalPlaces > 0 && value < 0x3FFFFFFFFFFFFFFFL) {
            if (value < Integer.MAX_VALUE) {
                exp -= 32;
                value <<= 32;
            }
            if (value < 0x7FFFFFFFFFFFL) {
                exp -= 16;
                value <<= 16;
            }
            if (value < 0x7FFFFFFFFFFFFFL) {
                exp -= 8;
                value <<= 8;
            }
            if (value < 0x7FFFFFFFFFFFFFFL) {
                exp -= 4;
                value <<= 4;
            }
            if (value < 0x1FFFFFFFFFFFFFFFL) {
                exp -= 2;
                value <<= 2;
            }
            if (value < 0x3FFFFFFFFFFFFFFFL) {
                --exp;
                value <<= 1;
            }
        }
        while (decimalPlaces > 0) {
            --exp;
            long mod = value % 5L;
            int modDiv = 1;
            if ((value /= 5L) < 0x7FFFFFFFFFFFFFFL) {
                exp -= 4;
                value <<= 4;
                modDiv <<= 4;
            }
            if (value < 0x1FFFFFFFFFFFFFFFL) {
                exp -= 2;
                value <<= 2;
                modDiv <<= 2;
            }
            if (value < 0x3FFFFFFFFFFFFFFFL) {
                --exp;
                value <<= 1;
                modDiv <<= 1;
            }
            value = decimalPlaces > 1 ? (value += (long)modDiv * mod / 5L) : (value += ((long)modDiv * mod + 4L) / 5L);
            --decimalPlaces;
        }
        double d = Math.scalb((double)value, exp);
        return negative ? -d : d;
    }

    private static void warnIdLimit(long id) {
        LOGGER.log(Level.WARNING, "High thread id may result in collisions id: " + id);
        ID_LIMIT_WARNED = true;
    }

    static int returnOrThrowEndOfBuffer(boolean selfTerminating) {
        if (selfTerminating) {
            return -1;
        }
        throw new BufferUnderflowException();
    }

    public static void readUTF0(Bytes bytes, @NotNull Appendable appendable, int utflen) throws IOException {
        int c;
        int count;
        for (count = 0; count < utflen; ++count) {
            c = bytes.readUnsignedByteOrThrow();
            if (c >= 128) {
                bytes.position(bytes.position() - 1L);
                break;
            }
            if (c < 0) {
                // empty if block
            }
            appendable.append((char)c);
        }
        block6: while (count < utflen) {
            c = bytes.readUnsignedByte();
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    appendable.append((char)c);
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    int char2 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count + " was " + char2);
                    }
                    char c2 = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    appendable.append(c2);
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    int char2 = bytes.readUnsignedByte();
                    int char3 = bytes.readUnsignedByte();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1) + " was " + char2 + " " + char3);
                    }
                    char c3 = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    appendable.append(c3);
                    continue block6;
                }
            }
            throw new UTFDataFormatException("malformed input around byte " + count);
        }
    }

    public static long findUTFLength(@NotNull CharSequence str, long strlen) {
        long utflen = 0L;
        int i = 0;
        while ((long)i < strlen) {
            long c = str.charAt(i);
            utflen = c >= 0L && c <= 127L ? ++utflen : (c > 2047L ? (utflen += 3L) : (utflen += 2L));
            ++i;
        }
        return utflen;
    }

    public static void writeUTF0(Bytes bytes, @NotNull CharSequence str, long strlen) {
        char c;
        int i = 0;
        while ((long)i < strlen && (c = str.charAt(i)) >= '\u0000' && c <= '\u007f') {
            bytes.write(c);
            ++i;
        }
        while ((long)i < strlen) {
            c = str.charAt(i);
            if (c >= '\u0000' && c <= '\u007f') {
                bytes.write(c);
            } else if (c > '\u07ff') {
                bytes.write((byte)(0xE0 | c >> 12 & 0xF));
                bytes.write((byte)(0x80 | c >> 6 & 0x3F));
                bytes.write((byte)(0x80 | c & 0x3F));
            } else {
                bytes.write((byte)(0xC0 | c >> 6 & 0x1F));
                bytes.write((byte)(0x80 | c & 0x3F));
            }
            ++i;
        }
    }

    static void checkArrayOffs(int arrayLength, int off, int len) {
        if ((len | off) < 0 | ((long)(off + len) & 0xFFFFFFFFL) > (long)arrayLength) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static String toHex(@NotNull Bytes buffer) {
        if (buffer.remaining() == 0L) {
            return "";
        }
        Bytes slice = buffer.slice();
        StringBuilder builder = new StringBuilder("[");
        while (slice.remaining() > 0L) {
            byte b = slice.readByte();
            builder.append((char)b + "(" + String.format("%02X ", b).trim() + ")");
            builder.append(",");
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append("]");
        return builder.toString();
    }

    public static String toString(@NotNull Bytes buffer) {
        Bytes slice = buffer.slice();
        StringBuilder builder = new StringBuilder("");
        while (slice.remaining() > 0L) {
            byte b = slice.readByte();
            builder.append((char)b);
        }
        return builder.toString();
    }

    static int rwReadLocked(long lock) {
        return (int)(lock & 0x3FFFFFFFL);
    }

    static int rwWriteWaiting(long lock) {
        return (int)(lock >>> 30 & 0x3FFFFFFFL);
    }

    static int rwWriteLocked(long lock) {
        return (int)(lock >>> 60);
    }

    @Override
    public long size() {
        return this.capacity();
    }

    @Override
    public void free() {
        throw new UnsupportedOperationException("Forcing a free() via Bytes is unsafe, try reserve() + release()");
    }

    @Override
    public void reserve() {
        if (this.refCount.get() < 1) {
            throw new IllegalStateException();
        }
        this.refCount.incrementAndGet();
    }

    @Override
    public boolean release() {
        if (this.refCount.get() < 1) {
            throw new IllegalStateException();
        }
        if (this.refCount.decrementAndGet() > 0) {
            return false;
        }
        this.cleanup();
        return true;
    }

    protected abstract void cleanup();

    @Override
    public int refCount() {
        return this.refCount.get();
    }

    StringInterner stringInterner() {
        if (this.stringInterner == null) {
            this.stringInterner = new StringInterner(8192);
        }
        return this.stringInterner;
    }

    @Override
    public void selfTerminating(boolean selfTerminating) {
        this.selfTerminating = selfTerminating;
    }

    @Override
    public boolean selfTerminating() {
        return this.selfTerminating;
    }

    @Override
    public int readUnsignedByteOrThrow() throws BufferUnderflowException {
        return this.readByteOrThrow(this.selfTerminating);
    }

    public int readByteOrThrow(boolean selfTerminating) throws BufferUnderflowException {
        return this.remaining() < 1L ? AbstractBytes.returnOrThrowEndOfBuffer(selfTerminating) : this.readUnsignedByte();
    }

    @Override
    public Boolean parseBoolean(@NotNull StopCharTester tester) {
        StringBuilder sb = this.acquireUtfReader();
        this.parseUTF(sb, tester);
        if (sb.length() == 0) {
            return null;
        }
        switch (sb.charAt(0)) {
            case 'T': 
            case 't': {
                return sb.length() == 1 || AbstractBytes.equalsCaseIgnore(sb, "true") ? Boolean.valueOf(true) : null;
            }
            case 'Y': 
            case 'y': {
                return sb.length() == 1 || AbstractBytes.equalsCaseIgnore(sb, "yes") ? Boolean.valueOf(true) : null;
            }
            case '0': {
                return sb.length() == 1 ? Boolean.valueOf(false) : null;
            }
            case '1': {
                return sb.length() == 1 ? Boolean.valueOf(true) : null;
            }
            case 'F': 
            case 'f': {
                return sb.length() == 1 || AbstractBytes.equalsCaseIgnore(sb, "false") ? Boolean.valueOf(false) : null;
            }
            case 'N': 
            case 'n': {
                return sb.length() == 1 || AbstractBytes.equalsCaseIgnore(sb, "no") ? Boolean.valueOf(false) : null;
            }
        }
        return null;
    }

    @Override
    public void readFully(@NotNull byte[] bytes) {
        this.readFully(bytes, 0, bytes.length);
    }

    @Override
    public void readFully(@NotNull char[] data) {
        this.readFully(data, 0, data.length);
    }

    @Override
    public int skipBytes(int n) {
        return (int)this.skip(n);
    }

    @Override
    public boolean readBoolean() {
        return this.readByteOrThrow(false) != 0;
    }

    @Override
    public boolean readBoolean(long offset) {
        return this.readByte(offset) != 0;
    }

    @Override
    public int readUnsignedByte() {
        return this.readByte() & 0xFF;
    }

    @Override
    public int readUnsignedByte(long offset) {
        return this.readByte(offset) & 0xFF;
    }

    @Override
    public int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public int readUnsignedShort(long offset) {
        return this.readShort(offset) & 0xFFFF;
    }

    @Override
    @NotNull
    public String readLine() {
        StringBuilder input = this.acquireUtfReader();
        block4: while (this.position() < this.capacity()) {
            int c = this.readUnsignedByteOrThrow();
            switch (c) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    long cur = this.position();
                    if (cur >= this.capacity() || this.readByte(cur) != 10) break block4;
                    this.position(cur + 1L);
                    break block4;
                }
                default: {
                    input.append((char)c);
                    continue block4;
                }
            }
        }
        return this.stringInterner().intern(input);
    }

    @Override
    @Nullable
    public String readUTF\u0394() {
        StringBuilder utfReader = this.acquireUtfReader();
        if (this.readUTF\u0394(utfReader)) {
            return utfReader.length() == 0 ? "" : this.stringInterner().intern(utfReader);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public synchronized String readUTF\u0394(long offset) throws IllegalStateException {
        long position = this.position();
        try {
            this.position(offset);
            String string = this.readUTF\u0394();
            return string;
        }
        finally {
            this.position(position);
        }
    }

    @NotNull
    private StringBuilder acquireUtfReader() {
        return sbp.acquireStringBuilder();
    }

    @Override
    public boolean readUTF\u0394(@NotNull StringBuilder stringBuilder) {
        try {
            stringBuilder.setLength(0);
            return this.appendUTF0(stringBuilder);
        }
        catch (IOException unexpected) {
            throw new IllegalStateException(unexpected);
        }
    }

    private boolean appendUTF0(@NotNull Appendable appendable) throws IOException {
        long len = this.readStopBit();
        if (len == -1L) {
            return false;
        }
        if (len == 0L) {
            return true;
        }
        if (len < -1L || len > this.remaining()) {
            throw new StreamCorruptedException("UTF length invalid " + len + " remaining: " + this.remaining());
        }
        int utflen = (int)len;
        AbstractBytes.readUTF0(this, appendable, utflen);
        return true;
    }

    @Override
    @NotNull
    public String parseUTF(@NotNull StopCharTester tester) {
        StringBuilder utfReader = this.acquireUtfReader();
        this.parseUTF(utfReader, tester);
        return this.stringInterner().intern(utfReader);
    }

    @Override
    public void parseUTF(@NotNull StringBuilder builder, @NotNull StopCharTester tester) {
        builder.setLength(0);
        try {
            this.readUTF0(builder, tester);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void readUTF0(@NotNull Appendable appendable, @NotNull StopCharTester tester) throws IOException {
        int c;
        while (true) {
            if ((c = this.readUnsignedByteOrThrow()) >= 128) break;
            if (tester.isStopChar(c)) {
                return;
            }
            appendable.append((char)c);
        }
        this.position(this.position() - 1L);
        block6: while (true) {
            c = this.readUnsignedByteOrThrow();
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (tester.isStopChar(c)) {
                        return;
                    }
                    appendable.append((char)c);
                    continue block6;
                }
                case 12: 
                case 13: {
                    int char2 = this.readUnsignedByte();
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte");
                    }
                    char c2 = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    if (tester.isStopChar(c2)) {
                        return;
                    }
                    appendable.append(c2);
                    continue block6;
                }
                case 14: {
                    int char2 = this.readUnsignedByte();
                    int char3 = this.readUnsignedByte();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte ");
                    }
                    char c3 = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                    if (tester.isStopChar(c3)) {
                        return;
                    }
                    appendable.append(c3);
                    continue block6;
                }
            }
            break;
        }
        throw new UTFDataFormatException("malformed input around byte ");
    }

    @Override
    public boolean stepBackAndSkipTo(@NotNull StopCharTester tester) {
        if (this.position() > 0L) {
            this.position(this.position() - 1L);
        }
        return this.skipTo(tester);
    }

    @Override
    public boolean skipTo(@NotNull StopCharTester tester) {
        while (this.remaining() > 0L) {
            int ch = this.readUnsignedByteOrThrow();
            if (!tester.isStopChar(ch)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String readUTF() {
        try {
            int len = this.readUnsignedShort();
            StringBuilder utfReader = this.acquireUtfReader();
            AbstractBytes.readUTF0(this, utfReader, len);
            return utfReader.length() == 0 ? "" : this.stringInterner().intern(utfReader);
        }
        catch (IOException unexpected) {
            throw new AssertionError((Object)unexpected);
        }
    }

    @Override
    public short readCompactShort() {
        byte b = this.readByte();
        switch (b) {
            case -128: {
                return Short.MIN_VALUE;
            }
            case -126: {
                return Short.MAX_VALUE;
            }
            case -127: {
                return this.readShort();
            }
        }
        return b;
    }

    @Override
    public int readCompactUnsignedShort() {
        int b = this.readUnsignedByte();
        if (b == 255) {
            return this.readUnsignedShort();
        }
        return b;
    }

    @Override
    public int readInt24() {
        int b = this.readUnsignedByte();
        int s = this.readUnsignedShort();
        if (this.byteOrder() == ByteOrder.BIG_ENDIAN) {
            return (b << 24) + (s << 8) >> 8;
        }
        return (b << 8) + (s << 16) >> 8;
    }

    @Override
    public int readInt24(long offset) {
        int b = this.readUnsignedByte(offset);
        int s = this.readUnsignedShort(offset + 1L);
        if (this.byteOrder() == ByteOrder.BIG_ENDIAN) {
            return (b << 24) + (s << 8) >> 8;
        }
        return (b << 8) + (s << 16) >> 8;
    }

    @Override
    public long readUnsignedInt() {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    @Override
    public long readUnsignedInt(long offset) {
        return (long)this.readInt(offset) & 0xFFFFFFFFL;
    }

    @Override
    public int readCompactInt() {
        short b = this.readShort();
        switch (b) {
            case -32768: {
                return Integer.MIN_VALUE;
            }
            case -32766: {
                return Integer.MAX_VALUE;
            }
            case -32767: {
                return this.readInt();
            }
        }
        return b;
    }

    @Override
    public long readCompactUnsignedInt() {
        int b = this.readUnsignedShort();
        if (b == 65535) {
            return this.readUnsignedInt();
        }
        return b;
    }

    @Override
    public long readInt48() {
        long s = this.readUnsignedShort();
        long l = this.readUnsignedInt();
        if (this.byteOrder() == ByteOrder.BIG_ENDIAN) {
            return (s << 48) + (l << 16) >> 16;
        }
        return (s << 16) + (l << 32) >> 16;
    }

    @Override
    public long readInt48(long offset) {
        long s = this.readUnsignedShort(offset);
        long l = this.readUnsignedInt(offset + 2L);
        if (this.byteOrder() == ByteOrder.BIG_ENDIAN) {
            return (s << 48) + (l << 16) >> 16;
        }
        return (s << 16) + (l << 32) >> 16;
    }

    @Override
    public long readCompactLong() {
        int b = this.readInt();
        switch (b) {
            case -2147483648: {
                return Long.MIN_VALUE;
            }
            case -2147483646: {
                return Long.MAX_VALUE;
            }
            case -2147483647: {
                return this.readLong();
            }
        }
        return b;
    }

    @Override
    public long readStopBit() {
        long l = this.readByte();
        if (l >= 0L) {
            return l;
        }
        return this.readStopBit0(l);
    }

    private long readStopBit0(long l) {
        long b;
        l &= 0x7FL;
        int count = 7;
        while ((b = (long)this.readByte()) < 0L) {
            l |= (b & 0x7FL) << count;
            count += 7;
        }
        if (b != 0L) {
            if (count > 56) {
                throw new IllegalStateException("Cannot read more than 9 stop bits of positive value");
            }
            return l | b << count;
        }
        if (count > 63) {
            throw new IllegalStateException("Cannot read more than 10 stop bits of negative value");
        }
        return l ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public double readCompactDouble() {
        float f = this.readFloat();
        if (Float.isNaN(f)) {
            return this.readDouble();
        }
        return f;
    }

    @Override
    public void read(@NotNull ByteBuffer bb) {
        this.read(bb, bb.remaining());
    }

    @Override
    public void read(@NotNull ByteBuffer bb, int length) {
        int len;
        if (bb.order() == this.byteOrder()) {
            for (len = (int)Math.min((long)length, this.remaining()); len >= 8; len -= 8) {
                bb.putLong(this.readLong());
            }
        }
        while (len > 0) {
            bb.put(this.readByte());
            --len;
        }
    }

    @Override
    public void write(@NotNull byte[] bytes) {
        this.write(bytes, 0, bytes.length);
    }

    private void checkWrite(long length) {
        if (length > this.remaining()) {
            throw new IllegalStateException("Cannot write " + length + " only " + this.remaining() + " remaining");
        }
    }

    @Override
    public void writeBoolean(boolean v) {
        this.write(v ? 89 : 0);
    }

    @Override
    public void writeBoolean(long offset, boolean v) {
        this.writeByte(offset, v ? 89 : 0);
    }

    @Override
    public void writeBytes(@NotNull String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this.write(s.charAt(i));
        }
    }

    @Override
    public void writeChars(@NotNull String s) {
        this.writeChars((CharSequence)s);
    }

    @Override
    public void writeChars(@NotNull CharSequence cs) {
        int len = cs.length();
        for (int i = 0; i < len; ++i) {
            this.writeChar(cs.charAt(i));
        }
    }

    @Override
    public void writeUTF(@NotNull String str) {
        long strlen = str.length();
        long utflen = AbstractBytes.findUTFLength(str, strlen);
        if (utflen > 65535L) {
            throw new IllegalStateException("String too long " + utflen + " when encoded, max: 65535");
        }
        this.writeUnsignedShort((int)utflen);
        this.checkUFTLength(utflen);
        AbstractBytes.writeUTF0(this, str, strlen);
    }

    @Override
    public void writeUTF\u0394(@Nullable CharSequence str) throws IllegalArgumentException {
        if (str == null) {
            this.writeStopBit(-1L);
            return;
        }
        long strlen = str.length();
        long utflen = AbstractBytes.findUTFLength(str, strlen);
        this.writeStopBit(utflen);
        this.checkUFTLength(utflen);
        AbstractBytes.writeUTF0(this, str, strlen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void writeUTF\u0394(long offset, int maxSize, @Nullable CharSequence s) throws IllegalStateException {
        assert (maxSize > 1);
        long position = this.position();
        try {
            this.position(offset);
            if (s == null) {
                this.writeStopBit(-1L);
                return;
            }
            long strlen = s.length();
            long utflen = AbstractBytes.findUTFLength(s, strlen);
            long totalSize = (long)IOTools.stopBitLength(utflen) + utflen;
            if (totalSize > (long)maxSize) {
                throw new IllegalStateException("Attempted to write " + totalSize + " byte String, when only " + maxSize + " allowed");
            }
            this.writeStopBit(utflen);
            AbstractBytes.writeUTF0(this, s, strlen);
            this.zeroOut(this.position(), position + (long)maxSize);
        }
        finally {
            this.position(position);
        }
    }

    @Override
    @NotNull
    public ByteStringAppender append(@NotNull CharSequence str) {
        long strlen = str.length();
        AbstractBytes.writeUTF0(this, str, strlen);
        return this;
    }

    private void checkUFTLength(long utflen) throws IllegalArgumentException {
        if (utflen > this.remaining()) {
            throw new IllegalArgumentException("encoded string too long: " + utflen + " bytes, remaining=" + this.remaining());
        }
    }

    @Override
    public void writeByte(int v) {
        this.write(v);
    }

    @Override
    public void writeUnsignedByte(int v) {
        this.writeByte(v);
    }

    @Override
    public void writeUnsignedByte(long offset, int v) {
        this.writeByte(offset, v);
    }

    @Override
    public void write(long offset, @NotNull byte[] bytes) {
        this.checkWrite(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            this.writeByte(offset + (long)i, bytes[i]);
        }
    }

    @Override
    public void write(long offset, Bytes bytes) {
        long i;
        long length = bytes.remaining();
        this.checkWrite(length);
        for (i = 0L; i < length - 7L; i += 8L) {
            this.writeLong(offset + i, bytes.readLong());
        }
        while (i < length) {
            this.writeByte(offset + i, bytes.readByte());
            ++i;
        }
    }

    @Override
    public void write(byte[] bytes, int off, int len) {
        AbstractBytes.checkArrayOffs(bytes.length, off, len);
        this.checkWrite(len);
        for (int i = 0; i < len; ++i) {
            this.write(bytes[off + i]);
        }
    }

    @Override
    public void write(long offset, byte[] bytes, int off, int len) {
        AbstractBytes.checkArrayOffs(bytes.length, off, len);
        this.checkWrite(len);
        for (int i = 0; i < len; ++i) {
            this.writeByte(offset + (long)i, bytes[off + i]);
        }
    }

    @Override
    public void write(@NotNull char[] data) {
        this.write(data, 0, data.length);
    }

    @Override
    public void write(@NotNull char[] data, int off, int len) {
        AbstractBytes.checkArrayOffs(data.length, off, len);
        this.checkWrite(len * 2);
        for (int i = 0; i < len; ++i) {
            this.writeChar(data[off + i]);
        }
    }

    @Override
    public void writeUnsignedShort(int v) {
        this.writeShort(v);
    }

    @Override
    public void writeUnsignedShort(long offset, int v) {
        this.writeShort(offset, v);
    }

    @Override
    public void writeCompactShort(int v) {
        if (v > -126 && v <= 127) {
            this.writeByte(v);
        } else {
            switch (v) {
                case -32768: {
                    this.writeByte(-128);
                    break;
                }
                case 32767: {
                    this.writeByte(-126);
                    break;
                }
                default: {
                    this.writeByte(-127);
                    this.writeShort(v);
                }
            }
        }
    }

    @Override
    public void writeCompactUnsignedShort(int v) {
        if (v >= 0 && v < 65535) {
            this.writeByte(v);
        } else {
            this.writeUnsignedShort(65535);
            this.writeUnsignedShort(v);
        }
    }

    @Override
    public void writeInt24(int v) {
        if (this.byteOrder() == ByteOrder.BIG_ENDIAN) {
            this.writeUnsignedByte(v >>> 16);
            this.writeUnsignedShort(v);
        } else {
            this.writeUnsignedByte(v);
            this.writeUnsignedShort(v >>> 8);
        }
    }

    @Override
    public void writeInt24(long offset, int v) {
        if (this.byteOrder() == ByteOrder.BIG_ENDIAN) {
            this.writeUnsignedByte(offset, v >>> 16);
            this.writeUnsignedShort(offset + 1L, v);
        } else {
            this.writeUnsignedByte(offset, v);
            this.writeUnsignedShort(offset + 1L, v >>> 8);
        }
    }

    @Override
    public void writeUnsignedInt(long v) {
        this.writeInt((int)v);
    }

    @Override
    public void writeUnsignedInt(long offset, long v) {
        this.writeInt(offset, (int)v);
    }

    @Override
    public void writeCompactInt(int v) {
        if (v > -32766 && v <= Short.MAX_VALUE) {
            this.writeShort(v);
        } else {
            switch (v) {
                case -2147483648: {
                    this.writeShort(Short.MIN_VALUE);
                    break;
                }
                case 0x7FFFFFFF: {
                    this.writeShort(-32766);
                    break;
                }
                default: {
                    this.writeShort(-32767);
                    this.writeInt(v);
                }
            }
        }
    }

    @Override
    public void writeCompactUnsignedInt(long v) {
        if (v >= 0L && v < 65535L) {
            this.writeShort((int)v);
        } else {
            this.writeShort(65535);
            this.writeUnsignedInt(v);
        }
    }

    @Override
    public void writeInt48(long v) {
        if (this.byteOrder() == ByteOrder.BIG_ENDIAN) {
            this.writeUnsignedShort((int)(v >>> 32));
            this.writeUnsignedInt(v);
        } else {
            this.writeUnsignedShort((int)v);
            this.writeUnsignedInt(v >>> 16);
        }
    }

    @Override
    public void writeInt48(long offset, long v) {
        if (this.byteOrder() == ByteOrder.BIG_ENDIAN) {
            this.writeUnsignedShort(offset, (int)(v >>> 32));
            this.writeUnsignedInt(offset + 2L, v);
        } else {
            this.writeUnsignedShort(offset, (int)v);
            this.writeUnsignedInt(offset + 2L, v >>> 16);
        }
    }

    @Override
    public void writeCompactLong(long v) {
        if (v > -2147483646L && v <= Integer.MAX_VALUE) {
            this.writeInt((int)v);
        } else if (v == Long.MIN_VALUE) {
            this.writeInt(Integer.MIN_VALUE);
        } else if (v == Long.MAX_VALUE) {
            this.writeInt(-2147483646);
        } else {
            this.writeInt(-2147483647);
            this.writeLong(v);
        }
    }

    @Override
    public void writeStopBit(long n) {
        if ((n & 0xFFFFFFFFFFFFFF80L) == 0L) {
            this.write((int)(n & 0x7FL));
            return;
        }
        if ((n & 0xFFFFFFFFFFFFC000L) == 0L) {
            this.write((int)(n & 0x7FL | 0x80L));
            this.write((int)(n >> 7));
            return;
        }
        this.writeStopBit0(n);
    }

    private void writeStopBit0(long n) {
        long n2;
        boolean neg = false;
        if (n < 0L) {
            neg = true;
            n ^= 0xFFFFFFFFFFFFFFFFL;
        }
        while ((n2 = n >>> 7) != 0L) {
            this.write((byte)(0x80L | n));
            n = n2;
        }
        if (!neg) {
            this.write((byte)n);
        } else {
            this.write((byte)(0x80L | n));
            this.write(0);
        }
    }

    @Override
    public void writeCompactDouble(double v) {
        float f = (float)v;
        if ((double)f == v) {
            this.writeFloat(f);
        } else {
            this.writeFloat(Float.NaN);
            this.writeDouble(v);
        }
    }

    @Override
    public void write(@NotNull ByteBuffer bb) {
        if (bb.order() == this.byteOrder()) {
            while (bb.remaining() >= 8) {
                this.writeLong(bb.getLong());
            }
        }
        while (bb.remaining() >= 1) {
            this.writeByte(bb.get());
        }
    }

    @Override
    @NotNull
    public ByteStringAppender append(@NotNull CharSequence s, int start, int end) {
        int len = Math.min(end, s.length());
        for (int i = start; i < len; ++i) {
            this.writeByte(s.charAt(i));
        }
        return this;
    }

    @Override
    @NotNull
    public ByteStringAppender append(@Nullable Enum value) {
        return value == null ? this : this.append(value.toString());
    }

    @Override
    @NotNull
    public ByteStringAppender append(boolean b) {
        this.append(b ? "true" : "false");
        return this;
    }

    @Override
    @NotNull
    public ByteStringAppender append(char c) {
        this.writeByte(c);
        return this;
    }

    @Override
    @NotNull
    public ByteStringAppender append(int num) {
        return this.append((long)num);
    }

    @Override
    @NotNull
    public ByteStringAppender append(long num) {
        if (num < 0L) {
            if (num == Long.MIN_VALUE) {
                this.write(MIN_VALUE_TEXT);
                return this;
            }
            this.writeByte(45);
            num = -num;
        }
        if (num == 0L) {
            this.writeByte(48);
        } else {
            this.appendLong0(num);
        }
        return this;
    }

    @Override
    @NotNull
    public ByteStringAppender append(long num, int base) {
        if (base < 2 || base > 36) {
            throw new IllegalArgumentException("Invalid base: " + base);
        }
        if (num < 0L) {
            if (num == Long.MIN_VALUE) {
                this.writeBytes(BigInteger.valueOf(num).toString(base));
                return this;
            }
            this.writeByte(45);
            num = -num;
        }
        if (num == 0L) {
            this.writeByte(48);
        } else {
            while (num > 0L) {
                this.writeByte(RADIX[(int)(num % (long)base)]);
                num /= (long)base;
            }
        }
        return this;
    }

    @Override
    @NotNull
    public ByteStringAppender appendDateMillis(long timeInMS) {
        DateCache dateCache = dateCacheTL.get();
        if (dateCache == null) {
            dateCache = new DateCache();
            dateCacheTL.set(dateCache);
        }
        long date = timeInMS / 86400000L;
        if (dateCache.lastDay != date) {
            DateCache.access$102(dateCache, dateCache.dateFormat.format(new Date(timeInMS)).getBytes(ISO_8859_1));
            dateCache.lastDay = date;
        } else assert (dateCache.lastDateStr != null);
        this.write(dateCache.lastDateStr);
        return this;
    }

    @Override
    @NotNull
    public ByteStringAppender appendDateTimeMillis(long timeInMS) {
        this.appendDateMillis(timeInMS);
        this.writeByte(84);
        this.appendTimeMillis(timeInMS % 86400000L);
        return this;
    }

    @Override
    @NotNull
    public ByteStringAppender appendTimeMillis(long timeInMS) {
        int hours = (int)(timeInMS / 3600000L);
        if (hours > 99) {
            this.appendLong0(hours);
        } else {
            this.writeByte((char)(hours / 10 + 48));
            this.writeByte((char)(hours % 10 + 48));
        }
        this.writeByte(58);
        int minutes = (int)(timeInMS / 60000L % 60L);
        this.writeByte((char)(minutes / 10 + 48));
        this.writeByte((char)(minutes % 10 + 48));
        this.writeByte(58);
        int seconds = (int)(timeInMS / 1000L % 60L);
        this.writeByte((char)(seconds / 10 + 48));
        this.writeByte((char)(seconds % 10 + 48));
        this.writeByte(46);
        int millis = (int)(timeInMS % 1000L);
        this.writeByte((char)(millis / 100 + 48));
        this.writeByte((char)(millis / 10 % 10 + 48));
        this.writeByte((char)(millis % 10 + 48));
        return this;
    }

    @Override
    @NotNull
    public ByteStringAppender append(double d) {
        int shift;
        long val = Double.doubleToRawLongBits(d);
        int sign = (int)(val >>> 63);
        int exp = (int)(val >>> 52 & 0x7FFL);
        long mantissa = val & 0xFFFFFFFFFFFFFL;
        if (sign != 0) {
            this.writeByte(45);
        }
        if (exp == 0 && mantissa == 0L) {
            this.writeByte(48);
            return this;
        }
        if (exp == 2047) {
            if (mantissa == 0L) {
                this.write(Infinity);
            } else {
                this.write(NaN);
            }
            return this;
        }
        if (exp > 0) {
            mantissa += 0x10000000000000L;
        }
        if ((shift = 1075 - exp) > 0) {
            if (shift < 53) {
                long intValue = mantissa >> shift;
                this.appendLong0(intValue);
                if ((mantissa -= intValue << shift) > 0L) {
                    long num;
                    this.writeByte(46);
                    mantissa <<= 1;
                    ++mantissa;
                    int precision = shift + 1;
                    long value = intValue;
                    int decimalPlaces = 0;
                    for (long error = 1L; mantissa > error; error *= 5L, mantissa -= num << precision) {
                        num = (mantissa *= 5L) >> --precision;
                        value = value * 10L + num;
                        this.writeByte((char)(48L + num));
                        double parsedValue = AbstractBytes.asDouble(value, 0, sign != 0, ++decimalPlaces);
                        if (parsedValue != d) continue;
                        break;
                    }
                }
                return this;
            }
            this.writeByte(48);
            this.writeByte(46);
            mantissa <<= 6;
            mantissa += 32L;
            int precision = shift + 6;
            long value = 0L;
            int decimalPlaces = 0;
            for (long error = 32L; mantissa > error; error *= 5L) {
                while (mantissa > 0x1999999999999999L) {
                    mantissa >>>= 1;
                    error = error + 1L >>> 1;
                    --precision;
                }
                mantissa *= 5L;
                if (--precision >= 64) {
                    ++decimalPlaces;
                    this.writeByte(48);
                    continue;
                }
                long num = mantissa >>> precision;
                value = value * 10L + num;
                char c = (char)(48L + num);
                assert (c >= '0' && c <= '9');
                this.writeByte(c);
                mantissa -= num << precision;
                double parsedValue = AbstractBytes.asDouble(value, 0, sign != 0, ++decimalPlaces);
                if (parsedValue != d) continue;
                break;
            }
            return this;
        }
        mantissa <<= 10;
        int precision = -10 - shift;
        int digits = 0;
        while ((precision > 53 || mantissa > Long.MAX_VALUE >> precision) && precision > 0) {
            ++digits;
            --precision;
            long mod = mantissa % 5L;
            mantissa /= 5L;
            int modDiv = 1;
            while (mantissa < 0x1999999999999999L && precision > 1) {
                --precision;
                mantissa <<= 1;
                modDiv <<= 1;
            }
            mantissa += (long)modDiv * mod / 5L;
        }
        long val2 = precision > 0 ? mantissa << precision : mantissa >>> -precision;
        this.appendLong0(val2);
        for (int i = 0; i < digits; ++i) {
            this.writeByte(48);
        }
        return this;
    }

    @Override
    public double parseDouble() {
        long value = 0L;
        int exp = 0;
        boolean negative = false;
        int decimalPlaces = Integer.MIN_VALUE;
        int ch = this.readUnsignedByteOrThrow();
        switch (ch) {
            case 78: {
                if (this.compareRest("aN")) {
                    return Double.NaN;
                }
                this.skip(-1L);
                return Double.NaN;
            }
            case 73: {
                if (this.compareRest("nfinity")) {
                    return Double.POSITIVE_INFINITY;
                }
                this.skip(-1L);
                return Double.NaN;
            }
            case 45: {
                if (this.compareRest("Infinity")) {
                    return Double.NEGATIVE_INFINITY;
                }
                negative = true;
                ch = this.readUnsignedByteOrThrow();
            }
        }
        while (true) {
            if (ch >= 48 && ch <= 57) {
                while (value >= 0xCCCCCCCCCCCCCCCL) {
                    value >>>= 1;
                    ++exp;
                }
                value = value * 10L + (long)(ch - 48);
                ++decimalPlaces;
            } else {
                if (ch != 46) break;
                decimalPlaces = 0;
            }
            ch = this.readUnsignedByteOrThrow();
        }
        return AbstractBytes.asDouble(value, exp, negative, decimalPlaces);
    }

    protected boolean compareRest(String s) {
        if ((long)s.length() > this.remaining()) {
            return false;
        }
        long position = this.position();
        for (int i = 0; i < s.length(); ++i) {
            if (this.readUnsignedByte(position + (long)i) == s.charAt(i)) continue;
            return false;
        }
        this.skip(s.length());
        return true;
    }

    @Override
    @NotNull
    public <E> ByteStringAppender append(@NotNull Iterable<E> list, @NotNull CharSequence separator) {
        if (list instanceof RandomAccess && list instanceof List) {
            return this.append((List)list, separator);
        }
        int i = 0;
        for (E e : list) {
            if (i++ > 0) {
                this.append(separator);
            }
            if (e == null) continue;
            this.append(e.toString());
        }
        return this;
    }

    @NotNull
    <E> ByteStringAppender append(@NotNull List<E> list, @NotNull CharSequence separator) {
        for (int i = 0; i < list.size(); ++i) {
            E e;
            if (i > 0) {
                this.append(separator);
            }
            if ((e = list.get(i)) == null) continue;
            this.append(e.toString());
        }
        return this;
    }

    @Override
    @NotNull
    public MutableDecimal parseDecimal(@NotNull MutableDecimal decimal) {
        long num = 0L;
        long scale = Long.MIN_VALUE;
        boolean negative = false;
        while (true) {
            int b;
            if ((b = this.readUnsignedByteOrThrow()) - -2147483600 <= -2147483639) {
                num = num * 10L + (long)b - 48L;
                ++scale;
                continue;
            }
            if (b == 46) {
                scale = 0L;
                continue;
            }
            if (b != 45) break;
            negative = true;
        }
        if (negative) {
            num = -num;
        }
        decimal.set(num, scale > 0L ? (int)scale : 0);
        return decimal;
    }

    @Override
    public long parseLong() {
        long num = 0L;
        boolean negative = false;
        while (true) {
            int b;
            if ((b = this.readUnsignedByteOrThrow()) - -2147483600 <= -2147483639) {
                num = num * 10L + (long)b - 48L;
                continue;
            }
            if (b != 45) break;
            negative = true;
        }
        return negative ? -num : num;
    }

    @Override
    public long parseLong(int base) {
        if (base < 2 || base > 36) {
            throw new IllegalArgumentException("Invalid base:" + base);
        }
        long num = 0L;
        boolean negative = false;
        while (true) {
            int b;
            byte rp;
            if ((rp = RADIX_PARSE[b = this.readUnsignedByteOrThrow()]) >= 0 && rp < base) {
                num = num * (long)base + (long)rp;
                continue;
            }
            if (b != 45) break;
            negative = true;
        }
        return negative ? -num : num;
    }

    private void appendLong0(long num) {
        int endIndex = this.appendLong1(num);
        this.write(this.numberBuffer, endIndex, MAX_NUMBER_LENGTH - endIndex);
    }

    private int appendLong1(long num) {
        this.numberBuffer[19] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 19;
        }
        this.numberBuffer[18] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 18;
        }
        this.numberBuffer[17] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 17;
        }
        this.numberBuffer[16] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 16;
        }
        this.numberBuffer[15] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 15;
        }
        this.numberBuffer[14] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 14;
        }
        this.numberBuffer[13] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 13;
        }
        this.numberBuffer[12] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 12;
        }
        this.numberBuffer[11] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 11;
        }
        this.numberBuffer[10] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 10;
        }
        this.numberBuffer[9] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 9;
        }
        this.numberBuffer[8] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 8;
        }
        this.numberBuffer[7] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 7;
        }
        this.numberBuffer[6] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 6;
        }
        this.numberBuffer[5] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 5;
        }
        this.numberBuffer[4] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 4;
        }
        this.numberBuffer[3] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 3;
        }
        this.numberBuffer[2] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L) {
            return 2;
        }
        this.numberBuffer[1] = (byte)(num % 10L + 48L);
        return 1;
    }

    @Override
    @NotNull
    public ByteStringAppender append(double d, int precision) {
        double d2;
        long power10;
        if (precision < 0) {
            precision = 0;
        }
        if ((power10 = Maths.power10(precision)) < 0L) {
            power10 = 100000000000000000L;
        }
        if (d < 0.0) {
            d = -d;
            this.writeByte(45);
        }
        if ((d2 = d * (double)power10) > 9.223372036854776E18 || d2 < -9.223372036854776E18) {
            return this.append(d);
        }
        long val = (long)(d2 + 0.5);
        while (precision > 1 && val % 10L == 0L) {
            val /= 10L;
            --precision;
        }
        if (precision > 0 && val % 10L == 0L) {
            val = (val + 5L) / 10L;
            --precision;
        }
        if (precision > 0) {
            this.appendDouble0(val, precision);
        } else {
            this.appendLong0(val);
        }
        return this;
    }

    private void appendDouble0(long num, int precision) {
        int endIndex = this.appendDouble1(num, precision);
        this.write(this.numberBuffer, endIndex, MAX_NUMBER_LENGTH - endIndex);
    }

    private int appendDouble1(long num, int precision) {
        int endIndex = MAX_NUMBER_LENGTH;
        int maxEnd = MAX_NUMBER_LENGTH - precision - 2;
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 1) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 2) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 3) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 4) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 5) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 6) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 7) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 8) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 9) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 10) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 11) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 12) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 13) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 14) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 15) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 16) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 17) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        if ((num /= 10L) <= 0L && endIndex <= maxEnd) {
            return endIndex;
        }
        if (precision == 18) {
            this.numberBuffer[--endIndex] = 46;
        }
        this.numberBuffer[--endIndex] = (byte)(num % 10L + 48L);
        return endIndex;
    }

    @Override
    @NotNull
    public ByteStringAppender append(@NotNull MutableDecimal md) {
        StringBuilder sb = this.acquireUtfReader();
        md.toString(sb);
        this.append(sb);
        return this;
    }

    @Override
    @NotNull
    public InputStream inputStream() {
        return new BytesInputStream(this);
    }

    @Override
    @NotNull
    public OutputStream outputStream() {
        return new BytesOutputStream(this);
    }

    @Override
    @NotNull
    public ObjectSerializer objectSerializer() {
        return this.objectSerializer;
    }

    @Override
    public <E> void writeEnum(@Nullable E e) {
        Class aClass = e == null || e instanceof CharSequence ? String.class : e.getClass();
        this.writeInstance(aClass, e);
    }

    @Override
    public <E> E readEnum(@NotNull Class<E> eClass) {
        return this.readInstance(eClass, null);
    }

    @Override
    public <E extends Enum<E>> E parseEnum(@NotNull Class<E> eClass, @NotNull StopCharTester tester) {
        String text = this.parseUTF(tester);
        if (text.isEmpty()) {
            return null;
        }
        return Enum.valueOf(eClass, text);
    }

    @Override
    public <E> void writeList(@NotNull Collection<E> list) {
        this.writeStopBit(list.size());
        for (E e : list) {
            this.writeEnum(e);
        }
    }

    @Override
    public <K, V> void writeMap(@NotNull Map<K, V> map) {
        this.writeStopBit(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.writeEnum(entry.getKey());
            this.writeEnum(entry.getValue());
        }
    }

    @Override
    public <E> void readList(@NotNull Collection<E> list, @NotNull Class<E> eClass) {
        long len = this.readStopBit();
        if (len < 0L || len > Integer.MAX_VALUE) {
            throw new IllegalStateException("Invalid length: " + len);
        }
        list.clear();
        int i = 0;
        while ((long)i < len) {
            E e = this.readEnum(eClass);
            list.add(e);
            ++i;
        }
    }

    @Override
    @NotNull
    public <K, V> Map<K, V> readMap(@NotNull Map<K, V> map, @NotNull Class<K> kClass, @NotNull Class<V> vClass) {
        long len = this.readStopBit();
        if (len < 0L || len > Integer.MAX_VALUE) {
            throw new IllegalStateException("Invalid length: " + len);
        }
        map.clear();
        int i = 0;
        while ((long)i < len) {
            map.put(this.readEnum(kClass), this.readEnum(vClass));
            ++i;
        }
        return map;
    }

    @Override
    public int available() {
        return (int)Math.min(Integer.MAX_VALUE, this.remaining());
    }

    @Override
    public int read() {
        return this.remaining() > 0L ? this.readUnsignedByte() : -1;
    }

    @Override
    public int read(@NotNull byte[] bytes) {
        return this.read(bytes, 0, bytes.length);
    }

    @Override
    public abstract int read(@NotNull byte[] var1, int var2, int var3);

    @Override
    public long skip(long n) {
        if (n < -this.position()) {
            throw new IllegalArgumentException("Skip bytes out of range, was " + n);
        }
        if (n > this.remaining()) {
            n = this.remaining();
        }
        this.position(this.position() + n);
        return n;
    }

    @Override
    public void close() {
        if (!this.isFinished()) {
            this.finish();
        }
    }

    @Override
    public void finish() throws IndexOutOfBoundsException {
        if (this.remaining() < 0L) {
            this.throwOverflow();
        }
        this.finished = true;
    }

    private void throwOverflow() throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException("Buffer overflow, capacity: " + this.capacity() + " position: " + this.position());
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public AbstractBytes clear() {
        this.finished = false;
        this.position(0L);
        this.limit(this.capacity());
        return this;
    }

    @Override
    public Bytes flip() {
        this.limit(this.position());
        this.position(0L);
        return this;
    }

    @Override
    public void flush() {
        this.checkEndOfBuffer();
    }

    @Override
    @Nullable
    public Object readObject() {
        try {
            return this.objectSerializer.readSerializable(this, null, null);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    @Nullable
    public <T> T readObject(Class<T> tClass) throws IllegalStateException {
        Object o = this.readObject();
        if (o == null || tClass.isInstance(o)) {
            return (T)o;
        }
        throw new ClassCastException("Cannot convert " + o.getClass().getName() + " to " + tClass.getName() + " was " + o);
    }

    @Override
    @Nullable
    public <T> T readInstance(@NotNull Class<T> objClass, T obj) {
        try {
            return this.objectSerializer.readSerializable(this, objClass, obj);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void writeObject(@Nullable Object obj) {
        try {
            this.objectSerializer.writeSerializable(this, obj, null);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.checkEndOfBuffer();
    }

    @Override
    public <OBJ> void writeInstance(@NotNull Class<OBJ> objClass, @NotNull OBJ obj) {
        try {
            this.objectSerializer.writeSerializable(this, obj, objClass);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.checkEndOfBuffer();
    }

    @Override
    public boolean tryLockInt(long offset) {
        return this.tryLockNanos4a(offset);
    }

    @Override
    public boolean tryLockNanosInt(long offset, long nanos) {
        int limit = nanos <= 10000L ? (int)nanos / 10 : 1000;
        for (int i = 0; i < limit; ++i) {
            if (!this.tryLockNanos4a(offset)) continue;
            return true;
        }
        if (nanos <= 10000L) {
            return false;
        }
        long end = System.nanoTime() + nanos - 10000L;
        do {
            if (!this.tryLockNanos4a(offset)) continue;
            return true;
        } while (end > System.nanoTime() && !this.currentThread().isInterrupted());
        return false;
    }

    private boolean tryLockNanos4a(long offset) {
        int lowId = this.shortThreadId();
        int firstValue = 0x1000000 | lowId;
        if (this.compareAndSwapInt(offset, 0, firstValue)) {
            return true;
        }
        int currentValue = this.readInt(offset);
        if ((currentValue & INT_LOCK_MASK) == lowId) {
            if (currentValue >>> 24 >= 255) {
                throw new IllegalStateException("Reentered 255 times without an unlock - if you are using this to lock across processes, there could be a thread id conflict letting one process 'steal' the lock from another process. To avoid this, call AffinitySupport.setThreadId() during startup which will make all threads have unique ids");
            }
            this.writeOrderedInt(offset, currentValue += 0x1000000);
            return true;
        }
        return false;
    }

    @Override
    public void busyLockInt(long offset) throws InterruptedException, IllegalStateException {
        boolean success = this.tryLockNanosInt(offset, 20000000000L);
        if (!success) {
            if (this.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            throw new IllegalStateException("Failed to acquire lock after 20.0 seconds.");
        }
    }

    @Override
    public void unlockInt(long offset) throws IllegalMonitorStateException {
        int lowId = this.shortThreadId();
        int firstValue = 0x1000000 | lowId;
        if (this.compareAndSwapInt(offset, firstValue, 0)) {
            return;
        }
        this.unlockFailedInt(offset, lowId);
    }

    @Override
    public void resetLockInt(long offset) {
        this.writeOrderedInt(offset, 0);
    }

    @Override
    public int threadIdForLockInt(long offset) {
        return this.readVolatileInt(offset) & INT_LOCK_MASK;
    }

    int shortThreadId() {
        return this.shortThreadId0();
    }

    int shortThreadId0() {
        int tid = (int)this.getId() & INT_LOCK_MASK;
        if (!ID_LIMIT_WARNED && tid > 0x1000000) {
            AbstractBytes.warnIdLimit(tid);
        }
        return tid;
    }

    Thread currentThread() {
        return Thread.currentThread();
    }

    @Override
    public boolean tryLockLong(long offset) {
        long id = this.uniqueTid();
        return this.tryLockNanos8a(offset, id);
    }

    long uniqueTid() {
        return Jvm.getUniqueTid(this.currentThread());
    }

    @Override
    public boolean tryLockNanosLong(long offset, long nanos) {
        long id = this.uniqueTid();
        int limit = nanos <= 10000L ? (int)nanos / 10 : 1000;
        for (int i = 0; i < limit; ++i) {
            if (!this.tryLockNanos8a(offset, id)) continue;
            return true;
        }
        if (nanos <= 10000L) {
            return false;
        }
        return this.tryLockNanosLong0(offset, nanos, id);
    }

    private boolean tryLockNanosLong0(long offset, long nanos, long id) {
        long nanos0 = Math.min(nanos, 20000000L);
        long start = System.nanoTime();
        long end0 = start + nanos0 - 10000L;
        do {
            if (!this.tryLockNanos8a(offset, id)) continue;
            return true;
        } while (end0 > System.nanoTime() && !this.currentThread().isInterrupted());
        long end = start + nanos - 20000000L;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, Thread.currentThread().getName() + ", waiting for lock");
        }
        try {
            do {
                if (this.tryLockNanos8a(offset, id)) {
                    long millis = (System.nanoTime() - start) / 1000000L;
                    if (millis > 200L) {
                        LOGGER.log(Level.WARNING, Thread.currentThread().getName() + ", to obtain a lock took " + (double)millis / 1000.0 + " seconds");
                    }
                    return true;
                }
                Thread.sleep(1L);
            } while (end > System.nanoTime());
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        return false;
    }

    private boolean tryLockNanos8a(long offset, long id) {
        long firstValue = 0x1000000000000L | id;
        if (this.compareAndSwapLong(offset, 0L, firstValue)) {
            return true;
        }
        long currentValue = this.readLong(offset);
        long lockedId = currentValue & 0xFFFFFFFFFFFFL;
        if (lockedId == 0L) {
            int count = (int)(currentValue >>> 48);
            if (count != 0) {
                LOGGER.log(Level.WARNING, "Lock held by threadId 0 !?");
            }
            return this.compareAndSwapLong(offset, currentValue, firstValue);
        }
        if (lockedId == id) {
            if (currentValue >>> 48 == 65535L) {
                throw new IllegalStateException("Reentered 65535 times without an unlock");
            }
            this.writeOrderedLong(offset, currentValue += 0x1000000000000L);
            return true;
        }
        return false;
    }

    @Override
    public void busyLockLong(long offset) throws InterruptedException, IllegalStateException {
        boolean success = this.tryLockNanosLong(offset, 20000000000L);
        if (!success) {
            if (this.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            throw new IllegalStateException("Failed to acquire lock after 20.0 seconds.");
        }
    }

    @Override
    public void unlockLong(long offset) throws IllegalMonitorStateException {
        long id = Jvm.getUniqueTid();
        long firstValue = 0x1000000000000L | id;
        if (this.compareAndSwapLong(offset, firstValue, 0L)) {
            return;
        }
        this.unlockFailedLong(offset, id);
    }

    @Override
    public void resetLockLong(long offset) {
        this.writeOrderedLong(offset, 0L);
    }

    @Override
    public long threadIdForLockLong(long offset) {
        return this.readVolatileLong(offset);
    }

    long getId() {
        return this.currentThread().getId();
    }

    private void unlockFailedInt(long offset, int lowId) throws IllegalMonitorStateException {
        long currentValue = this.readInt(offset);
        long holderId = currentValue & (long)INT_LOCK_MASK;
        if (holderId == (long)lowId) {
            this.writeOrderedInt(offset, (int)(currentValue -= 0x1000000L));
        } else if (currentValue == 0L) {
            LOGGER.log(Level.WARNING, "No thread holds this lock, threadId: " + this.shortThreadId());
        } else {
            throw new IllegalMonitorStateException("Thread " + holderId + " holds this lock, " + (currentValue >>> 24) + " times");
        }
    }

    private void unlockFailedLong(long offset, long id) throws IllegalMonitorStateException {
        long currentValue = this.readLong(offset);
        long holderId = currentValue & 0xFFFFFFFFFFFFL;
        if (holderId != id) {
            if (currentValue == 0L) {
                throw new IllegalMonitorStateException("No thread holds this lock");
            }
            throw new IllegalMonitorStateException("Process " + (currentValue >>> 32 & 0xFFFFL) + " thread " + (holderId & 0xFFFFFFFFL) + " holds this lock, " + (currentValue >>> 48) + " times, unlock from " + Jvm.getProcessId() + " thread " + this.currentThread().getId());
        }
        this.writeOrderedLong(offset, currentValue -= 0x1000000000000L);
    }

    @Override
    public int getAndAdd(long offset, int delta) {
        int next;
        int current;
        while (!this.compareAndSwapInt(offset, current = this.readVolatileInt(offset), next = current + delta)) {
        }
        return current;
    }

    @Override
    public int addAndGetInt(long offset, int delta) {
        int next;
        int current;
        while (!this.compareAndSwapInt(offset, current = this.readVolatileInt(offset), next = current + delta)) {
        }
        return next;
    }

    @Override
    public byte addByte(long offset, byte b) {
        byte b2 = this.readByte(offset);
        b2 = (byte)(b2 + b);
        this.writeByte(offset, b2);
        return b2;
    }

    @Override
    public int addUnsignedByte(long offset, int i) {
        int b2 = this.readUnsignedByte(offset);
        this.writeUnsignedByte(offset, b2 += i);
        return b2 & 0xFF;
    }

    @Override
    public short addShort(long offset, short s) {
        short s2 = this.readShort(offset);
        s2 = (short)(s2 + s);
        this.writeShort(offset, s2);
        return s2;
    }

    @Override
    public int addUnsignedShort(long offset, int i) {
        int b2 = this.readUnsignedShort(offset);
        this.writeUnsignedShort(offset, b2 += i);
        return b2 & 0xFFFF;
    }

    @Override
    public int addInt(long offset, int i) {
        int b2 = this.readInt(offset);
        this.writeInt(offset, b2 += i);
        return b2;
    }

    @Override
    public long addUnsignedInt(long offset, long i) {
        long b2 = this.readUnsignedInt(offset);
        this.writeUnsignedInt(offset, b2 += i);
        return b2 & 0xFFFFFFFFL;
    }

    @Override
    public long addLong(long offset, long i) {
        long b2 = this.readLong(offset);
        this.writeLong(offset, b2 += i);
        return b2;
    }

    @Override
    public float addFloat(long offset, float f) {
        float b2 = this.readFloat(offset);
        this.writeFloat(offset, b2 += f);
        return b2;
    }

    @Override
    public double addDouble(long offset, double d) {
        double b2 = this.readDouble(offset);
        this.writeDouble(offset, b2 += d);
        return b2;
    }

    @Override
    public int addAtomicInt(long offset, int i) {
        return this.addAndGetInt(offset, i);
    }

    @Override
    public long addAtomicLong(long offset, long delta) {
        long next;
        long current;
        while (!this.compareAndSwapLong(offset, current = this.readVolatileLong(offset), next = current + delta)) {
        }
        return next;
    }

    @Override
    public float addAtomicFloat(long offset, float delta) {
        int next;
        int current;
        while (!this.compareAndSwapInt(offset, current = this.readVolatileInt(offset), next = Float.floatToRawIntBits(Float.intBitsToFloat(current) + delta))) {
        }
        return next;
    }

    @Override
    public double addAtomicDouble(long offset, double delta) {
        long next;
        long current;
        while (!this.compareAndSwapLong(offset, current = this.readVolatileLong(offset), next = Double.doubleToRawLongBits(Double.longBitsToDouble(current) + delta))) {
        }
        return next;
    }

    @Override
    public float readVolatileFloat(long offset) {
        return Float.intBitsToFloat(this.readVolatileInt(offset));
    }

    @Override
    public double readVolatileDouble(long offset) {
        return Double.longBitsToDouble(this.readVolatileLong(offset));
    }

    @Override
    public void writeOrderedFloat(long offset, float v) {
        this.writeOrderedInt(offset, Float.floatToRawIntBits(v));
    }

    @Override
    public void writeOrderedDouble(long offset, double v) {
        this.writeOrderedLong(offset, Double.doubleToRawLongBits(v));
    }

    @Override
    public int length() {
        return (int)Math.min(Integer.MAX_VALUE, this.remaining());
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.length()) {
            throw new IndexOutOfBoundsException();
        }
        return (char)this.readUnsignedByte(this.position() + (long)index);
    }

    @Override
    public void readMarshallable(@NotNull Bytes in) throws IllegalStateException {
        long len = Math.min(this.remaining(), in.remaining());
        long inPosition = in.position();
        this.write(in, inPosition, len);
        in.position(inPosition + len);
    }

    @Override
    public void writeMarshallable(@NotNull Bytes out) {
        out.write(this, this.position(), this.remaining());
    }

    @Override
    public void write(RandomDataInput bytes) {
        long toWrite = bytes.remaining();
        this.write(bytes, bytes.position(), toWrite);
        bytes.skip(toWrite);
    }

    @Override
    public void write(RandomDataInput bytes, long position, long length) {
        if (length > this.remaining()) {
            throw new IllegalArgumentException("Attempt to write " + length + " bytes with " + this.remaining() + " remaining");
        }
        if (bytes.byteOrder() == this.byteOrder()) {
            while (length >= 8L) {
                this.writeLong(bytes.readLong(position));
                position += 8L;
                length -= 8L;
            }
        }
        while (length >= 1L) {
            this.writeByte(bytes.readByte(position));
            ++position;
            --length;
        }
    }

    @Override
    public void write(@NotNull Byteable byteable) {
        if (byteable.bytes() == null) {
            throw new IllegalArgumentException("Attempt to write an unitialized Byteable object");
        }
        this.write(byteable.bytes(), byteable.offset(), (long)byteable.maxSize());
    }

    @Override
    public boolean startsWith(RandomDataInput input) {
        return this.compare(this.position(), input, input.position(), input.remaining());
    }

    @Override
    public boolean compare(long offset, RandomDataInput input, long inputOffset, long len) {
        long i;
        if (offset < 0L || inputOffset < 0L || len < 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (offset + len < 0L || offset + len > this.capacity() || inputOffset + len < 0L || inputOffset + len > input.capacity()) {
            return false;
        }
        for (i = 0L; i < len - 7L; i += 8L) {
            if (this.readLong(offset + i) == input.readLong(inputOffset + i)) continue;
            return false;
        }
        if (i < len - 3L) {
            if (this.readInt(offset + i) != input.readInt(inputOffset + i)) {
                return false;
            }
            i += 4L;
        }
        if (i < len - 1L) {
            if (this.readChar(offset + i) != input.readChar(inputOffset + i)) {
                return false;
            }
            i += 2L;
        }
        return i >= len || this.readByte(offset + i) == input.readByte(inputOffset + i);
    }

    @Override
    @NotNull
    public String toString() {
        long remaining = this.remaining();
        if (remaining < 0L || remaining > 0x1000000000000L) {
            return "invalid remaining: " + this.remaining();
        }
        if (remaining > 0x100000L) {
            remaining = 0x100000L;
        }
        char[] chars = new char[(int)remaining];
        long pos = this.position();
        int i = 0;
        while ((long)i < remaining) {
            chars[i] = (char)this.readUnsignedByte((long)i + pos);
            ++i;
        }
        return new String(chars);
    }

    @Override
    @NotNull
    public String toDebugString() {
        return this.toDebugString(64L);
    }

    @Override
    @NotNull
    public String toDebugString(long limit) {
        StringBuilder sb = new StringBuilder(200);
        sb.append("[pos: ").append(this.position()).append(", lim: ").append(this.limit()).append(", cap: ").append(this.capacity()).append(" ] ");
        this.toString(sb, this.position() - limit, this.position(), this.position() + limit);
        return sb.toString();
    }

    @Override
    public void toString(Appendable sb, long start, long position, long end) {
        try {
            long i;
            if (start < 0L) {
                start = 0L;
            }
            if (position > start) {
                for (i = start; i < position; ++i) {
                    this.append(sb, i);
                }
                sb.append('\u2016');
            }
            if (end > this.limit()) {
                end = this.limit();
            }
            for (i = position; i < end; ++i) {
                this.append(sb, i);
            }
        }
        catch (IOException e) {
            try {
                sb.append(e.toString());
            }
            catch (IOException e1) {
                throw new AssertionError((Object)e);
            }
        }
    }

    @Override
    public ByteBuffer sliceAsByteBuffer(@Nullable ByteBuffer toReuse) {
        throw new UnsupportedOperationException();
    }

    private void append(Appendable sb, long i) throws IOException {
        int b = this.readUnsignedByte(i);
        if (b == 0) {
            sb.append('\u0660');
        } else if (b < 21) {
            sb.append((char)(b + 9351));
        } else {
            sb.append((char)b);
        }
    }

    @Override
    public void asString(Appendable appendable) {
        try {
            for (long i = this.position(); i < this.limit(); ++i) {
                this.append(appendable, i);
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public CharSequence asString() {
        StringBuilder sb = new StringBuilder();
        this.asString(sb);
        return sb;
    }

    @Override
    public boolean compareAndSwapDouble(long offset, double expected, double value) {
        long exp = Double.doubleToRawLongBits(expected);
        long val = Double.doubleToRawLongBits(value);
        return this.compareAndSwapLong(offset, exp, val);
    }

    @Override
    public File file() {
        return null;
    }

    @Override
    public boolean tryRWReadLock(long offset, long timeOutNS) throws IllegalStateException, InterruptedException {
        long lock = this.readVolatileLong(offset);
        int writersWaiting = AbstractBytes.rwWriteWaiting(lock);
        int writersLocked = AbstractBytes.rwWriteLocked(lock);
        if (writersLocked <= 0 && writersWaiting <= 0) {
            int readersLocked = AbstractBytes.rwReadLocked(lock);
            if (readersLocked >= 0x3FFFFFFF) {
                throw new IllegalStateException("readersLocked has reached a limit of " + readersLocked);
            }
            if (this.compareAndSwapLong(offset, lock, lock + 1L)) {
                return true;
            }
        }
        return this.tryRWReadLock0(offset, timeOutNS);
    }

    private boolean tryRWReadLock0(long offset, long timeOutNS) throws IllegalStateException, InterruptedException {
        long end = System.nanoTime() + timeOutNS;
        do {
            long lock = this.readVolatileLong(offset);
            int writersWaiting = AbstractBytes.rwWriteWaiting(lock);
            int writersLocked = AbstractBytes.rwWriteLocked(lock);
            if (writersLocked <= 0 && writersWaiting <= 0) {
                int readersLocked = AbstractBytes.rwReadLocked(lock);
                if (readersLocked >= 0x3FFFFFFF) {
                    throw new IllegalStateException("readersLocked has reached a limit of " + readersLocked);
                }
                if (this.compareAndSwapLong(offset, lock, lock + 1L)) {
                    return true;
                }
            }
            if (System.nanoTime() <= end) continue;
            return false;
        } while (!this.currentThread().isInterrupted());
        throw new InterruptedException("Unable to obtain lock, interrupted");
    }

    @Override
    public boolean tryRWWriteLock(long offset, long timeOutNS) throws IllegalStateException, InterruptedException {
        long lock = this.readVolatileLong(offset);
        int readersLocked = AbstractBytes.rwReadLocked(lock);
        int writersLocked = AbstractBytes.rwWriteLocked(lock);
        if (readersLocked <= 0 && writersLocked <= 0 && this.compareAndSwapLong(offset, lock, lock + 0x1000000000000000L)) {
            return true;
        }
        return this.tryRWWriteLock0(offset, timeOutNS);
    }

    private boolean tryRWWriteLock0(long offset, long timeOutNS) throws IllegalStateException, InterruptedException {
        int writersWaiting;
        long lock;
        boolean interrupted;
        long lock2;
        do {
            int writersWaiting2;
            if ((writersWaiting2 = AbstractBytes.rwWriteWaiting(lock2 = this.readVolatileLong(offset))) < 0x3FFFFFFF) continue;
            throw new IllegalStateException("writersWaiting has reached a limit of " + writersWaiting2);
        } while (!this.compareAndSwapLong(offset, lock2, lock2 + 0x40000000L));
        long end = System.nanoTime() + timeOutNS;
        do {
            lock = this.readVolatileLong(offset);
            int readersLocked = AbstractBytes.rwReadLocked(lock);
            writersWaiting = AbstractBytes.rwWriteWaiting(lock);
            int writersLocked = AbstractBytes.rwWriteLocked(lock);
            if (readersLocked > 0 || writersLocked > 0) continue;
            if (writersWaiting <= 0) {
                System.err.println("writersWaiting has underflowed");
                return false;
            }
            if (!this.compareAndSwapLong(offset, lock, lock + 0x1000000000000000L - 0x40000000L)) continue;
            return true;
        } while (!(interrupted = this.currentThread().isInterrupted()) && System.nanoTime() <= end);
        while (true) {
            if (writersWaiting <= 0) {
                throw new IllegalStateException("writersWaiting has underflowed");
            }
            if (this.compareAndSwapLong(offset, lock, lock - 0x40000000L)) break;
            lock = this.readVolatileLong(offset);
            writersWaiting = AbstractBytes.rwWriteWaiting(lock);
        }
        if (interrupted) {
            throw new InterruptedException("Unable to obtain lock, interrupted");
        }
        return false;
    }

    @Override
    public void unlockRWReadLock(long offset) {
        long lock;
        do {
            int readersLocked;
            if ((readersLocked = AbstractBytes.rwReadLocked(lock = this.readVolatileLong(offset))) > 0) continue;
            throw new IllegalMonitorStateException("readerLock underflow");
        } while (!this.compareAndSwapLong(offset, lock, lock - 1L));
    }

    @Override
    public void unlockRWWriteLock(long offset) {
        long lock;
        do {
            int writersLocked;
            if ((writersLocked = AbstractBytes.rwWriteLocked(lock = this.readVolatileLong(offset))) == 1) continue;
            throw new IllegalMonitorStateException("writersLock underflow " + writersLocked);
        } while (!this.compareAndSwapLong(offset, lock, lock - 0x1000000000000000L));
    }

    String dumpRWLock(long offset) {
        long lock = this.readVolatileLong(offset);
        int readersLocked = AbstractBytes.rwReadLocked(lock);
        int writersWaiting = AbstractBytes.rwWriteWaiting(lock);
        int writersLocked = AbstractBytes.rwWriteLocked(lock);
        return "writerLocked: " + writersLocked + ", writersWaiting: " + writersWaiting + ", readersLocked: " + readersLocked;
    }

    static {
        int i;
        MAX_NUMBER_LENGTH = 1 + (int)Math.ceil(Math.log10(9.223372036854776E18));
        RADIX_PARSE = new byte[256];
        Arrays.fill(RADIX_PARSE, (byte)-1);
        for (i = 0; i < 10; ++i) {
            AbstractBytes.RADIX_PARSE[48 + i] = (byte)i;
        }
        for (i = 0; i < 26; ++i) {
            byte by = (byte)(i + 10);
            AbstractBytes.RADIX_PARSE[97 + i] = by;
            AbstractBytes.RADIX_PARSE[65 + i] = by;
        }
        INT_LOCK_MASK = 0xFFFFFF;
        LOGGER = Logger.getLogger(AbstractBytes.class.getName());
        ISO_8859_1 = Charset.forName("ISO-8859-1");
        MIN_VALUE_TEXT = "-9223372036854775808".getBytes();
        Infinity = "Infinity".getBytes();
        NaN = "NaN".getBytes();
        RADIX = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".getBytes();
        sbp = new StringBuilderPool();
        dateCacheTL = new ThreadLocal();
        ID_LIMIT_WARNED = false;
    }

    static class DateCache {
        final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
        private long lastDay = Long.MIN_VALUE;
        @Nullable
        private byte[] lastDateStr = null;

        DateCache() {
            this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        }

        static /* synthetic */ byte[] access$102(DateCache x0, byte[] x1) {
            x0.lastDateStr = x1;
            return x1;
        }
    }
}

