/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.serialization.impl;

import java.util.Date;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.serialization.CompactBytesMarshaller;
import net.openhft.lang.io.serialization.impl.StringBuilderPool;
import net.openhft.lang.model.constraints.NotNull;
import net.openhft.lang.model.constraints.Nullable;

public class DateMarshaller
implements CompactBytesMarshaller<Date> {
    private final int size1;
    private static final StringBuilderPool sbp = new StringBuilderPool();
    @Nullable
    private Date[] interner = null;

    public DateMarshaller(int size) {
        int size2;
        for (size2 = 128; size2 < size && size2 < 0x100000; size2 <<= 1) {
        }
        this.size1 = size2 - 1;
    }

    private static long parseLong(@NotNull CharSequence sb) {
        long num = 0L;
        boolean negative = false;
        for (int i = 0; i < sb.length(); ++i) {
            char b = sb.charAt(i);
            if (b - -2147483600 <= -2147483639) {
                num = num * 10L + (long)b - 48L;
                continue;
            }
            if (b != '-') break;
            negative = true;
        }
        return negative ? -num : num;
    }

    @Override
    public void write(@NotNull Bytes bytes, @NotNull Date date) {
        long pos = bytes.position();
        bytes.writeUnsignedByte(0);
        bytes.append(date.getTime());
        bytes.writeUnsignedByte(pos, (int)(bytes.position() - 1L - pos));
    }

    @Override
    @Nullable
    public Date read(@NotNull Bytes bytes) {
        StringBuilder sb = sbp.acquireStringBuilder();
        bytes.readUTF\u0394(sb);
        long time = DateMarshaller.parseLong(sb);
        return this.lookupDate(time);
    }

    @Override
    @Nullable
    public Date read(Bytes bytes, @Nullable Date date) {
        if (date == null) {
            return this.read(bytes);
        }
        StringBuilder sb = sbp.acquireStringBuilder();
        bytes.readUTF\u0394(sb);
        long time = DateMarshaller.parseLong(sb);
        date.setTime(time);
        return date;
    }

    @Nullable
    private Date lookupDate(long time) {
        Date date;
        int idx = this.hashFor(time);
        if (this.interner == null) {
            this.interner = new Date[this.size1 + 1];
        }
        if ((date = this.interner[idx]) != null && date.getTime() == time) {
            return date;
        }
        this.interner[idx] = new Date(time);
        return this.interner[idx];
    }

    private int hashFor(long time) {
        long h = time;
        h ^= h >>> 41 ^ h >>> 20;
        h ^= h >>> 14 ^ h >>> 7;
        return (int)(h & (long)this.size1);
    }

    @Override
    public byte code() {
        return 20;
    }
}

