/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import net.openhft.lang.io.MappedMemory;
import net.openhft.lang.model.constraints.NotNull;
import org.slf4j.LoggerFactory;

public class MappedFile {
    private final String filename;
    private final long blockSize;
    private final long overlapSize;
    private final FileChannel fileChannel;
    private final List<MappedMemory> maps = new ArrayList<MappedMemory>();
    private volatile MappedMemory map0;
    private volatile MappedMemory map1;

    public MappedFile(String filename, long blockSize) throws FileNotFoundException {
        this(filename, blockSize, 0L);
    }

    private MappedFile(String filename, long blockSize, long overlapSize) throws FileNotFoundException {
        this.filename = filename;
        this.blockSize = blockSize;
        this.overlapSize = overlapSize;
        this.fileChannel = new RandomAccessFile(filename, "rw").getChannel();
    }

    public String name() {
        return this.filename;
    }

    public static MappedByteBuffer getMap(@NotNull FileChannel fileChannel, long start, int size) throws IOException {
        int i = 1;
        while (true) {
            try {
                MappedByteBuffer map = fileChannel.map(FileChannel.MapMode.READ_WRITE, start, size);
                map.order(ByteOrder.nativeOrder());
                return map;
            }
            catch (IOException e) {
                if (e.getMessage() == null || !e.getMessage().endsWith("user-mapped section open")) {
                    throw e;
                }
                if (i < 10) {
                    Thread.yield();
                } else {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException ignored) {
                        Thread.currentThread().interrupt();
                        throw e;
                    }
                }
                ++i;
                continue;
            }
            break;
        }
    }

    public MappedMemory acquire(long index) throws IOException {
        MappedMemory map0 = this.map0;
        MappedMemory map1 = this.map1;
        if (map0 != null && map0.index() == index) {
            map0.reserve();
            return map0;
        }
        if (map1 != null && map1.index() == index) {
            map1.reserve();
            return map1;
        }
        return this.acquire0(index);
    }

    private synchronized MappedMemory acquire0(long index) throws IOException {
        if (this.map1 != null) {
            this.map1.release();
        }
        this.map1 = this.map0;
        this.map0 = new MappedMemory(this.fileChannel.map(FileChannel.MapMode.READ_WRITE, index * this.blockSize, this.blockSize + this.overlapSize), index);
        this.map0.reserve();
        this.maps.add(this.map0);
        for (int i = this.maps.size() - 1; i >= 0; --i) {
            if (this.maps.get(i).refCount() > 0) continue;
            this.maps.remove(i);
        }
        return this.map0;
    }

    public synchronized void close() throws IOException {
        if (this.map1 != null) {
            this.map1.release();
            this.map1 = null;
        }
        if (this.map0 != null) {
            this.map0.release();
            this.map0 = null;
        }
        int count = 0;
        for (int i = this.maps.size() - 1; i >= 0; --i) {
            if (this.maps.get(i).refCount() > 0) continue;
            this.maps.get(i).close();
            ++count;
        }
        if (count > 1) {
            LoggerFactory.getLogger(MappedFile.class).info("{} memory mappings left unreleased, num= {}", (Object)this.filename, (Object)count);
        }
        this.maps.clear();
        this.fileChannel.close();
    }

    public long size() {
        try {
            return this.fileChannel.size();
        }
        catch (IOException e) {
            return 0L;
        }
    }
}

