/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.model;

import java.io.Externalizable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.openhft.lang.io.serialization.BytesMarshallable;
import net.openhft.lang.model.Byteable;
import net.openhft.lang.model.Copyable;
import net.openhft.lang.model.DataValueModel;
import net.openhft.lang.model.FieldModel;
import net.openhft.lang.model.constraints.Digits;
import net.openhft.lang.model.constraints.MaxSize;
import net.openhft.lang.model.constraints.Range;

public class DataValueModelImpl<T>
implements DataValueModel<T> {
    private static final Map<Class, Integer> HEAP_SIZE_MAP = new HashMap<Class, Integer>();
    private static final String VOLATILE_GETTER_PREFIX = "volatile";
    private static final String ORDERED_SETTER_PREFIX = "ordered";
    private final Map<String, FieldModelImpl> fieldModelMap = new TreeMap<String, FieldModelImpl>();
    private final Class<T> type;
    private final Map<Class, DataValueModel> nestedMap = new HashMap<Class, DataValueModel>();

    public DataValueModelImpl(Class<T> type) {
        Method[] methods;
        this.type = type;
        if (!type.isInterface()) {
            throw new IllegalArgumentException("type must be an interface, was " + type);
        }
        block5: for (Method method : methods = type.getMethods()) {
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass == Object.class || declaringClass == Externalizable.class || declaringClass == BytesMarshallable.class || declaringClass == Copyable.class || declaringClass == Byteable.class) continue;
            String name = method.getName();
            Class<?>[] parameterTypes = method.getParameterTypes();
            Class<?> returnType = method.getReturnType();
            switch (parameterTypes.length) {
                case 0: {
                    FieldModelImpl fm;
                    FieldModelImpl fm2;
                    FieldModelImpl fm3;
                    FieldModelImpl fm4;
                    FieldModelImpl fm5;
                    String name5 = DataValueModelImpl.getUnlock(name);
                    if (name5 != null && returnType == Void.TYPE) {
                        fm5 = this.acquireField(name5);
                        fm5.unlock(method);
                        continue block5;
                    }
                    String name4 = DataValueModelImpl.getBusyLock(name);
                    if (name4 != null && returnType == Void.TYPE) {
                        fm4 = this.acquireField(name4);
                        fm4.busyLock(method);
                        continue block5;
                    }
                    String name3 = DataValueModelImpl.getTryLock(name);
                    if (name3 != null && returnType == Boolean.TYPE) {
                        fm3 = this.acquireField(name3);
                        fm3.tryLock(method);
                        continue block5;
                    }
                    String name6 = DataValueModelImpl.getSizeOf(name);
                    if (name6 != null && returnType == Integer.TYPE) {
                        fm2 = this.acquireField(name6);
                        fm2.sizeOf(method);
                        continue block5;
                    }
                    if (returnType == Void.TYPE) {
                        throw new IllegalArgumentException("void () not supported " + method);
                    }
                    String name2 = DataValueModelImpl.getGetter(name, returnType);
                    if (this.isVolatileGetter(name2)) {
                        fm = this.acquireField(this.volatileGetterFieldName(name2));
                        fm.volatileGetter(method);
                        fm.setVolatile(true);
                        continue block5;
                    }
                    fm = this.acquireField(name2);
                    fm.getter(method);
                    continue block5;
                }
                case 1: {
                    FieldModelImpl fm;
                    FieldModelImpl fm2;
                    FieldModelImpl fm3;
                    FieldModelImpl fm4;
                    FieldModelImpl fm5;
                    String name5 = DataValueModelImpl.getTryLockNanos(name);
                    if (name5 != null && returnType == Boolean.TYPE) {
                        fm5 = this.acquireField(name5);
                        fm5.tryLockNanos(method);
                        continue block5;
                    }
                    String name4 = DataValueModelImpl.getAtomicAdder(name);
                    if (name4 != null) {
                        fm4 = this.acquireField(name4);
                        fm4.atomicAdder(method);
                        continue block5;
                    }
                    String name3 = DataValueModelImpl.getAdder(name);
                    if (name3 != null) {
                        fm3 = this.acquireField(name3);
                        fm3.adder(method);
                        continue block5;
                    }
                    String name6 = DataValueModelImpl.getGetterAt(name, returnType);
                    if (name6 != null && parameterTypes[0] == Integer.TYPE && returnType != Void.TYPE) {
                        if (this.isVolatileGetter(name6)) {
                            fm2 = this.acquireField(this.volatileGetterFieldName(name6));
                            fm2.volatileIndexedGetter(method);
                            fm2.setVolatile(true);
                            continue block5;
                        }
                        fm2 = this.acquireField(name6);
                        fm2.indexedGetter(method);
                        continue block5;
                    }
                    if (returnType != Void.TYPE) {
                        throw new IllegalArgumentException("setter must be void " + method);
                    }
                    String name2 = DataValueModelImpl.getSetter(name);
                    if (this.isOrderedSetter(name2)) {
                        fm = this.acquireField(this.orderedSetterFieldName(name2));
                        fm.orderedSetter(method);
                        continue block5;
                    }
                    fm = this.acquireField(name2);
                    fm.setter(method);
                    continue block5;
                }
                case 2: {
                    FieldModelImpl fm4;
                    FieldModelImpl fm5;
                    String name2 = DataValueModelImpl.getCAS(name);
                    if (name2 != null && returnType == Boolean.TYPE) {
                        fm5 = this.acquireField(name2);
                        fm5.cas(method);
                        continue block5;
                    }
                    String name3 = DataValueModelImpl.getSetterAt(name);
                    if (name3 != null && parameterTypes[0] == Integer.TYPE && returnType == Void.TYPE) {
                        if (this.isOrderedSetter(name3)) {
                            fm4 = this.acquireField(this.orderedSetterFieldName(name3));
                            fm4.orderedIndexedSetter(method);
                            continue block5;
                        }
                        fm4 = this.acquireField(name3);
                        fm4.indexedSetter(method);
                        continue block5;
                    }
                }
                default: {
                    throw new IllegalArgumentException("method not supported " + method);
                }
            }
        }
        for (Map.Entry<String, FieldModelImpl> entry : this.fieldModelMap.entrySet()) {
            FieldModelImpl model = entry.getValue();
            if ((model.getter() == null || model.setter() == null && model.getter().getReturnType().isPrimitive()) && (model.volatileGetter() == null || model.orderedSetter() == null && model.volatileGetter().getReturnType().isPrimitive()) && (model.indexedGetter() == null || model.indexedSetter() == null && model.indexedGetter().getReturnType().isPrimitive()) && (model.volatileIndexedGetter() == null || model.orderedIndexedSetter() == null && model.volatileIndexedGetter().getReturnType().isPrimitive()) && (model.busyLock() == null || model.unlock() == null)) {
                throw new IllegalArgumentException("Field " + entry.getKey() + " must have a getter & setter, or getAt & setAt, or busyLock & unlock.");
            }
            if ((model.indexedGetter() != null || model.indexedSetter() != null) && model.indexSize() == null) {
                throw new IllegalStateException("You must set a MaxSize for the range of the index for the getter or setter");
            }
            Class ftype = model.type();
            if (this.isScalar(ftype) || this.nestedMap.containsKey(ftype)) continue;
            this.nestedMap.put(ftype, new DataValueModelImpl(ftype));
        }
    }

    private boolean isOrderedSetter(String name2) {
        return name2.startsWith(ORDERED_SETTER_PREFIX);
    }

    private boolean isVolatileGetter(String name2) {
        return name2.startsWith(VOLATILE_GETTER_PREFIX);
    }

    private String volatileGetterFieldName(String name) {
        name = name.substring(VOLATILE_GETTER_PREFIX.length());
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    private String orderedSetterFieldName(String name) {
        name = name.substring(ORDERED_SETTER_PREFIX.length());
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    private static String getCAS(String name) {
        int len = 14;
        if (name.length() > 14 && name.startsWith("compareAndSwap") && Character.isUpperCase(name.charAt(14))) {
            return Character.toLowerCase(name.charAt(14)) + name.substring(15);
        }
        return null;
    }

    private static String getSizeOf(String name) {
        int len = 6;
        if (name.length() > 6 && name.startsWith("sizeOf") && Character.isUpperCase(name.charAt(6))) {
            return Character.toLowerCase(name.charAt(6)) + name.substring(7);
        }
        return null;
    }

    private static String getAtomicAdder(String name) {
        int len = 9;
        if (name.length() > 9 && name.startsWith("addAtomic") && Character.isUpperCase(name.charAt(9))) {
            return Character.toLowerCase(name.charAt(9)) + name.substring(10);
        }
        return null;
    }

    private static String getAdder(String name) {
        int len = 3;
        if (name.length() > 3 && name.startsWith("add") && Character.isUpperCase(name.charAt(3))) {
            return Character.toLowerCase(name.charAt(3)) + name.substring(4);
        }
        return null;
    }

    private static String getSetter(String name) {
        int len = 3;
        if (name.length() > 3 && name.startsWith("set") && Character.isUpperCase(name.charAt(3))) {
            return Character.toLowerCase(name.charAt(3)) + name.substring(4);
        }
        return name;
    }

    private static String getSetterAt(String name) {
        int len = 3;
        int len2 = 2;
        if (name.length() > 5 && name.startsWith("set") && Character.isUpperCase(name.charAt(3)) && name.endsWith("At")) {
            return Character.toLowerCase(name.charAt(3)) + name.substring(4, name.length() - 2);
        }
        return name;
    }

    private static String getGetter(String name, Class returnType) {
        if (name.length() > 3 && name.startsWith("get") && Character.isUpperCase(name.charAt(3))) {
            return Character.toLowerCase(name.charAt(3)) + name.substring(4);
        }
        if ((returnType == Boolean.TYPE || returnType == Boolean.class) && name.length() > 2 && name.startsWith("is") && Character.isUpperCase(name.charAt(2))) {
            return Character.toLowerCase(name.charAt(2)) + name.substring(3);
        }
        return name;
    }

    private static String getGetterAt(String name, Class returnType) {
        int len = 3;
        int len2 = 2;
        if (name.length() > 5 && name.startsWith("get") && Character.isUpperCase(name.charAt(3)) && name.endsWith("At")) {
            return Character.toLowerCase(name.charAt(3)) + name.substring(4, name.length() - 2);
        }
        return name;
    }

    private static String getBusyLock(String name) {
        int len = 8;
        if (name.length() > 8 && name.startsWith("busyLock") && Character.isUpperCase(name.charAt(8))) {
            return Character.toLowerCase(name.charAt(8)) + name.substring(9);
        }
        return null;
    }

    private static String getUnlock(String name) {
        int len = 6;
        if (name.length() > 6 && name.startsWith("unlock") && Character.isUpperCase(name.charAt(6))) {
            return Character.toLowerCase(name.charAt(6)) + name.substring(7);
        }
        return null;
    }

    private static String getTryLockNanos(String name) {
        int len = 12;
        if (name.length() > 12 && name.startsWith("tryLockNanos") && Character.isUpperCase(name.charAt(12))) {
            return Character.toLowerCase(name.charAt(12)) + name.substring(13);
        }
        return null;
    }

    private static String getTryLock(String name) {
        int len = 7;
        if (name.length() > 7 && name.startsWith("tryLock") && Character.isUpperCase(name.charAt(7))) {
            return Character.toLowerCase(name.charAt(7)) + name.substring(8);
        }
        return null;
    }

    private FieldModelImpl acquireField(String name) {
        FieldModelImpl fieldModelImpl = this.fieldModelMap.get(name);
        if (fieldModelImpl == null) {
            fieldModelImpl = new FieldModelImpl(name);
            this.fieldModelMap.put(name, fieldModelImpl);
        }
        return fieldModelImpl;
    }

    @Override
    public Map<String, ? extends FieldModel> fieldMap() {
        return this.fieldModelMap;
    }

    @Override
    public boolean isScalar(Class type) {
        return type.isPrimitive() || CharSequence.class.isAssignableFrom(type);
    }

    @Override
    public Set<Class> nestedModels() {
        return this.nestedMap.keySet();
    }

    @Override
    public <N> DataValueModel<N> nestedModel(Class<N> nClass) {
        DataValueModelImpl model = nClass == this.type ? this : this.nestedMap.get(nClass);
        return model;
    }

    @Override
    public Class<T> type() {
        return this.type;
    }

    static {
        HEAP_SIZE_MAP.put(Boolean.TYPE, 1);
        HEAP_SIZE_MAP.put(Byte.TYPE, 8);
        HEAP_SIZE_MAP.put(Character.TYPE, 16);
        HEAP_SIZE_MAP.put(Short.TYPE, 16);
        HEAP_SIZE_MAP.put(Integer.TYPE, 32);
        HEAP_SIZE_MAP.put(Float.TYPE, 32);
        HEAP_SIZE_MAP.put(Long.TYPE, 64);
        HEAP_SIZE_MAP.put(Double.TYPE, 64);
    }

    static class FieldModelImpl<T>
    implements FieldModel<T> {
        private final String name;
        private Method getter;
        private Method setter;
        private Method volatileGetter;
        private Method orderedSetter;
        private Digits digits;
        private Range range;
        private MaxSize maxSize;
        private MaxSize indexSize;
        private Method adder;
        private Method atomicAdder;
        private Method cas;
        private Method tryLockNanos;
        private Method tryLock;
        private Method busyLock;
        private Method unlock;
        private Method getterAt;
        private Method setterAt;
        private Method volatileGetterAt;
        private Method orderedSetterAt;
        private Method sizeOf;
        private boolean isArray = false;
        private boolean isVolatile = false;

        public FieldModelImpl(String name) {
            this.name = name;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public boolean isArray() {
            return this.isArray;
        }

        @Override
        public void setVolatile(boolean isVolatile) {
            this.isVolatile = isVolatile;
        }

        @Override
        public boolean isVolatile() {
            return this.isVolatile;
        }

        public void getter(Method getter) {
            this.getter = getter;
        }

        @Override
        public Method getter() {
            return this.getter;
        }

        public void setter(Method setter) {
            this.setter = setter;
            for (Annotation a : setter.getParameterAnnotations()[0]) {
                if (a instanceof Digits) {
                    this.digits = (Digits)a;
                }
                if (a instanceof Range) {
                    this.range = (Range)a;
                }
                if (!(a instanceof MaxSize)) continue;
                this.maxSize = (MaxSize)a;
            }
        }

        @Override
        public Method setter() {
            return this.setter;
        }

        public void volatileGetter(Method volatileGetter) {
            this.volatileGetter = volatileGetter;
        }

        @Override
        public Method volatileGetter() {
            return this.volatileGetter;
        }

        public void orderedSetter(Method orderedSetter) {
            this.orderedSetter = orderedSetter;
            for (Annotation a : orderedSetter.getParameterAnnotations()[0]) {
                if (a instanceof Digits) {
                    this.digits = (Digits)a;
                }
                if (a instanceof Range) {
                    this.range = (Range)a;
                }
                if (!(a instanceof MaxSize)) continue;
                this.maxSize = (MaxSize)a;
            }
        }

        @Override
        public Method orderedSetter() {
            return this.orderedSetter;
        }

        @Override
        public Class<T> type() {
            return this.getter != null ? this.getter.getReturnType() : (this.volatileGetter != null ? this.volatileGetter.getReturnType() : (this.getterAt != null ? this.getterAt.getReturnType() : (this.volatileGetterAt != null ? this.volatileGetterAt.getReturnType() : (this.unlock != null ? Integer.TYPE : null))));
        }

        public void adder(Method method) {
            this.adder = method;
        }

        @Override
        public Method adder() {
            return this.adder;
        }

        @Override
        public int heapSize() {
            Integer size = (Integer)HEAP_SIZE_MAP.get(this.type());
            if (size == null) {
                return -1;
            }
            return size;
        }

        @Override
        public int nativeSize() {
            Integer size = (Integer)HEAP_SIZE_MAP.get(this.type());
            if (size != null) {
                return size;
            }
            MaxSize maxSize2 = this.size();
            if (maxSize2 == null) {
                throw new AssertionError((Object)(this.type() + " without a @MaxSize not supported for native types"));
            }
            return maxSize2.value() << 3;
        }

        @Override
        public Digits digits() {
            return this.digits;
        }

        @Override
        public Range range() {
            return this.range;
        }

        @Override
        public MaxSize size() {
            return this.maxSize;
        }

        public String toString() {
            return "FieldModel{name='" + this.name + '\'' + ", getter=" + (this.getterAt != null ? this.getterAt : this.getter) + ", setter=" + (this.setterAt != null ? this.setterAt : this.setter) + (this.unlock == null ? "" : ", busyLock=" + this.busyLock + ", tryLock=" + this.tryLock + ", unlock=" + this.unlock) + (this.digits == null ? "" : ", digits= " + this.digits) + (this.range == null ? "" : ", range= " + this.range) + (this.maxSize == null ? "" : ", size= " + this.maxSize) + (this.getterAt == null && this.setterAt == null ? "" : ", indexSize= " + this.indexSize.toString().replace("@net.openhft.lang.model.constraints.", "")) + '}';
        }

        public void atomicAdder(Method method) {
            this.atomicAdder = method;
        }

        @Override
        public Method atomicAdder() {
            return this.atomicAdder;
        }

        public void cas(Method method) {
            this.cas = method;
        }

        @Override
        public Method cas() {
            return this.cas;
        }

        public void sizeOf(Method method) {
            this.sizeOf = method;
        }

        @Override
        public Method sizeOf() {
            return this.sizeOf;
        }

        public void tryLockNanos(Method method) {
            this.tryLockNanos = method;
        }

        @Override
        public Method tryLockNanos() {
            return this.tryLockNanos;
        }

        public void tryLock(Method tryLock) {
            this.tryLock = tryLock;
        }

        @Override
        public Method tryLock() {
            return this.tryLock;
        }

        public void busyLock(Method busyLock) {
            this.busyLock = busyLock;
        }

        @Override
        public Method busyLock() {
            return this.busyLock;
        }

        public void unlock(Method unlock) {
            this.unlock = unlock;
        }

        @Override
        public Method unlock() {
            return this.unlock;
        }

        public void indexSize(MaxSize indexSize) {
            if (indexSize != null) {
                this.indexSize = indexSize;
            }
        }

        @Override
        public MaxSize indexSize() {
            return this.indexSize;
        }

        public void indexedGetter(Method indexedGetter) {
            this.isArray = true;
            this.getterAt = indexedGetter;
            this.indexAnnotations(indexedGetter);
        }

        @Override
        public Method indexedGetter() {
            return this.getterAt;
        }

        public void indexedSetter(Method indexedSetter) {
            this.isArray = true;
            this.setterAt = indexedSetter;
            this.indexAnnotations(indexedSetter);
        }

        @Override
        public Method indexedSetter() {
            return this.setterAt;
        }

        public void indexAnnotations(Method method) {
            for (Annotation a : method.getParameterAnnotations()[0]) {
                if (!(a instanceof MaxSize)) continue;
                this.indexSize = (MaxSize)a;
            }
        }

        public void volatileIndexedGetter(Method volatileIndexedGetter) {
            this.isArray = true;
            this.volatileGetterAt = volatileIndexedGetter;
            this.indexAnnotations(volatileIndexedGetter);
        }

        @Override
        public Method volatileIndexedGetter() {
            return this.volatileGetterAt;
        }

        public void orderedIndexedSetter(Method orderedIndexedSetter) {
            this.isArray = true;
            this.orderedSetterAt = orderedIndexedSetter;
            this.indexAnnotations(orderedIndexedSetter);
        }

        @Override
        public Method orderedIndexedSetter() {
            return this.orderedSetterAt;
        }
    }
}

