/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import net.openhft.compiler.CompilerUtils;
import net.openhft.lang.Compare;
import net.openhft.lang.Maths;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.serialization.BytesMarshallable;
import net.openhft.lang.model.Byteable;
import net.openhft.lang.model.Copyable;
import net.openhft.lang.model.DataValueModel;
import net.openhft.lang.model.DataValueModels;
import net.openhft.lang.model.FieldModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataValueGenerator {
    private static final Comparator<Class> COMPARATOR = new Comparator<Class>(){

        @Override
        public int compare(Class o1, Class o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static final Comparator<Map.Entry<String, FieldModel>> COMPARE_BY_HEAP_SIZE = new Comparator<Map.Entry<String, FieldModel>>(){

        @Override
        public int compare(Map.Entry<String, FieldModel> o1, Map.Entry<String, FieldModel> o2) {
            int cmp = -Maths.compare(o1.getValue().heapSize(), o2.getValue().heapSize());
            return cmp == 0 ? o1.getKey().compareTo(o2.getKey()) : cmp;
        }
    };
    private static final Logger LOGGER = LoggerFactory.getLogger(DataValueGenerator.class);
    private final Map<Class, Class> heapClassMap = new ConcurrentHashMap<Class, Class>();
    private final Map<Class, Class> nativeClassMap = new ConcurrentHashMap<Class, Class>();
    private boolean dumpCode = Boolean.getBoolean("dvg.dumpCode");

    private static String bytesType(Class type) {
        if (type.isPrimitive()) {
            return Character.toUpperCase(type.getName().charAt(0)) + type.getName().substring(1);
        }
        if (CharSequence.class.isAssignableFrom(type)) {
            return "UTF\u0394";
        }
        return "Object";
    }

    static String generateHeapObject(DataValueModel<?> dvmodel) {
        TreeSet<Class> imported = new TreeSet<Class>(COMPARATOR);
        imported.add(BytesMarshallable.class);
        imported.add(Bytes.class);
        imported.add(IOException.class);
        imported.add(Copyable.class);
        imported.add(dvmodel.type());
        StringBuilder fieldDeclarations = new StringBuilder();
        StringBuilder getterSetters = new StringBuilder();
        StringBuilder writeMarshal = new StringBuilder();
        StringBuilder readMarshal = new StringBuilder();
        StringBuilder copy = new StringBuilder();
        Map<String, FieldModel> fieldMap = dvmodel.fieldMap();
        Map.Entry[] entries = fieldMap.entrySet().toArray(new Map.Entry[fieldMap.size()]);
        Arrays.sort(entries, COMPARE_BY_HEAP_SIZE);
        for (Map.Entry entry : entries) {
            Method busyLock;
            Method unlock;
            Method tryLock;
            Method tryLockNanos;
            Method cas;
            Method atomicAdder;
            Method sizeOf;
            Method adder;
            String name = (String)entry.getKey();
            FieldModel model = (FieldModel)entry.getValue();
            Class type = model.type();
            if (!type.isPrimitive() && !type.getPackage().getName().equals("java.lang")) {
                imported.add(type);
            }
            DataValueGenerator.heapFieldDeclarations(fieldDeclarations, type, name, model);
            Method setter = DataValueGenerator.getSetter(model);
            Method getter = DataValueGenerator.getGetter(model);
            boolean bothVolatileAndPlain = false;
            Method orderedSetter = DataValueGenerator.getOrderedSetter(model);
            Method volatileGetter = DataValueGenerator.getVolatileGetter(model);
            if (getter != null && volatileGetter != null) {
                bothVolatileAndPlain = true;
            }
            if (setter == null && orderedSetter != null) {
                setter = orderedSetter;
            }
            if (getter == null && volatileGetter != null) {
                getter = volatileGetter;
            }
            if (setter == null) {
                if (getter != null) {
                    copy.append("        ((Copyable) ").append(getter.getName()).append("()).copyFrom(from.").append(getter.getName()).append("());\n");
                }
            } else {
                DataValueGenerator.methodCopy(copy, getter, setter, model);
                DataValueGenerator.methodHeapSet(getterSetters, setter, name, type, model);
            }
            if (getter != null) {
                DataValueGenerator.methodHeapGet(getterSetters, getter, name, type, model);
            }
            if (bothVolatileAndPlain) {
                DataValueGenerator.methodHeapGet(getterSetters, volatileGetter, name, type, model);
                DataValueGenerator.methodHeapSet(getterSetters, orderedSetter, name, type, model);
            }
            if ((adder = model.adder()) != null) {
                getterSetters.append("    public ").append(DataValueGenerator.normalize(type)).append(' ').append(adder.getName()).append("(").append(adder.getParameterTypes()[0].getName()).append(" $) {\n").append("        return _").append(name).append(" += $;\n").append("    }");
            }
            if ((sizeOf = model.sizeOf()) != null) {
                getterSetters.append("    public int ").append(sizeOf.getName()).append("() {\n").append("        return ").append(model.indexSize().value()).append(";\n").append("    }\n\n");
            }
            if ((atomicAdder = model.atomicAdder()) != null) {
                getterSetters.append("    public synchronized ").append(DataValueGenerator.normalize(type)).append(' ').append(atomicAdder.getName()).append("(").append(atomicAdder.getParameterTypes()[0].getName()).append(" $) {\n").append("        return _").append(name).append(" += $;\n").append("    }\n\n");
            }
            if ((cas = model.cas()) != null) {
                getterSetters.append("    public synchronized boolean ").append(cas.getName()).append("(").append(DataValueGenerator.normalize(type)).append(" _1, ").append(DataValueGenerator.normalize(type)).append(" _2) {\n").append("        if (_").append(name).append(" == _1) {\n").append("            _").append(name).append(" = _2;\n").append("            return true;\n").append("        }\n").append("        return false;\n").append("    }\n");
            }
            if ((tryLockNanos = model.tryLockNanos()) != null) {
                getterSetters.append("    public boolean ").append(tryLockNanos.getName()).append("(long nanos) {\n").append("        throw new UnsupportedOperationException();\n").append("    }");
            }
            if ((tryLock = model.tryLock()) != null) {
                getterSetters.append("    public boolean ").append(tryLock.getName()).append("() {\n").append("        throw new UnsupportedOperationException();\n").append("    }");
            }
            if ((unlock = model.unlock()) != null) {
                getterSetters.append("    public void ").append(unlock.getName()).append("() {\n").append("        throw new UnsupportedOperationException();\n").append("    }");
            }
            if ((busyLock = model.busyLock()) != null) {
                getterSetters.append("    public void ").append(busyLock.getName()).append("() {\n").append("        throw new UnsupportedOperationException();\n").append("    }");
            }
            DataValueGenerator.methodWriteMarshall(writeMarshal, getter, setter, type, model);
            DataValueGenerator.methodHeapReadMarshall(readMarshal, name, type, model);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("package ").append(dvmodel.type().getPackage().getName()).append(";\n\n");
        sb.append("import static ").append(Compare.class.getName()).append(".*;\n");
        for (Class aClass : imported) {
            sb.append("import ").append(DataValueGenerator.normalize(aClass)).append(";\n");
        }
        sb.append("\npublic class ").append(DataValueGenerator.simpleName(dvmodel.type())).append("$$Heap implements ").append(dvmodel.type().getSimpleName()).append(", BytesMarshallable, Copyable<").append(DataValueGenerator.normalize(dvmodel.type())).append(">  {\n");
        sb.append((CharSequence)fieldDeclarations).append('\n');
        sb.append((CharSequence)getterSetters);
        sb.append("    @SuppressWarnings(\"unchecked\")\n    public void copyFrom(").append(DataValueGenerator.normalize(dvmodel.type())).append(" from) {\n");
        sb.append((CharSequence)copy);
        sb.append("    }\n\n");
        sb.append("    public void writeMarshallable(Bytes out) {\n");
        sb.append((CharSequence)writeMarshal);
        sb.append("    }\n");
        sb.append("    public void readMarshallable(Bytes in) {\n");
        sb.append((CharSequence)readMarshal);
        sb.append("    }\n");
        if (Byteable.class.isAssignableFrom(dvmodel.type())) {
            sb.append("    public void bytes(Bytes bytes, long l) {\n");
            sb.append("       throw new UnsupportedOperationException();\n");
            sb.append("    }\n");
            sb.append("    public Bytes bytes() {\n");
            sb.append("       return null;\n");
            sb.append("    }\n");
            sb.append("    public long offset() {\n");
            sb.append("       return 0L;\n");
            sb.append("    }\n");
            sb.append("    public int maxSize() {\n");
            sb.append("       throw new UnsupportedOperationException();\n");
            sb.append("    }\n");
        }
        DataValueGenerator.generateObjectMethods(sb, dvmodel, entries, false);
        sb.append("}\n");
        return sb.toString();
    }

    private static String simpleName(Class<?> type) {
        String name = type.getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    private static CharSequence normalize(Class aClass) {
        return aClass.getName().replace('$', '.');
    }

    private static void generateObjectMethods(StringBuilder sb, DataValueModel<?> dvmodel, Map.Entry<String, FieldModel>[] entries, boolean offHeap) {
        int count = 0;
        StringBuilder hashCode = new StringBuilder();
        StringBuilder equals = new StringBuilder();
        StringBuilder toString = new StringBuilder();
        for (Map.Entry<String, FieldModel> entry : entries) {
            String name = entry.getKey();
            FieldModel model = entry.getValue();
            Method getter = DataValueGenerator.getGetter(model);
            if (getter == null) {
                getter = DataValueGenerator.getVolatileGetter(model);
            }
            if (getter != null) {
                String getterName = getter.getName();
                DataValueGenerator.methodLongHashCode(hashCode, getterName, model, count);
                DataValueGenerator.methodEquals(equals, getterName, model);
                DataValueGenerator.methodToString(toString, getterName, name, model);
                ++count;
            }
            if (!model.isArray()) continue;
            String nameWithUpper = Character.toUpperCase(name.charAt(0)) + name.substring(1);
            if (model.isVolatile()) {
                nameWithUpper = "Volatile" + nameWithUpper;
            }
            sb.append("\n    public long longHashCode_" + name + "() {\n" + "        long hc = 0;\n" + "        for (int i = 0; i < " + model.indexSize().value() + "; i++) {\n" + "            hc += calcLongHashCode(get" + nameWithUpper + "At(i));\n" + "        }\n" + "        return hc;\n" + "    }\n\n");
        }
        sb.append("    public int hashCode() {\n        long lhc = longHashCode();\n        return (int) ((lhc >>> 32) ^ lhc);\n    }\n\n    public long longHashCode() {\n        return ");
        for (int i = 1; i < count; ++i) {
            sb.append('(');
        }
        sb.append((CharSequence)hashCode);
        String simpleName = DataValueGenerator.simpleName(dvmodel.type()).replace('$', '.');
        sb.append(";\n").append("    }\n").append("\n");
        sb.append("    public boolean equals(Object o) {\n").append("        if (this == o) return true;\n").append("        if (!(o instanceof ").append((CharSequence)simpleName).append(")) return false;\n").append("        ").append((CharSequence)simpleName).append(" that = (").append((CharSequence)simpleName).append(") o;\n").append("\n").append((CharSequence)equals).append("        return true;\n").append("    }\n").append("\n");
        sb.append("    public String toString() {\n").append(offHeap ? "        if (_bytes == null) return \"bytes is null\";\n" : "").append("        StringBuilder sb = new StringBuilder();\n").append("        sb.append(\"").append((CharSequence)simpleName).append("{ \");\n").append((CharSequence)toString).append("        sb.append(\" }\");\n").append("        return sb.toString();\n").append("    }\n");
    }

    private static Method getGetter(FieldModel model) {
        Method getter = model.getter();
        if (getter == null) {
            getter = model.indexedGetter();
        }
        return getter;
    }

    private static Method getVolatileGetter(FieldModel model) {
        Method getter = model.volatileGetter();
        if (getter == null) {
            getter = model.volatileIndexedGetter();
        }
        return getter;
    }

    private static Method getSetter(FieldModel model) {
        Method setter = model.setter();
        if (setter == null) {
            setter = model.indexedSetter();
        }
        return setter;
    }

    private static Method getOrderedSetter(FieldModel model) {
        Method setter = model.orderedSetter();
        if (setter == null) {
            setter = model.orderedIndexedSetter();
        }
        return setter;
    }

    private static void methodCopy(StringBuilder copy, Method getter, Method setter, FieldModel model) {
        if (!model.isArray()) {
            if (model.setter() != null && getter != null) {
                copy.append("        ").append(setter.getName());
                copy.append("(from.").append(getter.getName()).append("());\n");
            }
        } else {
            copy.append("        for (int i = 0; i < ").append(model.indexSize().value()).append("; i++){");
            copy.append("\n            ").append(setter.getName()).append("(i, from.").append(getter.getName()).append("(i));\n");
            copy.append("        }\n");
        }
    }

    private static void methodWriteMarshall(StringBuilder writeMarshal, Method getter, Method setter, Class type, FieldModel model) {
        if (!model.isArray()) {
            if (getter != null && setter != null) {
                writeMarshal.append("        out.write").append(DataValueGenerator.bytesType(type)).append("(").append(getter.getName()).append("());\n");
            }
        } else {
            writeMarshal.append("        for (int i = 0; i < ").append(model.indexSize().value()).append("; i++){\n");
            writeMarshal.append("            out.write").append(DataValueGenerator.bytesType(type)).append("(").append(getter.getName()).append("(i));\n");
            writeMarshal.append("        }\n");
        }
    }

    private static void methodHeapReadMarshall(StringBuilder readMarshal, String name, Class type, FieldModel model) {
        if (!model.isArray()) {
            readMarshal.append("        _").append(name).append(" = in.read").append(DataValueGenerator.bytesType(type)).append("(");
            if ("Object".equals(DataValueGenerator.bytesType(type))) {
                readMarshal.append(DataValueGenerator.normalize(type)).append(".class");
            }
            readMarshal.append(");\n");
        } else {
            readMarshal.append("        for (int i = 0; i < ").append(model.indexSize().value()).append("; i++){\n");
            readMarshal.append("            _").append(name).append("[i] = in.read").append(DataValueGenerator.bytesType(type)).append("(");
            if ("Object".equals(DataValueGenerator.bytesType(type))) {
                readMarshal.append(DataValueGenerator.normalize(type)).append(".class");
            }
            readMarshal.append(");\n");
            readMarshal.append("        }\n");
        }
    }

    private static void methodLongHashCode(StringBuilder hashCode, String getterName, FieldModel model, int count) {
        if (count > 0) {
            hashCode.append(") * 10191 +\n            ");
        }
        if (!model.isArray()) {
            hashCode.append("calcLongHashCode(").append(getterName).append("())");
        } else {
            hashCode.append("longHashCode_").append(model.name()).append("()");
        }
    }

    private static void methodEquals(StringBuilder equals, String getterName, FieldModel model) {
        if (!model.isArray()) {
            equals.append("        if(!isEqual(").append(getterName).append("(), that.").append(getterName).append("())) return false;\n");
        } else {
            equals.append("        for (int i = 0; i <" + model.indexSize().value() + "; i++) {\n");
            equals.append("            if(!isEqual(").append(getterName).append("(i), that.").append(getterName).append("(i))) return false;\n");
            equals.append("        }\n");
        }
    }

    private static void methodToString(StringBuilder toString, String getterName, String name, FieldModel model) {
        if (toString.length() > 2) {
            toString.append("sb.append(\", \")\n;");
        }
        if (!model.isArray()) {
            toString.append("            sb.append(\"").append(name).append("= \").append(").append(getterName).append("());\n");
        } else {
            toString.append("              sb.append(\"").append(name).append("\").append(\"= [\");").append("              for (int i = 0; i < ").append(model.indexSize().value()).append("; i++) {\n").append("                  if (i > 0) sb.append(\", \") ;\n").append("                  sb.append(").append(getterName).append("(i));\n").append("              }\n").append("              sb.append(\"]\");\n");
        }
    }

    private static void methodHeapSet(StringBuilder getterSetters, Method setter, String name, Class type, FieldModel model) {
        Class<?> setterType = setter.getParameterTypes()[setter.getParameterTypes().length - 1];
        if (!model.isArray()) {
            getterSetters.append("    public void ").append(setter.getName()).append('(').append(DataValueGenerator.normalize(setterType)).append(" $) {\n");
            if (type == String.class && setterType != String.class) {
                getterSetters.append("        _").append(name).append(" = $.toString();\n");
            } else {
                getterSetters.append("        _").append(name).append(" = $;\n");
            }
        } else {
            getterSetters.append("    public void ").append(setter.getName()).append("(int i, ").append(DataValueGenerator.normalize(setterType)).append(" $) {\n");
            getterSetters.append(DataValueGenerator.boundsCheck(model.indexSize().value()));
            if (type == String.class && setterType != String.class) {
                getterSetters.append("        _").append(name).append("[i] = $.toString();\n");
            } else {
                getterSetters.append("        _").append(name).append("[i] = $;\n");
            }
        }
        getterSetters.append("    }\n\n");
    }

    private static void methodHeapGet(StringBuilder getterSetters, Method getter, String name, Class type, FieldModel model) {
        if (!model.isArray()) {
            getterSetters.append("    public ").append(DataValueGenerator.normalize(type)).append(' ').append(getter.getName()).append("() {\n");
            getterSetters.append("        return _").append(name).append(";\n");
        } else {
            getterSetters.append("    public ").append(DataValueGenerator.normalize(type)).append(' ').append(getter.getName()).append("(int i) {\n");
            getterSetters.append(DataValueGenerator.boundsCheck(model.indexSize().value()));
            getterSetters.append("        return _").append(name).append("[i];\n");
        }
        getterSetters.append("    }\n\n");
    }

    private static void heapFieldDeclarations(StringBuilder fieldDeclarations, Class type, String name, FieldModel model) {
        String vol = "";
        if (model.isVolatile()) {
            vol = "volatile ";
        }
        if (!model.isArray()) {
            fieldDeclarations.append("    private ").append(vol).append(DataValueGenerator.normalize(type)).append(" _").append(name).append(";\n");
        } else {
            fieldDeclarations.append("    private ").append(vol).append(DataValueGenerator.normalize(type)).append("[] _").append(name).append(" = new ").append(DataValueGenerator.normalize(type)).append("[").append(model.indexSize().value()).append("];\n");
            if (!type.isPrimitive()) {
                fieldDeclarations.append("    {\n").append("        for (int i = 0; i < _").append(name).append(".length; i++)\n").append("            _").append(name).append("[i] = new ").append(type.getName());
                if (type.isInterface()) {
                    fieldDeclarations.append("$$Heap();\n");
                } else {
                    fieldDeclarations.append("();\n");
                }
                fieldDeclarations.append("    }");
            }
        }
    }

    private static String boundsCheck(int check) {
        return "        if(i<0) throw new ArrayIndexOutOfBoundsException(i + \" must be greater than 0\");\n        if(i>=" + check + ") throw new ArrayIndexOutOfBoundsException(i + \" must be less than " + check + "\");\n";
    }

    public <T> T heapInstance(Class<T> tClass) {
        try {
            return this.acquireHeapClass(tClass).newInstance();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public <T> Class acquireHeapClass(Class<T> tClass) {
        Class heapClass = this.heapClassMap.get(tClass);
        if (heapClass != null) {
            return heapClass;
        }
        ClassLoader classLoader = tClass.getClassLoader();
        String className = tClass.getName() + "$$Heap";
        try {
            heapClass = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException ignored) {
            try {
                String actual = this.generateHeapObject(tClass);
                if (this.dumpCode) {
                    LOGGER.info(actual);
                }
                heapClass = CompilerUtils.CACHED_COMPILER.loadFromJava(classLoader, className, actual);
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }
        this.heapClassMap.put(tClass, heapClass);
        return heapClass;
    }

    String generateHeapObject(Class<?> tClass) {
        DataValueModel<?> dvmodel = DataValueModels.acquireModel(tClass);
        for (FieldModel fieldModel : dvmodel.fieldMap().values()) {
            if (!fieldModel.isArray() || fieldModel.type().isPrimitive()) continue;
            this.acquireHeapClass(fieldModel.type());
        }
        return DataValueGenerator.generateHeapObject(dvmodel);
    }

    public <T> T nativeInstance(Class<T> tClass) {
        try {
            return this.acquireNativeClass(tClass).newInstance();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public <T> Class acquireNativeClass(Class<T> tClass) {
        Class nativeClass = this.nativeClassMap.get(tClass);
        if (nativeClass != null) {
            return nativeClass;
        }
        DataValueModel<T> dvmodel = DataValueModels.acquireModel(tClass);
        for (Class clazz : dvmodel.nestedModels()) {
            Class clazz2 = this.acquireNativeClass(clazz);
        }
        String actual = new DataValueGenerator().generateNativeObject(dvmodel);
        if (this.dumpCode) {
            LOGGER.info(actual);
        }
        ClassLoader classLoader = tClass.getClassLoader();
        String className = tClass.getName() + "$$Native";
        try {
            nativeClass = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException ignored) {
            try {
                nativeClass = CompilerUtils.CACHED_COMPILER.loadFromJava(classLoader, className, actual);
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }
        this.nativeClassMap.put(tClass, nativeClass);
        return nativeClass;
    }

    public String generateNativeObject(Class<?> tClass) {
        return this.generateNativeObject(DataValueModels.acquireModel(tClass));
    }

    public String generateNativeObject(DataValueModel<?> dvmodel) {
        TreeSet<Class> imported = new TreeSet<Class>(COMPARATOR);
        imported.add(BytesMarshallable.class);
        imported.add(ObjectOutput.class);
        imported.add(ObjectInput.class);
        imported.add(IOException.class);
        imported.add(Copyable.class);
        imported.add(Byteable.class);
        imported.add(Bytes.class);
        StringBuilder staticFieldDeclarations = new StringBuilder();
        StringBuilder fieldDeclarations = new StringBuilder();
        StringBuilder getterSetters = new StringBuilder();
        StringBuilder writeMarshal = new StringBuilder();
        StringBuilder readMarshal = new StringBuilder();
        StringBuilder copy = new StringBuilder();
        StringBuilder nestedBytes = new StringBuilder();
        Map<String, FieldModel> fieldMap = dvmodel.fieldMap();
        Map.Entry[] entries = fieldMap.entrySet().toArray(new Map.Entry[fieldMap.size()]);
        Arrays.sort(entries, COMPARE_BY_HEAP_SIZE);
        int offset = 0;
        for (Map.Entry entry : entries) {
            Method defaultGetter;
            String name = (String)entry.getKey();
            FieldModel model = (FieldModel)entry.getValue();
            Class type = model.type();
            if (!type.isPrimitive() && !type.getPackage().getName().equals("java.lang")) {
                imported.add(type);
            }
            String NAME = "_offset + " + name.toUpperCase();
            Method setter = DataValueGenerator.getSetter(model);
            Method getter = DataValueGenerator.getGetter(model);
            Method orderedSetter = DataValueGenerator.getOrderedSetter(model);
            Method volatileGetter = DataValueGenerator.getVolatileGetter(model);
            Method defaultSetter = setter != null ? setter : orderedSetter;
            Method method = defaultGetter = getter != null ? getter : volatileGetter;
            if (dvmodel.isScalar(type)) {
                Method busyLock;
                Method unlock;
                Method tryLock;
                Method tryLockNanos;
                Method cas;
                Method sizeOf;
                Method atomicAdder;
                Method adder;
                staticFieldDeclarations.append("    private static final int ").append(name.toUpperCase()).append(" = ").append(offset).append(";\n");
                DataValueGenerator.methodCopy(copy, defaultGetter, defaultSetter, model);
                if (setter != null) {
                    this.methodSet(getterSetters, setter, type, NAME, model, false);
                }
                if (getter != null) {
                    this.methodGet(getterSetters, getter, type, NAME, model, false);
                }
                if (orderedSetter != null) {
                    this.methodSet(getterSetters, orderedSetter, type, NAME, model, true);
                }
                if (volatileGetter != null) {
                    this.methodGet(getterSetters, volatileGetter, type, NAME, model, true);
                }
                if ((adder = model.adder()) != null) {
                    getterSetters.append("    public ").append(DataValueGenerator.normalize(type)).append(' ').append(adder.getName()).append("(").append(adder.getParameterTypes()[0].getName()).append(" $) {\n").append("        return _bytes.add").append(DataValueGenerator.bytesType(type)).append("(").append(NAME).append(", $);\n").append("    }");
                }
                if ((atomicAdder = model.atomicAdder()) != null) {
                    getterSetters.append("    public ").append(DataValueGenerator.normalize(type)).append(' ').append(atomicAdder.getName()).append("(").append(atomicAdder.getParameterTypes()[0].getName()).append(" $) {\n").append("        return _bytes.addAtomic").append(DataValueGenerator.bytesType(type)).append("(").append(NAME).append(", $);\n").append("    }");
                }
                if ((sizeOf = model.sizeOf()) != null) {
                    getterSetters.append("    public int ").append(sizeOf.getName()).append("() {\n").append("        return ").append(model.indexSize().value()).append(";\n").append("    }\n\n");
                }
                if ((cas = model.cas()) != null) {
                    getterSetters.append("    public boolean ").append(cas.getName()).append("(").append(DataValueGenerator.normalize(type)).append(" _1, ").append(DataValueGenerator.normalize(type)).append(" _2) {\n").append("        return _bytes.compareAndSwap").append(DataValueGenerator.bytesType(type)).append('(').append(NAME).append(", _1, _2);\n").append("    }");
                }
                if ((tryLockNanos = model.tryLockNanos()) != null) {
                    getterSetters.append("    public boolean ").append(tryLockNanos.getName()).append("(long nanos) {\n").append("        return _bytes.tryLockNanos").append(DataValueGenerator.bytesType(type)).append('(').append(NAME).append(", nanos);\n").append("    }");
                }
                if ((tryLock = model.tryLock()) != null) {
                    getterSetters.append("    public boolean ").append(tryLock.getName()).append("() {\n").append("        return _bytes.tryLock").append(DataValueGenerator.bytesType(type)).append('(').append(NAME).append(");\n").append("    }");
                }
                if ((unlock = model.unlock()) != null) {
                    getterSetters.append("    public void ").append(unlock.getName()).append("() {\n").append("         _bytes.unlock").append(DataValueGenerator.bytesType(type)).append('(').append(NAME).append(");\n").append("    }");
                }
                if ((busyLock = model.busyLock()) != null) {
                    getterSetters.append("    public void ").append(busyLock.getName()).append("() throws InterruptedException {\n").append("         _bytes.busyLock").append(DataValueGenerator.bytesType(type)).append('(').append(NAME).append(");\n").append("    }");
                }
                DataValueGenerator.methodWriteMarshall(writeMarshal, defaultGetter, defaultSetter, type, model);
                this.methodReadMarshall(readMarshal, defaultGetter, defaultSetter, type, model);
                offset += this.computeOffset(model.nativeSize() + 7 >> 3, model);
                continue;
            }
            staticFieldDeclarations.append("    private static final int ").append(name.toUpperCase()).append(" = ").append(offset).append(";\n");
            this.nonScalarFieldDeclaration(staticFieldDeclarations, type, name, model);
            if (defaultSetter == null) {
                copy.append("        _").append(name).append(".copyFrom(from.").append(getter.getName()).append("());\n");
            } else {
                DataValueGenerator.methodCopy(copy, defaultGetter, defaultSetter, model);
                this.methodNonScalarSet(getterSetters, defaultSetter, name, type, model);
            }
            int size = this.computeNonScalarOffset(dvmodel, type);
            this.methodNonScalarGet(getterSetters, getter, name, type, model);
            this.methodNonScalarWriteMarshall(writeMarshal, name, model);
            this.methodNonScalarReadMarshall(readMarshal, name, model);
            this.methodNonScalarBytes(nestedBytes, name, NAME, size, model);
            offset += this.computeOffset(size, model);
        }
        fieldDeclarations.append("\n").append("    private Bytes _bytes;\n").append("    private long _offset;\n");
        StringBuilder sb = new StringBuilder();
        sb.append("package ").append(dvmodel.type().getPackage().getName()).append(";\n\n");
        sb.append("import static ").append(Compare.class.getName()).append(".*;\n");
        for (Class aClass : imported) {
            sb.append("import ").append(aClass.getName().replace('$', '.')).append(";\n");
        }
        sb.append("\npublic class ").append(DataValueGenerator.simpleName(dvmodel.type())).append("$$Native implements ").append(DataValueGenerator.simpleName(dvmodel.type()).replace('$', '.')).append(", BytesMarshallable, Byteable, Copyable<").append(DataValueGenerator.normalize(dvmodel.type())).append("> {\n");
        sb.append((CharSequence)staticFieldDeclarations).append('\n');
        sb.append((CharSequence)fieldDeclarations).append('\n');
        sb.append((CharSequence)getterSetters);
        sb.append("    @Override\n").append("    public void copyFrom(").append(DataValueGenerator.normalize(dvmodel.type())).append(" from) {\n").append((CharSequence)copy).append("    }\n\n");
        sb.append("    @Override\n").append("    public void writeMarshallable(Bytes out) {\n").append((CharSequence)writeMarshal).append("    }\n");
        sb.append("    @Override\n").append("    public void readMarshallable(Bytes in) {\n").append((CharSequence)readMarshal).append("    }\n");
        sb.append("    @Override\n").append("    public void bytes(Bytes bytes, long offset) {\n").append("       this._bytes = bytes;\n").append("       this._offset = offset;\n").append((CharSequence)nestedBytes).append("    }\n");
        sb.append("    @Override\n").append("    public Bytes bytes() {\n").append("       return _bytes;\n").append("    }\n");
        sb.append("    @Override\n").append("    public long offset() {\n").append("        return _offset;\n").append("    }\n");
        sb.append("    @Override\n").append("    public int maxSize() {\n").append("       return ").append(offset).append(";\n").append("    }\n");
        DataValueGenerator.generateObjectMethods(sb, dvmodel, entries, true);
        sb.append("}\n");
        return sb.toString();
    }

    public boolean isDumpCode() {
        return this.dumpCode;
    }

    public void setDumpCode(boolean dumpCode) {
        this.dumpCode = dumpCode;
    }

    private void methodSet(StringBuilder getterSetters, Method setter, Class type, String NAME, FieldModel model, boolean isVolatile) {
        Class<?> setterType = setter.getParameterTypes()[setter.getParameterTypes().length - 1];
        String write = "write";
        if (isVolatile) {
            write = "writeOrdered";
        }
        if (!model.isArray()) {
            getterSetters.append("\n\n    public void ").append(setter.getName()).append('(').append(DataValueGenerator.normalize(setterType)).append(" $) {\n");
            getterSetters.append("        _bytes.").append(write).append(DataValueGenerator.bytesType(type)).append("(").append(NAME).append(", ");
        } else {
            getterSetters.append("    public void ").append(setter.getName()).append("(int i, ");
            getterSetters.append(DataValueGenerator.normalize(setterType)).append(" $) {\n");
            getterSetters.append(DataValueGenerator.boundsCheck(model.indexSize().value()));
            getterSetters.append("        _bytes.").append(write).append(DataValueGenerator.bytesType(type)).append("(").append(NAME);
            getterSetters.append(" + i * ").append(model.nativeSize() + 7 >> 3).append(", ");
        }
        if (CharSequence.class.isAssignableFrom(type)) {
            getterSetters.append(model.size().value()).append(", ");
        }
        getterSetters.append("$);\n");
        getterSetters.append("    }\n\n");
    }

    private void methodGet(StringBuilder getterSetters, Method getter, Class type, String NAME, FieldModel model, boolean isVolatile) {
        String read = "read";
        if (isVolatile) {
            read = "readVolatile";
        }
        if (!model.isArray()) {
            getterSetters.append("    public ").append(DataValueGenerator.normalize(type)).append(' ').append(getter.getName()).append("() {\n");
            getterSetters.append("        return _bytes.").append(read).append(DataValueGenerator.bytesType(type)).append("(").append(NAME).append(");\n");
        } else {
            getterSetters.append("    public ").append(DataValueGenerator.normalize(type)).append(' ').append(getter.getName()).append("(int i) {\n");
            getterSetters.append(DataValueGenerator.boundsCheck(model.indexSize().value()));
            getterSetters.append("        return _bytes.").append(read).append(DataValueGenerator.bytesType(type)).append("(").append(NAME);
            getterSetters.append(" + i * ").append(model.nativeSize() + 7 >> 3);
            getterSetters.append(");\n");
        }
        getterSetters.append("    }\n\n");
    }

    private void methodNonScalarWriteMarshall(StringBuilder writeMarshal, String name, FieldModel model) {
        if (!model.isArray()) {
            writeMarshal.append("         _").append(name).append(".writeMarshallable(out);\n");
        } else {
            writeMarshal.append("        for (int i = 0; i < ").append(model.indexSize().value()).append("; i++){\n");
            writeMarshal.append("            _").append(name).append("[i].writeMarshallable(out);\n");
            writeMarshal.append("        }\n");
        }
    }

    private void methodReadMarshall(StringBuilder readMarshal, Method getter, Method setter, Class type, FieldModel model) {
        if (!model.isArray()) {
            if (getter != null && setter != null) {
                readMarshal.append("        ").append(setter.getName()).append("(in.read").append(DataValueGenerator.bytesType(type)).append("());\n");
            }
        } else {
            readMarshal.append("        for (int i = 0; i < ").append(model.indexSize().value()).append("; i++){\n");
            readMarshal.append("            ").append(setter.getName()).append("(i, in.read").append(DataValueGenerator.bytesType(type)).append("());\n");
            readMarshal.append("        }\n");
        }
    }

    private void methodNonScalarReadMarshall(StringBuilder readMarshal, String name, FieldModel model) {
        if (!model.isArray()) {
            readMarshal.append("         _").append(name).append(".readMarshallable(in);\n");
        } else {
            readMarshal.append("        for (int i = 0; i < ").append(model.indexSize().value()).append("; i++){\n");
            readMarshal.append("            _").append(name).append("[i].readMarshallable(in);\n");
            readMarshal.append("        }\n");
        }
    }

    private int computeOffset(int offset, FieldModel model) {
        if (model.indexSize() == null) {
            return offset;
        }
        return model.indexSize().value() * offset;
    }

    private void nonScalarFieldDeclaration(StringBuilder fieldDeclarations, Class type, String name, FieldModel model) {
        fieldDeclarations.append("    private final ").append(type.getName()).append("$$Native _").append(name);
        if (!model.isArray()) {
            fieldDeclarations.append(" = new ").append(type.getName()).append("$$Native();\n");
        } else {
            fieldDeclarations.append("[] = new ").append(type.getName()).append("$$Native[").append(model.indexSize().value()).append("];\n");
            fieldDeclarations.append("    {\n").append("        for (int i = 0; i < ").append(model.indexSize().value()).append("; i++)\n").append("            _").append(name).append("[i] = new ").append(type.getName()).append("$$Native();\n").append("    }\n");
        }
    }

    private void methodNonScalarSet(StringBuilder getterSetters, Method setter, String name, Class type, FieldModel model) {
        Class<?> setterType = setter.getParameterTypes()[setter.getParameterTypes().length - 1];
        if (!model.isArray()) {
            getterSetters.append("    public void ").append(setter.getName()).append('(').append(DataValueGenerator.normalize(setterType)).append(" $) {\n");
            if (type == String.class && setterType != String.class) {
                getterSetters.append("        _").append(name).append(" = $.toString();\n");
            } else {
                getterSetters.append("        _").append(name).append(".copyFrom($);\n");
            }
        } else {
            getterSetters.append("    public void ").append(setter.getName()).append("(int i, ").append(DataValueGenerator.normalize(setterType)).append(" $) {\n");
            if (type == String.class && setterType != String.class) {
                getterSetters.append("        _").append(name).append("[i] = $.toString();\n");
            } else {
                getterSetters.append("        _").append(name).append("[i].copyFrom($);\n");
            }
        }
        getterSetters.append("    }\n\n");
    }

    private void methodNonScalarGet(StringBuilder getterSetters, Method getter, String name, Class type, FieldModel model) {
        if (!model.isArray()) {
            getterSetters.append("    public ").append(DataValueGenerator.normalize(type)).append(' ').append(getter.getName()).append("() {\n");
            getterSetters.append("        return _").append(name).append(";\n");
        } else {
            getterSetters.append("    public ").append(DataValueGenerator.normalize(type)).append(' ').append(getter.getName()).append("(int i) {\n");
            getterSetters.append("        return _").append(name).append("[i];\n");
        }
        getterSetters.append("    }\n\n");
    }

    private void methodNonScalarBytes(StringBuilder nestedBytes, String name, String NAME, int size, FieldModel model) {
        if (!model.isArray()) {
            nestedBytes.append("        ((Byteable) _").append(name).append(").bytes(bytes, ").append(NAME).append(");\n");
        } else {
            nestedBytes.append("       for (int i = 0; i < ").append(model.indexSize().value()).append("; i++){\n");
            nestedBytes.append("           ((Byteable) _").append(name).append("[i]).bytes(bytes, ").append(NAME);
            nestedBytes.append(" + (i * ").append(size).append("));\n");
            nestedBytes.append("       }\n");
        }
    }

    private int computeNonScalarOffset(DataValueModel dvmodel, Class type) {
        int offset = 0;
        DataValueModel dvmodel2 = dvmodel.nestedModel(type);
        Map<String, FieldModel> fieldMap2 = dvmodel2.fieldMap();
        Map.Entry[] entries2 = fieldMap2.entrySet().toArray(new Map.Entry[fieldMap2.size()]);
        Arrays.sort(entries2, COMPARE_BY_HEAP_SIZE);
        for (Map.Entry entry2 : entries2) {
            FieldModel model2 = (FieldModel)entry2.getValue();
            offset += this.computeOffset(model2.nativeSize() + 7 >> 3, model2);
        }
        return offset;
    }
}

