/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Random;
import java.util.Scanner;
import net.openhft.lang.Maths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Jvm {

    public static final String TMP = System.getProperty("java.io.tmpdir");
    private static final boolean IS64BIT = Jvm.is64Bit0();
    private static final Logger LOG = LoggerFactory.getLogger(Jvm.class);
    private static final int PROCESS_ID = Jvm.getProcessId0();
    private static final String OS = System.getProperty("os.name").toLowerCase();
    public static final int PID_BITS = Maths.intLog2(Jvm.getPidMax());

    public static boolean is64Bit() {
        return IS64BIT;
    }

    private static boolean is64Bit0() {
        String systemProp = System.getProperty("com.ibm.vm.bitmode");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("sun.arch.data.model");
        if (systemProp != null) {
            return "64".equals(systemProp);
        }
        systemProp = System.getProperty("java.vm.version");
        return systemProp != null && systemProp.contains("_64");
    }

    public static int getProcessId() {
        return PROCESS_ID;
    }

    private static int getProcessId0() {
        String pid = null;
        File self = new File("/proc/self");
        try {
            if (self.exists()) {
                pid = self.getCanonicalFile().getName();
            }
        }
        catch (IOException ignored) {
            // empty catch block
        }
        if (pid == null) {
            pid = ManagementFactory.getRuntimeMXBean().getName().split("@", 0)[0];
        }
        if (pid == null) {
            int rpid = new Random().nextInt(65536);
            LoggerFactory.getLogger(Jvm.class).warn("Unable to determine PID, picked a random number={}", (Object)rpid);
            return rpid;
        }
        return Integer.parseInt(pid);
    }

    public static long getUniqueTid() {
        return Jvm.getUniqueTid(Thread.currentThread());
    }

    public static long getUniqueTid(Thread thread) {
        return (long)Jvm.getProcessId() << 24 | thread.getId();
    }

    public static boolean isWindows() {
        return OS.startsWith("win");
    }

    public static boolean isMacOSX() {
        return OS.contains("mac");
    }

    public static boolean isLinux() {
        return OS.startsWith("linux");
    }

    public static boolean isUnix() {
        return OS.contains("nix") || OS.contains("nux") || OS.contains("aix") || OS.contains("bsd") || OS.contains("hpux");
    }

    public static boolean isSolaris() {
        return OS.startsWith("sun");
    }

    public static long getPidMax() {
        if (Jvm.isLinux()) {
            File file = new File("/proc/sys/kernel/pid_max");
            if (file.canRead()) {
                try {
                    return Maths.nextPower2(new Scanner(file).nextLong(), 1L);
                }
                catch (FileNotFoundException e) {
                    LOG.error("", (Throwable)e);
                }
            }
        } else if (Jvm.isMacOSX()) {
            return 0x1000000L;
        }
        return 65536L;
    }
}

