/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.serialization.impl;

import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.serialization.CompactBytesMarshaller;
import net.openhft.lang.model.constraints.NotNull;
import net.openhft.lang.model.constraints.Nullable;
import net.openhft.lang.pool.StringInterner;

public class StringMarshaller
implements CompactBytesMarshaller<String> {
    private final int size;
    private final StringBuilder reader = new StringBuilder(128);
    private StringInterner interner;

    public StringMarshaller(int size) {
        this.size = size;
    }

    @Override
    public void write(@NotNull Bytes bytes, String s) {
        bytes.writeUTF\u0394(s);
    }

    @Override
    @Nullable
    public String read(@NotNull Bytes bytes) {
        if (bytes.readUTF\u0394(this.reader)) {
            return this.builderToString();
        }
        return null;
    }

    private String builderToString() {
        if (this.interner == null) {
            this.interner = new StringInterner(this.size);
        }
        return this.interner.intern(this.reader);
    }

    @Override
    public byte code() {
        return 19;
    }
}

