/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io;

import java.nio.MappedByteBuffer;
import net.openhft.lang.io.NativeBytes;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

public class VanillaMappedBytes
extends NativeBytes {
    private final MappedByteBuffer buffer;
    private final long index;
    private boolean unmapped;

    public VanillaMappedBytes(MappedByteBuffer buffer) {
        this(buffer, -1L);
    }

    public VanillaMappedBytes(MappedByteBuffer buffer, long index) {
        super(((DirectBuffer)((Object)buffer)).address(), ((DirectBuffer)((Object)buffer)).address() + (long)buffer.capacity());
        this.buffer = buffer;
        this.unmapped = false;
        this.index = index;
    }

    public long index() {
        return this.index;
    }

    public synchronized boolean unmapped() {
        return this.unmapped;
    }

    @Override
    public void release() {
        if (!this.unmapped()) {
            super.release();
        }
    }

    @Override
    protected synchronized void cleanup() {
        if (!this.unmapped) {
            Cleaner cl = ((DirectBuffer)((Object)this.buffer)).cleaner();
            if (cl != null) {
                cl.clean();
            }
            this.unmapped = true;
        }
        super.cleanup();
    }

    public void force() {
        this.buffer.force();
    }
}

