/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.serialization.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.serialization.CompactBytesMarshaller;
import net.openhft.lang.model.constraints.Nullable;
import org.xerial.snappy.SnappyFramedInputStream;
import org.xerial.snappy.SnappyFramedOutputStream;

public enum SnappyStringMarshaller implements CompactBytesMarshaller<CharSequence>
{
    INSTANCE;

    private static final Constructor NEW_STRING;
    private static final Field VALUE;
    private static final int NULL_LENGTH = -1;

    @Override
    public byte code() {
        return 26;
    }

    @Override
    public void write(Bytes bytes, CharSequence s) {
        if (s == null) {
            bytes.writeStopBit(-1L);
            return;
        }
        bytes.writeStopBit(s.length());
        long position = bytes.position();
        bytes.clear();
        bytes.position(position + 4L);
        try {
            DataOutputStream dos = new DataOutputStream((OutputStream)new SnappyFramedOutputStream(bytes.outputStream()));
            dos.writeInt(s.length());
            char[] chars = (char[])VALUE.get(s);
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                this.writeStopBit(dos, chars[i]);
            }
            dos.flush();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        bytes.writeUnsignedInt(position, bytes.position() - position - 4L);
    }

    private void writeStopBit(DataOutputStream dos, int i) throws IOException {
        if (i < 128) {
            dos.write(i);
        } else if (i < 16384) {
            dos.write(i >>> 7 | 0x80);
            dos.write(i & 0x7F);
        } else {
            dos.write(i >>> 14 | 0x80);
            dos.write(i >>> 7 | 0x80);
            dos.write(i & 0x7F);
        }
    }

    @Override
    public String read(Bytes bytes) {
        return this.read(bytes, null);
    }

    @Override
    public String read(Bytes bytes, @Nullable CharSequence ignored) {
        String s;
        long size = bytes.readStopBit();
        if (size == -1L) {
            return null;
        }
        if (size < 0L || size > Integer.MAX_VALUE) {
            throw new IllegalStateException("Invalid length: " + size);
        }
        long length = bytes.readUnsignedInt();
        if (length < 0L || length > Integer.MAX_VALUE) {
            throw new IllegalStateException("Invalid length: " + length);
        }
        long position = bytes.position();
        long end = position + length;
        long limit = bytes.limit();
        bytes.limit(end);
        try {
            DataInputStream dis = new DataInputStream((InputStream)new SnappyFramedInputStream(bytes.inputStream()));
            int len = dis.readInt();
            char[] chars = new char[len];
            for (int i = 0; i < len; ++i) {
                chars[i] = this.readStopBit(dis);
            }
            s = (String)NEW_STRING.newInstance(chars, true);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        bytes.position(end);
        bytes.limit(limit);
        return s;
    }

    private char readStopBit(DataInputStream dis) throws IOException {
        int b0 = dis.read();
        if (b0 < 128) {
            return (char)b0;
        }
        int b1 = dis.read();
        if (b1 < 128) {
            return (char)((b0 & 0x7F) << 7 | b1);
        }
        int b2 = dis.read();
        return (char)((b0 & 0x7F) << 14 | (b1 & 0x7F) << 7 | b2);
    }

    static {
        try {
            NEW_STRING = String.class.getDeclaredConstructor(char[].class, Boolean.TYPE);
            NEW_STRING.setAccessible(true);
            VALUE = String.class.getDeclaredField("value");
            VALUE.setAccessible(true);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

