/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.serialization.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.serialization.BytesMarshaller;
import net.openhft.lang.io.serialization.CompactBytesMarshaller;
import net.openhft.lang.io.serialization.impl.CollectionMarshaller;

public class ListMarshaller<E>
extends CollectionMarshaller<E, List<E>>
implements CompactBytesMarshaller<List<E>> {
    ListMarshaller(BytesMarshaller<E> eBytesMarshaller) {
        super(eBytesMarshaller);
    }

    public static <E> BytesMarshaller<List<E>> of(BytesMarshaller<E> eBytesMarshaller) {
        return new ListMarshaller<E>(eBytesMarshaller);
    }

    @Override
    public byte code() {
        return 91;
    }

    @Override
    List<E> newCollection() {
        return new ArrayList();
    }

    @Override
    List<E> readCollection(Bytes bytes, List<E> es, int length) {
        Collection ret = this.newCollection();
        if (es == null || es.size() != length) {
            if (es == null) {
                es = Collections.emptyList();
            }
            Collection es2 = this.newCollection();
            for (int i = 0; i < length; ++i) {
                if (i < es.size()) {
                    ret.add(this.eBytesMarshaller.read(bytes, es.get(i)));
                    continue;
                }
                ret.add(this.eBytesMarshaller.read(bytes));
            }
            return es2;
        }
        for (int i = 0; i < length; ++i) {
            this.eBytesMarshaller.read(bytes, es.get(i));
        }
        return ret;
    }
}

