/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.serialization.impl;

import java.nio.ByteBuffer;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.serialization.CompactBytesMarshaller;
import net.openhft.lang.model.constraints.Nullable;

public enum ByteBufferMarshaller implements CompactBytesMarshaller<ByteBuffer>
{
    INSTANCE;


    @Override
    public byte code() {
        return 2;
    }

    @Override
    public void write(Bytes bytes, ByteBuffer byteBuffer) {
        bytes.writeStopBit(byteBuffer.remaining());
        bytes.write(byteBuffer);
    }

    @Override
    public ByteBuffer read(Bytes bytes) {
        return this.read(bytes, null);
    }

    @Override
    public ByteBuffer read(Bytes bytes, @Nullable ByteBuffer byteBuffer) {
        long length = bytes.readStopBit();
        if (length < 0L || length > Integer.MAX_VALUE) {
            throw new IllegalStateException("Invalid length: " + length);
        }
        if (byteBuffer == null || (long)byteBuffer.capacity() < length) {
            byteBuffer = this.newByteBuffer((int)length);
        } else {
            byteBuffer.clear();
        }
        byteBuffer.limit((int)length);
        bytes.read(byteBuffer);
        bytes.flip();
        return byteBuffer;
    }

    protected ByteBuffer newByteBuffer(int length) {
        return ByteBuffer.allocate(length);
    }
}

