/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.lang.io.serialization.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.serialization.CompactBytesMarshaller;
import net.openhft.lang.model.constraints.Nullable;

public class StringZMapMarshaller
implements CompactBytesMarshaller<Map<String, String>> {
    @Override
    public byte code() {
        return 26;
    }

    @Override
    public void write(Bytes bytes, Map<String, String> kvMap) {
        bytes.writeStopBit(kvMap.size());
        long position = bytes.position();
        bytes.clear();
        bytes.position(position + 4L);
        DataOutputStream dos = new DataOutputStream(new DeflaterOutputStream(bytes.outputStream()));
        try {
            for (Map.Entry<String, String> entry : kvMap.entrySet()) {
                dos.writeUTF(entry.getKey());
                dos.writeUTF(entry.getValue());
            }
            dos.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        bytes.writeUnsignedInt(position, bytes.position() - position - 4L);
    }

    @Override
    public Map<String, String> read(Bytes bytes) {
        return this.read(bytes, null);
    }

    @Override
    public Map<String, String> read(Bytes bytes, @Nullable Map<String, String> kvMap) {
        int size = (int)bytes.readStopBit();
        long length = bytes.readUnsignedInt();
        if (length < 16L || length > Integer.MAX_VALUE) {
            throw new IllegalStateException(new StreamCorruptedException());
        }
        long position = bytes.position();
        long end = position + length;
        long limit = bytes.limit();
        bytes.limit(end);
        DataInputStream dis = new DataInputStream(new InflaterInputStream(bytes.inputStream()));
        if (kvMap == null) {
            kvMap = new LinkedHashMap<String, String>();
        } else {
            kvMap.clear();
        }
        try {
            for (int i = 0; i < size; ++i) {
                String key = dis.readUTF();
                String value = dis.readUTF();
                kvMap.put(key, value);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        bytes.limit(limit);
        return kvMap;
    }
}

